/*
 * Your job is to implement the computation y* 2^x 
 * where y is a float and x is an integer without using any
 * floating-point operations.
 * For simplicity you can assume y is not denormalized (return 0 if it is).
 * You can use the code below as a guide.
 */

#include "fpwr2.h" 

/*********************************************** 
 * IMPORTANT: Please fill in this structure with 
 * your name and Andrew login ID
 ***********************************************/
team_struct team =
{
   /* Replace with full name of first team member */
   "",
   /* Replace with Andrew ID of first team member */
   ""
};

#define BIAS 127

float fpwr2(float y, int x) {
  union {
    unsigned u;
    float f;
  } result, yu;
  int exp, frac, y_exp, y_frac, y_sign;

  yu.f = y;
  y_exp = (yu.u >> 23) & 0xFF;
  y_frac = yu.u & 0x7FFFFF;
  y_sign = (yu.u >> 31);

  if ( y_exp == 255 ) {
    /* If y is NAN or INF. return y */
    exp = y_exp;
    frac = y_frac;
  } else if (y_exp == 0) {
    /* If y is Denormalized return 0.0 (to make it easier for you) */
    exp = 0;
    frac = 0;
  } else if ( ___ ) {
    /* Too small.  Return 0.0 */
    exp = 0;
    frac = 0;
  } else if ( ___ ) {
    /* Denormalized result (The most difficult) */
    exp = ___;
    frac = ___;
  } else if ( ___ ) {
    /* Normalized result. */
    exp = ___;
    frac = ___;
  } else {
    /* Too big.  Return +oo */
    exp = ___;
    frac = ___;
  }
  result.u = y_sign << 31 | exp << 23 | frac;
  return result.f;
}
