#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "fpwr2.h"

extern team_struct team;

#define ERRORS 3

/* Testing code.  You don't need to change any of this. */

/* Some useful macros */

/* Create a mask of bits HI through 0: */
/* Unsigned */
#define IBITS(HI) (((1u << (HI)) << 1) - 1u)

/* Create a mask of bits HI through LOW (must both be > 0): */
/* Unsigned */
#define IMASK(HI, LOW) (IBITS(HI) ^ IBITS((LOW)-1))

/* The following union constructs makes it possible to extract & manipulate
   the bit representation of a float
 */

typedef union {
  float f;
  unsigned u;
} bit_float_t;

float bit2float(unsigned u) {
  bit_float_t arg;
  arg.u = u;
  return arg.f;
}

unsigned float2bit(float f) {
  bit_float_t arg;
  arg.f = f;
  return arg.u;
}

void float_parts(float x) {
  unsigned sign, exp;
  unsigned significand;
  int sig_bits = 23;
  int exp_bits = 8;
  int bias = IBITS(exp_bits-2);
  bit_float_t arg;
  arg.f = x;

  /* Get sign bit */
  sign = (arg.u >> (sig_bits + exp_bits)) & IBITS(0);
  /* Get exp bits */
  exp = (arg.u >> sig_bits) & IBITS(exp_bits-1);
  /* Get significand bits */
  significand = arg.u & IBITS(sig_bits-1);

  /* Split into cases */
  if (exp == 0) {
    /* Denormalized */
    printf(
     "Denorm: s=%c, E=%d [0x%x], M=%e [0x%x], value=%e\n",
     sign ? '-' : '+', 
     1 - bias, exp,
     (double) significand / (double) (1<<sig_bits), significand,
     x); 
  } else if (exp < IBITS(exp_bits-1)) {
    /* Normalized */
    printf(
     "Norm: s=%c, E=%d [0x%x], M=%e [0x%x], value=%e\n",
     sign ? '-' : '+', 
     exp - bias, exp,
     1.0 + (double) significand / (double) (1<<sig_bits), significand,
     x); 
  } else if (significand == 0) {
    /* Infinity */
    printf("Infinity: s=%c, value=%e\n",
     sign ? '-' : '+',
     x); 
  } else {
    /* NaN */
    printf("NaN: s=%d, significand=%d [0x%x], value=%e\n",
     sign ? -1 : 1, 
     significand, significand,
     x); 
  }
}

/* Computation using library routine */
float lpwr2(float y, int x) {
  return (float) y * pow(2.0, (double) x);
}

int tp2exp(float y, int err) {
  int x;
  float f1,f2;
  for (x = -200; x < 200; x++) {
    f1 = fpwr2(y,x);
    f2 = lpwr2(y,x);
    if (f1 != f2) {
      if (err < ERRORS) {
	printf("%.10e * 2**%d: %.10e != %.10e\n", 
	       y, x, f1, f2);
	printf("y:        "); float_parts(y);
	printf("computed: "); float_parts(f1);
	printf("desired:  "); float_parts(f2);
	printf("\n");
      }
      err++;
    }
  }
  return err;
}

int main(int argc, char **argv) {
  int err=0;
  int x;
  float y, f1, f2;

  if (*team.name1 == '\0') {
    printf("WARNING: you must fill in the team structure in fpwr2.c\n\n");
  }

  if (argc == 3) {
      x = atoi(argv[1]);
      sscanf("%f",argv[2],&y);
      y = atof(argv[2]);
      f1 = fpwr2(y,x);
      f2 = lpwr2(y,x);
      printf("x       : %d\n",x);
      printf("y       : "); float_parts(y);
      printf("Computed: "); float_parts(f1);
      printf("Desired : "); float_parts(f2);
  } else {
    err = tp2exp(1e0,err);
    err = tp2exp(1e30,err);
    err = tp2exp(1.456234e-30,err);
    if (err) 
      printf("%d tests FAILED (first %d shown)\n\n", err, ERRORS);
    else
      printf("All tests PASSED\n\n");
  }
  return 0;
}
