/*

  defs.h

  Useful definitions for L4.

  DO NOT MODIFY ANYTHING IN THIS FILE

*/

#ifndef _DEFS_H_
#define _DEFS_H_

#include <stdlib.h>

typedef struct {
  char *team;
  char *name1, *email1;
  char *name2, *email2;
} team_t;

typedef struct {
  int *array;
  int rows;
  int cols;
} array_t;

/* Macro for accessing elements in the array. There is NO bounds-checking,
   so if you specify _i_ or _j_ out of bounds, Bad Things will happen to
   you (most likely a segmentation violation). */

/* Create an array of _rows_ x _cols_. */

#define ARRAY_CREATE(_array_, _rows_, _cols_) { \
  (_array_).array = malloc((_rows_) * (_cols_) * sizeof(int)); \
  (_array_).rows = _rows_; \
  (_array_).cols = _cols_; \
}

/* Destroy an array. */

#define ARRAY_DESTROY(_array_) { free((_array_).array); }

/* Return the number of columns or rows of the matrix. */

#define ARRAY_COLS(_array_) (_array_).cols
#define ARRAY_ROWS(_array_) (_array_).rows

/* Access the array element _array_[_i_][_j_]. You can use as a source or
   destination operand:

   value = ARRAY_ELEM(A, i, j);
   ARRAY_ELEM(A, i, j) = value;

*/

#define ARRAY_ELEM(_array_, _i_, _j_) (_array_).array[(_i_) * (_array_).cols + (_j_)]

extern team_t team;

#endif /* _DEFS_H_ */
