#include <signal.h>
#include <stdio.h>
#include <unistd.h>

typedef void (*sighandler_t)(int);

/* capture the signal USR1 and exit the program */
void
handleUSR1(int signal)
{
    printf("Caught a signal: %d\n", signal);

    // exit with code 15
    exit(15);
}

/* Create a child and wait for its exit */
int
main(int argc,
     char *argv[])
{
    int pid;
    sighandler_t oldHandler;

    pid = fork();
    if(pid) {
        // this is the code for the parent
        waitpid(pid, NULL, 0);
        printf("Child %d has exited\n", pid);
    } else {
        // this is the code for the child

        // install the new handler, keeping a pointer to the old handler
        oldHandler = signal(SIGUSR1, handleUSR1);

        // print the pid of this process
        printf("Child pid: %d\n", getpid());

        // go to sleep until we hear from the signal
        while(1) {
            sleep(1);
        }
    }
}
