#include <signal.h>
#include <stdio.h>
#include <unistd.h>

typedef void (*sighandler_t)(int);

/* the global variable used to wake up the program */
int awake = 0;

/* capture the signal USR1 and notify the program */
void
handleUSR1(int signal)
{
    printf("Caught a signal: %d\n", signal);
    awake = 1;
}

/* Create the signal handler, and then wait around for a signal */
int
main(int argc,
     char *argv[])
{
    sighandler_t oldHandler;

    // install the new handler, keeping a pointer to the old handler
    oldHandler = signal(SIGUSR1, handleUSR1);

    // print the pid of this process
    printf("pid: %d\n", getpid());

    // go to sleep until we hear from the signal
    while(!awake) {
        sleep(1);
    }

    // install the old handler
    signal(SIGUSR1, oldHandler);

    // exit
    return 0;
}
