/*
 * echo_forward - read and forward text lines until client closes connection
 *                 or server closes connection
 */
/* $begin echo_forward */
#include "csapp.h"

void echo_forward(int connfd, char *server, int server_port) 
{
    int   forwardfd;
    rio_t rio_conn, rio_forward;

    ssize_t n; 
    char buf[MAXLINE]; 

    /* connect to the server */
    forwardfd = Open_clientfd(server, server_port);
    Rio_readinitb(&rio_forward, forwardfd);

    Rio_readinitb(&rio_conn, connfd);
    while (1) {
      if ((n = Rio_readlineb(&rio_conn, buf, MAXLINE)) == 0)
        break;

      printf("proxy received %d bytes from client, forward to server\n", n);
      Rio_writen(forwardfd, buf, n);

      if ((n = Rio_readlineb(&rio_forward, buf, MAXLINE)) == 0)
        break;
      printf("proxy received %d bytes from server, forward to client\n", n);
      Rio_writen(connfd, buf, n);
    }

    Close(forwardfd);
}
/* $end echo_forward */

