 #include <X11/Xlib.h>
 #include <X11/Xutil.h>
 #include <X11/Xos.h>
 #include <X11/Xatom.h>

 #include <stdlib.h>
 #include <string.h>
 #include <stdio.h>
 #include "csapp.h"

 #define DISPLAY_LOG   "display.log"
 

 /*  Global variables  */
 
 static FILE * logfile = NULL;


 static Display *     display;
 static int           screen_num;
 static XFontStruct * font_info;
 static GC            gc;
 static int    msg_x, msg_y;     
 static char   message[255];
 static Window       win;      

 static int init_failed = 0;   // to keep track if initialization was okay
 
 /*  main() function  */

 int init_display_window (int argc, char ** argv) {

     /*  Window variables  */


     int          x, y;
     unsigned int width, height;
     unsigned int border_width;
     char *       window_name = "No. of Connections";
     char *       icon_name   = "No. Conn.";
     int    length;
     int    font_height;
     int    retval;
     char   *appname;

     /*  Display variables  */

     char *       display_name = NULL;
     unsigned int display_width, display_height;
    

     /*  Miscellaneous X variables  */

     XSizeHints *  size_hints;
     XWMHints   *  wm_hints;
     XClassHint *  class_hints;
     XTextProperty windowName, iconName;
     XEvent        report;
     XGCValues     values;     
     
     /* open display log for writing */
     
     logfile = Fopen(DISPLAY_LOG, "w");
         
     
     /*  Allocate memory for our structures  */

     if ( !( size_hints  = XAllocSizeHints() ) ||
          !( wm_hints    = XAllocWMHints()   ) ||
          !( class_hints = XAllocClassHint() )    ) {
         fprintf(stderr, "%s: couldn't allocate memory.\n", appname);
         init_failed = 1;         
         exit(-1);
     }

     appname = argv[0];

     /*  Connect to X server  */

     if ( (display = XOpenDisplay(display_name)) == NULL ) {
         fprintf(stderr, "%s: couldn't connect to X server %s\n",
                 appname, display_name);
         init_failed = 1;
         return(-1);
     }


     /*  Get screen size from display structure macro  */

     screen_num     = DefaultScreen(display);
     display_width  = DisplayWidth(display, screen_num);
     display_height = DisplayHeight(display, screen_num);


     /*  Set initial window size and position, and create it  */

     x = y = 0;
     width  = 350;
     height = 40;

     win = XCreateSimpleWindow(display, RootWindow(display, screen_num),
                               x, y, width, height, border_width,
                               BlackPixel(display, screen_num),
                               WhitePixel(display, screen_num));


     /*  Set hints for window manager before mapping window  */

     if ( XStringListToTextProperty(&window_name, 1, &windowName) == 0 ) {
         fprintf(stderr, "%s: structure allocation for windowName failed.\n",
                 appname);
         init_failed = 1;                 
         exit(-1);
     }

     if ( XStringListToTextProperty(&icon_name, 1, &iconName) == 0 ) {
         fprintf(stderr, "%s: structure allocation for iconName failed.\n",
                 appname);
         init_failed = 1;                 
         return(-1);
     }

     size_hints->flags       = PPosition | PSize | PMinSize;
     size_hints->min_width   = 200;
     size_hints->min_height  = 100;

     wm_hints->flags         = StateHint | InputHint;
     wm_hints->initial_state = NormalState;
     wm_hints->input         = True;

     class_hints->res_name   = appname;
     class_hints->res_class  = "hellox";

     XSetWMProperties(display, win, &windowName, &iconName, argv, argc,
                      size_hints, wm_hints, class_hints);


     /*  Choose which events we want to handle  */

     XSelectInput(display, win, ExposureMask | KeyPressMask |
                  ButtonPressMask | StructureNotifyMask);


     /*  Load a font called "9x15"  */

     if ( (font_info = XLoadQueryFont(display, "9x15")) == NULL ) {
         fprintf(stderr, "%s: cannot open 9x15 font.\n", appname);
         init_failed = 1;         
         return(-1);
     }


     /*  Create graphics context  */

     gc = XCreateGC(display, win, 0, &values);

     XSetFont(display, gc, font_info->fid);
     XSetForeground(display, gc, BlackPixel(display, screen_num));


     /*  Display Window  */

     XMapWindow(display, win);

    
     /*  Enter event loop  */


     XNextEvent(display, &report);


     /*  Output message centrally in window  */




     font_height = font_info->ascent + font_info->descent;
     msg_y  = (height + font_height) / 2;
       
     font_height = 0; // reusing font_height variable

     sprintf(message, "Number of Connections = %d", font_height);
     
     length = XTextWidth(font_info, message, strlen(message));
     msg_x  = (width - length) / 2;     
     
     XDrawString(display, win, gc, msg_x, msg_y, message, strlen(message));

     XFlush(display);
       
     return EXIT_SUCCESS;   
 }



int destroy_window ( ) {

     Fclose(logfile);       // close logfile
    
     if (init_failed == 1)  // xlib was not initialized properly
         return 0;
         
     XUnloadFont(display, font_info->fid);
     XFreeGC(display, gc);
     XCloseDisplay(display);
     return(EXIT_SUCCESS);
}    

int change_display (int new_num) {
    
    int retval;

    fprintf(logfile, "%d\n", new_num); // write new value to logfile

    fflush(logfile);        // flush output to logfile
    
    if (init_failed == 1)   // xlib was not initialized properly
        return 0;
        
    sprintf(message,"Number of Connections = %d", new_num);
     
    XClearWindow(display, win);
         
    XDrawString(display, win, gc, msg_x, msg_y, message, strlen(message));

    XFlush(display);
    
    return(EXIT_SUCCESS);
    
}
