package com.mpaa.decss;


/**
 * Title:       TitleKey.java
 * Description: Class that represents a 40 bit title key.
 * @author DiatriBe
 * @version 1.0
 */

public class TitleKey
{
	private int[] key = new int[5];


	public TitleKey()
	{
	}

	public TitleKey(int keyPart0, int keyPart1, int keyPart2, int keyPart3, int keyPart4)
	{
		key[0] = keyPart0;
		key[1] = keyPart1;
		key[2] = keyPart2;
		key[3] = keyPart3;
		key[4] = keyPart4;
	}

	public TitleKey(String keyPart0, String keyPart1, String keyPart2, String keyPart3, String keyPart4)
	{
		key[0] = Integer.parseInt(keyPart0, 16);
		key[1] = Integer.parseInt(keyPart1, 16);
		key[2] = Integer.parseInt(keyPart2, 16);
		key[3] = Integer.parseInt(keyPart3, 16);
		key[4] = Integer.parseInt(keyPart4, 16);
	}

	public int getAt(int index)
	{
		return key[index];
	}

	public void setAt(int index, int value)
	{
		key[index] = value;
	}

	public String toString()
	{
		String keyString = new String();

		for (int index = 0; index < key.length; index++)
		{
			String keyPartString = (Integer.toHexString(key[index])).toUpperCase();

			if (keyPartString.length() == 1)
				keyString += " 0" + keyPartString;
			else
				keyString += " " + keyPartString;
		}
		return keyString;
	}
}

