/*
 * Decompiled with CFR 0.152.
 */
final class TrackChunk {
    public static final String TRACK_TYPE = "MTrk";
    private byte[] bytes;
    private int chunklen = 0;
    private int arySize;
    private boolean haveSpace = false;
    private boolean haveNL = false;

    public TrackChunk(int n) {
        this.arySize = n;
        this.bytes = new byte[this.arySize];
    }

    public TrackChunk() {
        this(32);
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.chunklen];
        System.arraycopy(this.bytes, 0, byArray, 0, this.chunklen);
        return byArray;
    }

    public void addBytes(byte[] byArray) {
        if (this.chunklen + byArray.length > this.arySize) {
            int n = Math.max(this.chunklen + byArray.length, this.arySize * 2);
            byte[] byArray2 = new byte[n];
            System.arraycopy(this.bytes, 0, byArray2, 0, this.chunklen);
            this.arySize = n;
            this.bytes = byArray2;
        }
        System.arraycopy(byArray, 0, this.bytes, this.chunklen, byArray.length);
        this.chunklen += byArray.length;
    }

    public void addByte(byte by) {
        if (this.chunklen + 1 > this.arySize) {
            int n = this.arySize * 2;
            byte[] byArray = new byte[n];
            System.arraycopy(this.bytes, 0, byArray, 0, this.chunklen);
            this.arySize = n;
            this.bytes = byArray;
        }
        this.bytes[this.chunklen++] = by;
    }

    public void addVarLen(int n) {
        int n2 = n & 0x7F;
        while ((n >>= 7) != 0) {
            n2 <<= 8;
            n2 |= n & 0x7F | 0x80;
        }
        while (true) {
            this.addByte((byte)(n2 & 0xFF));
            if ((n2 & 0x80) == 0) break;
            n2 >>= 8;
        }
    }

    public void addText(String string) {
        this.addByte((byte)-1);
        this.addByte((byte)3);
        this.addVarLen(string.length());
        this.addBytes(string.getBytes());
    }

    public void endTrack() {
        byte[] byArray = new byte[]{0, -1, 47, 0};
        this.addBytes(byArray);
    }

    private void realWriteData(byte by) {
        this.addVarLen(0);
        this.addByte((byte)-112);
        this.addByte(by);
        this.addByte((byte)127);
        int n = this.haveNL ? 48 : (this.haveSpace ? 24 : 12);
        this.addVarLen(n);
        this.addByte((byte)-128);
        this.addByte(by);
        this.addByte((byte)127);
        this.haveNL = false;
        this.haveSpace = false;
    }

    public void writeDataByte(byte by) {
        if (by > 127) {
            throw new IllegalArgumentException("Notes must be between 0 and 127");
        }
        switch (by) {
            case 9: 
            case 32: {
                this.haveSpace = true;
                break;
            }
            case 10: 
            case 13: {
                this.haveNL = true;
                break;
            }
            default: {
                this.realWriteData(by);
            }
        }
    }
}

