structure Test =
struct
  fun testName n = if n < 10 then ("t0" ^ Int.toString n)
                   else ("t" ^ Int.toString n)

  fun sameContents (f1, f2) =
    let fun loop (strm1, strm2) =
          let val c1 = TextIO.input1 strm1
              val c2 = TextIO.input1 strm2
          in if c1=c2
             then (if c1=NONE then true else loop(strm1, strm2))
             else false
          end
       val strm1 = TextIO.openIn f1
       val strm2 = TextIO.openIn f2
       val result = loop (strm1, strm2)
       val _ = (TextIO.closeIn strm1; TextIO.closeIn strm2)
    in result end

  fun clearContents f =
    let val strm = TextIO.openOut f
    in (TextIO.output (strm, " "); TextIO.closeOut strm) end

  fun test n =
    let val t = testName n
    in (clearContents ("test/."^t^".c");
        BabelBuster.ctc2 ("test/"^t^".c", "test/."^t^".c.correct");
        BabelBuster.cte2 ("test/"^t^".c", "test/."^t^".e");
        BabelBuster.etc2 ("test/."^t^".e", "test/."^t^".c");
        if sameContents ("test/."^t^".c.correct", "test/."^t^".c")
        then (print ("test "^t^" ok\n");true)
        else (print ("test "^t^" failed\n");false)) end

  fun t s =
    (clearContents ".test.c";
     BabelBuster.ctc2 (s, ".test.c.correct");
     BabelBuster.cte2 (s, ".test.e");
     BabelBuster.etc2 (".test.e", ".test.c");
     if sameContents (".test.c", ".test.c.correct")
     then (print ("test "^s^" ok\n");true)
     else (print ("test "^s^" failed\n");false))

  (* Note: 3 tests known to fail.  This is because old-style
     parameter declarations are converted to normal parameter
     decs in translation to English, but the pretty-printer
     can still print them as old-style decs.                  *)
  fun ckitTests () =
    let val strm = TextIO.openIn ".ckit_progs"
        val prefix = "../ckit/regression/valid-programs/"
        fun fName s = prefix ^ (String.substring (s, 0, (String.size s) - 1))
        fun f () = if TextIO.endOfStream strm then 0
                   else (if t (fName (TextIO.inputLine strm)) then 0 else 1)
                        + f()
        val nFailed = f()
        val _ = TextIO.closeIn strm
    in if nFailed=0 then print "All ckit tests ok\n"
       else print ((Int.toString nFailed)^" tests failed\n")end

  fun regress n =
    let fun loop 0 = 0
          | loop n = (loop (n-1) + (if test n then 0 else 1))
        val nFailed = loop n
    in if nFailed=0 then print "All tests ok\n"
       else print ((Int.toString nFailed)^" tests failed\n") end
end
