structure Parse :
sig
  val tidtab : Bindings.tidBinding Tidtab.uidtab
  val parseFile : Error.errorState -> string -> Ast.ast
end =
struct
  structure CttLrVals = CttLrValsFun(structure Token = LrParser.Token)
  structure CttLex = CttLexFun(structure Tokens = CttLrVals.Tokens)
  structure CttP = JoinWithArg(structure ParserData = CttLrVals.ParserData
                               structure Lex=CttLex
                               structure LrParser = LrParser)
  val tidtab : Bindings.tidBinding Tidtab.uidtab = Tidtab.uidtab()
  fun parseFile errState f =
    let
        val sourceMap = SourceMap.newmap{srcFile = f}

	fun lexErr (p1, p2, msg) =
	  Error.error (errState, SourceMap.location sourceMap (p1, p2), msg)
	fun lexWarn (p1, p2, msg) =
	  Error.warning (errState, SourceMap.location sourceMap (p1, p2), msg)
	fun parseErr (msg, p1, p2) =
	  Error.error (errState, SourceMap.location sourceMap (p1, p2), msg)

        val instrm = TextIO.openIn f
        fun inputc instrm i = TextIO.inputN(instrm, i)
        val lookahead = 15

        val lexArg = {sm = sourceMap
                     }

        val lexer = LrParser.Stream.streamify (CttLex.makeLexer (inputc instrm) lexArg)
        val (ast, _) = CttP.parse(lookahead, lexer, parseErr,
                                  (tidtab, sourceMap))
        val _ = TextIO.closeIn instrm
       in ast
      end
      handle CttP.ParseError =>
	(TextIO.output(Error.errStream errState,"ParseError raised\n");
	 [])

end

