structure EnglishToAst :> ENGLISH2AST =
struct
(*
  val tidtab : Bindings.tidBinding Tidtab.uidtab = Tidtab.uidtab()
*)
  val tidtab : Bindings.tidBinding Tidtab.uidtab = Parse.tidtab
                                   (* The table of type identifiers *)
  val aidtab : Tables.aidtab = Aidtab.uidtab()
                                   (* I don't care about adornments *)
  val implicits : Tables.aidtab = Aidtab.uidtab()
                                   (* I don't care about implicit coercions *)
  val errState = Error.mkErrState TextIO.stdErr
  val env : State.symtab = State.ST.empty
  fun englishToAst fileName =
       {ast=Parse.parseFile errState fileName, tidtab=tidtab,
        errorCount=Error.errorCount errState,
        warningCount=Error.warningCount errState,
        auxiliaryInfo={aidtab=aidtab, implicits=implicits, env=env}}
end
