/*
 * Decompiled with CFR 0.152.
 */
package unsa;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import unsa.StableCanvas;

public class Turtle
extends JFrame {
    private StableCanvas ardoise;
    private static final int WIDTH = 400;
    private static final int HEIGHT = 400;
    private boolean penDown;
    private Color penColor = Color.black;
    private double xcor;
    private double ycor;
    private double heading;
    private static int pos = 30;
    private static final double T180SURPI = 57.29577951308232;
    private static final double TPISUR180 = Math.PI / 180;

    public Turtle() {
        super("Turtle" + pos / 30);
        this.setResizable(false);
        ((Component)this).setLocation(pos += 30, pos);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.ardoise = new StableCanvas(400, 400);
        container.add((Component)this.ardoise, "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Quitter");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jPanel.add(jButton);
        container.add((Component)jPanel, "South");
        this.clean();
        this.pack();
        this.show();
    }

    public void back(double d) {
        this.forward(-d);
    }

    public void clean() {
        this.ardoise.clear();
        this.heading = 0.0;
        this.ycor = 0.0;
        this.xcor = 0.0;
        this.penDown = true;
    }

    static double deg2rad(double d) {
        return d * (Math.PI / 180);
    }

    public void forward(double d) {
        double d2 = Turtle.deg2rad(this.heading);
        this.setPosition(this.xcor + d * Math.sin(d2), this.ycor + d * Math.cos(d2));
    }

    public double heading() {
        return this.heading;
    }

    public void left(double d) {
        this.setHeading(this.heading - d);
    }

    public Color penColor() {
        return this.penColor;
    }

    public boolean penDown() {
        return this.penDown;
    }

    static double rad2deg(double d) {
        return d * 57.29577951308232;
    }

    public void right(double d) {
        this.setHeading(this.heading + d);
    }

    public void setHeading(double d) {
        this.heading = d % 360.0;
    }

    public void setPenColor(Color color) {
        this.penColor = color;
        this.ardoise.setColor(color);
    }

    public void setPenDown() {
        this.penDown = true;
    }

    public void setPenUp() {
        this.penDown = false;
    }

    public void setPosition(double d, double d2) {
        if (this.penDown) {
            this.ardoise.drawLine(200 + (int)this.xcor, 200 - (int)this.ycor, 200 + (int)d, 200 - (int)d2);
        }
        this.xcor = d;
        this.ycor = d2;
    }

    public Vector state() {
        Vector<Serializable> vector = new Vector<Serializable>();
        vector.add(new Boolean(this.penDown));
        vector.add(this.penColor);
        vector.add(new Double(this.xcor));
        vector.add(new Double(this.ycor));
        vector.add(new Double(this.heading));
        return vector;
    }

    public double xcor() {
        return this.xcor;
    }

    public double ycor() {
        return this.ycor;
    }
}

