;; This file defines "humans" and their characteristics
;; e.g. "height", "weight", "eye-color", "sexual-orientation"
;; it also includes  tests  for  desired characteristics such as "tallp", "proportionalp"
;; and the mechanism of  deciding which gender(s) make appropriate dates for a person  
;; the package "dating" is loaded
(in-package :dating)



(define-unit dating-worlds
  (member-of 'collections)
)

(define-unit potential-dates
  (member-of 'many-valued-slots)
  (makes-sense-for 'dating-worlds)
  (must-be 'humans)
  )
(define-unit my-dating-world
  (member-of 'single-valued-slots)
  (makes-sense-for 'humans)
  (must-be 'dating-worlds)
  (inverse-slot 'potential-dates))

(define-unit culture-vulture
  (member-of 'collections)
  (supersets 'humans)
  (members-have '(does-activities culture))
)

(define-unit rapper
  (member-of 'collections)
  (supersets 'humans)
  (members-have '(does-activities rap))
)

(define-unit punk-rocker
  (member-of 'collections)
  (supersets 'humans)
  (members-have '(does-activities punk-rock))
)

(define-unit bar-hopper
  (member-of 'collections)
  (supersets 'humans)
  (members-have '(does-activities bar-hopping))
)


(define-unit reader
  (member-of 'collections)
  (supersets 'humans)
  (members-have '(does-activities books))
)


(define-unit skiier
  (member-of 'collections)
  (supersets 'humans)
  (members-have '(does-activities skiing))
)


(define-unit downhill-skiier
  (member-of 'collections)
  (supersets 'humans)
  (members-have '(does-activities downhill))
)

(define-unit x-country-skiier
  (member-of 'collections)
  (supersets 'humans)
  (members-have '(does-activities x-country))
)


;; define some physical characteristics
;; a person's   physical characteristics have a value
;; the physical characteristics a person is looking for are expressed by a test,  which
;; will be applied to the  appropriate characteristics of the other person

(define-unit weight
  (member-of 'single-valued-slots)
  (makes-sense-for 'humans)
  (must-be 'anythingp)
  )

(define-unit want-weight
  (member-of 'single-valued-slots)
  (makes-sense-for 'humans)
  (eager-composition-of '(weight ideal-person )))


(define-unit age
  (member-of 'single-valued-slots)
  (makes-sense-for 'humans)
  (must-be 'anythingp)
  )

(define-unit want-age
  (member-of 'single-valued-slots)
  (makes-sense-for 'humans)
  (eager-composition-of '(age ideal-person )))




(define-unit height
  (member-of 'single-valued-slots)
  (makes-sense-for 'humans)
  (must-be 'anythingp)
  )

(define-unit want-height
  (member-of 'single-valued-slots)
  (makes-sense-for 'humans)
  (eager-composition-of '(height ideal-person )))

(define-unit hair-color
(member-of 'single-valued-slots)
  (makes-sense-for 'humans)
  (must-be 'hair-colors)
  )

(define-unit want-hair-color
  (member-of 'single-valued-slots)
  (makes-sense-for 'humans)
  (eager-composition-of '(hair-color ideal-person )))

(define-unit eye-color
  (member-of 'single-valued-slots)
  (makes-sense-for 'humans)
  (must-be 'eye-colors)
  )

(define-unit ontological-status
  (member-of 'single-valued-slots)
  (makes-sense-for 'humans)
  (must-be 'ontological-statuses)
  )

(define-unit want-eye-color
  (member-of 'single-valued-slots)
  (makes-sense-for 'humans)
  (eager-composition-of '(eye-color ideal-person )))

(define-unit sexual-orientation
  (member-of 'single-valued-slots)
  (makes-sense-for 'humans)
;; keeps options open if person has not specified an  orientation
  (value-defaults-to 'bisexual)
  (must-be 'sexual-orientations)
  )

(define-unit want-sexual-orientation
  (member-of 'single-valued-slots)
  (makes-sense-for 'humans)
  (must-be 'anythingp)
  )

;; this slot computes the  gender of the desired  person, based on  a  person's 
;; gender and sexual orientation.  e.g.  a  homosexual  female is looking for a  female
(define-unit want-gender
  (works-like 'prototypical-slot)
  (makes-sense-for 'humans)
  (must-be 'lisp-objectp)
  (to-compute-value 'get-want-gender)
  )
;;  this function seems to evoke an  error  the first  time it is used (by match-pair)
;; if  used   again it works

(deffcn get-want-gender (p slot)
  (declare (ignore slot))
;;     bisexuals  will take any  person
  (if  (query p 'sexual-orientation 'bisexual)  
    '(lambda (x) (satisfies? x 'humans))
;;     asexuals will not take anyone
    (if  (query p 'sexual-orientation 'asexual)  
      '(lambda (x) ())
;;     straight men and gay  women want  women
      (if (or (and (query p 'member-of 'men)
                   (query p  'sexual-orientation 'heterosexual))
              (and (query p 'member-of 'women)
                   (query p 'sexual-orientation 'homosexual)))
        '(lambda (x) (satisfies? x 'women))
;;     straight  women and gay men  want men
        (if (or (and (query p 'member-of 'women)
                 (query p  'sexual-orientation 'heterosexual))
            (and (query p 'member-of 'men)
                 (query p 'sexual-orientation 'homosexual)))
        '(lambda (x) (satisfies? x 'men))
;; this is here because this  function does not pick up  on the default  sexual orientation
        '(lambda (x) (satisfies? x 'humans))     
        )
))))
      
;; some basic  characteristics
(define-unit eye-colors
  (member-of 'collections))

(define-unit ontological-statuses
  (member-of 'collections))

(define-unit hair-colors
  (member-of 'collections))

(define-unit sexual-orientations
  (member-of 'collections))


;; possible ontological statuses
(define-unit real-person
  (member-of 'ontological-statuses))

(define-unit idealized-person
  (member-of 'ontological-statuses))


;; possible sexual orientations
(define-unit heterosexual
  (member-of 'sexual-orientations)
)

(define-unit homosexual
  (member-of 'sexual-orientations)
)

(define-unit bisexual
  (member-of 'sexual-orientations)
)

(define-unit asexual
  (member-of 'sexual-orientations)
)

;; possible hair colors
(define-unit blond
  (member-of  'hair-colors))

(define-unit brunette
  (member-of  'hair-colors))

(define-unit red-head
  (member-of  'hair-colors))

;;  possible eye colors
(define-unit brown
  (member-of  'hair-colors)
  (member-of 'eye-colors)
  )

(define-unit blue
  (member-of 'eye-colors))

(define-unit hazel
  (member-of 'eye-colors))

(define-unit green
  (member-of 'eye-colors))

(define-unit grey
  (member-of 'eye-colors))

;;  here are some  tests for physical characteristics

;;  note that definition of tall depends on a person's  gender
;;  at the moment  we assume height in inches
(deffcn tallp (p)
  (annotations (works-like lisp-test))
;; don't bomb if the person doesn't have a height
;; perhaps should have a way of distinguishing no value vrs. insufficient value
  (and (not (failurep (get-value p 'height)))
       (if (satisfies? p 'men)
         (> (get-value p 'height) 71)
         (> (get-value p  'height) 68))))

(deffcn shortp (p)
  (annotations (works-like lisp-test))
;; don't bomb if the person doesn't have a height
;; perhaps should have a way of distinguishing no value vrs. insufficient value
  (and (not (failurep (get-value p 'height)))
       (if (satisfies? p 'men)
         (< (get-value p 'height) 65)
         (> (get-value p  'height) 61))))

(deffcn medium-heightp (p)
  (and (not (shortp p))  (not (tallp p))))
                        

;; a rough definition
(deffcn proportionalp (p)
  (annotations (works-like lisp-test))
;; don't bomb if the person doesn't have a height or weight
;; perhaps should have a way of distinguishing no value vs. insufficient value
  (and (not (failurep (get-value p 'height)))
       (not (failurep (get-value p 'weight)))
       (> (get-value p 'weight) (* (get-value p 'height) 1.5))
       (< (get-value p 'weight) (* (get-value p 'height) 3))))

;; lump the personal  characteristics  together
;;   not  used  yet
(define-unit personal-characteristics
  (member-of 'many-valued-slots)
  (makes-sense-for 'humans)
  (spec-slots 'has-traits)
  (spec-slots 'does-activities) 
  (spec-slots 'weight)
  (spec-slots 'height)
  (spec-slots 'age)
  (spec-slots 'hair-color)
  (spec-slots 'eye-color)
  (spec-slots 'sexual-orientation)
  (spec-slots 'gender)
)

;; these are  tests  to be applied  to  potential  love-objects

(define-unit love-object-tests
  (member-of 'many-valued-slots)
  (makes-sense-for 'humans)
  (spec-slots 'want-weight)
  (spec-slots 'want-height)
  (spec-slots 'want-age)
  (spec-slots 'want-hair-color)
  (spec-slots 'want-eye-color)
;; we  will make a distiction between things which are requirements   versus  preferences
  ;;(spec-slots 'want-sexual-orientation)
  ;;(spec-slots 'want-gender)
)
