;; This file define the dating  package, and imports functions from arlotje
;;  It is also a guide to the dating package


;; define the dating package
(defpackage :dating (:nicknames personals date) (:use :lisp :arlotje :huh))

;; import needed functions which are not exported from arlotje
(import '(aj::collectionp) 'dating)
(import '(aj::testp) 'dating)

;; The  purpose of the dating package is to match up people who are  looking
;; for dates
;; A "dating-world" contains "potential-dates". Each potential-date is a "person"
;; Each person may have characteristics such as  height, and eye-color
;;  - see file humans.lisp
;; A  person may also have traits such as "warm", "ambitious" etc.
;;  - see  file traits.lisp
;; A  person may engage in activities such as "skiing", and kinds of activities
;;   such as "winter-sports"
;;  - see file activities.lisp
;; 
;; There are files which create words for these arlotje units.
;;  - see humans-words.lisp, traits-words.lisp, activities-words.lisp

;; Four aspects are considered when matching people up
;; 1) Compatibility  of the gender and sexual orientation of the people
;; 2) "love-object-tests" are tests for the desired person's height, etc.
;;    - see file person.lisp
;; 3) "wants-traits" - the traits wanted in the desired  person - see traits.lisp
;; 4) which "does-activities" the people have in common.

;; The functions for doing the matching combine the results of these factors
;;  - see  file match.lisp

;; The "all-matches" slot of a dating-world will produce a list of match lists.
;; Each match list is with first element the  person, and second element
;; a list of pairs of the form (person compatibility-score), in order of
;; decreasing compatibility score 
;; output is printed out  in  the form:

;;matching FATTY
;;best matches (((EZRA 5) (DONNA 4) (JOHN 3) (JOSHUA 2) (LINDA 2)))
;;matching LINDA
;;best matches (((DONNA 6) (EZRA 5) (JOHN 5) (JOSHUA 2) (FATTY 2)))
;;matching JOSHUA
;;best matches (((DONNA 7) (LINDA 6)))
;;matching DONNA
;;best matches (((EZRA 5) (FATTY 2) (JOHN 2) (JOSHUA 1)))
;;matching EZRA
;;best matches (((DONNA 2) (FATTY 2) (JOSHUA 1) (LINDA 1) (JOHN 1))
;; etc.

;; the function "return-person-matches  (subject-person object-person)"
;; will return  a list  of lists of the three types of matches
;; (funcall 'return-person-matches 'donna 'ezra) yields
;;  ((TALLP PROPORTIONALP)                  ;; the want-tests  satisfied
;;   ((SENSITIVE SENSITIVE) (WARM WARM))    ;; the  want-traits matched
;;   ((SKIING X-COUNTRY)))                  ;; the common activities

;; HUH implementation

;; Case-frames for verbs are in the file verbs.lisp
;; Parsers are in the file parsers.lisp

;; Currently a typical personal ad would be:
;; (read-text "SF 32 warm intelligent seeks politically active  sm for skiing.
;; I am blond 120 lbs. You must be a tall funny man."

;; All ads must currently begin with an "x seek-verb y" sentence.
;; The seek-verbs are: seek, desire, want. x and y are (optionally
;;    determinerless) noun-phrases
;; The "seeker" is automatically added to  the *current-dating-world*
;; A variety of requests such as "Find all matches." will cause all  the
;; matches to be computed.