;; This is the init file for the dating package
;;  It indicates where lisp is to be found (Startup-disk:Languages:Lisp 1.3.2)
;;  and where  the dating code is  to be found (Startup-disk:art-of-ai:dating-version3)
;;  All the necessary files are then loaded
;;  Once loading is complete, type "(in-package 'dating)" in the listener before
;;  using the dating package.
;;  See the file dating-package.lisp for more information about the dating package

(in-package :ccl)
(setq ccl::*listener-default-font-spec* '("geneva" 9))
(format t "loading dating init")
(setq ccl::*load-verbose* t)
(let* ((directory (pathname-directory (mac-default-directory)))
       (Startup-disk (subseq directory 0 (1+ (search ":" directory)))))
  (ccl::def-logical-pathname "ccl" (concatenate 'string Startup-disk "Languages:Lisp 1.3.2:"))
  (def-logical-pathname "DT" (concatenate 'string Startup-disk "art-of-ai:dating-version3:"))
  (def-logical-pathname "AI" (concatenate 'string Startup-disk "art-of-ai:"))
  )
(setq ccl::*save-local-symbols* t)
(setq ccl::*fasl-save-local-symbols* t)

(ed "DT;dating-init.lisp")

(load "DT;dating-package.lisp")

;; open windows to edit any files of interest
;;(ed "DT;activities.lisp")
;;(ed "DT;world.lisp")
(ed "DT;dating-parsers.lisp")
(ed "DT;dating-tests.lisp")

;; load   files in the correct order
(load "DT;activities.lisp")
(load "DT;traits.lisp")
(load "DT;humans.lisp")
(load "DT;match.lisp")
(load "DT;world.lisp")
(load "DT;activities-words.lisp")
(load "DT;humans-words.lisp")
(load "DT;traits-words.lisp")
(load "DT;verbs.lisp")
(load "DT;dating-parsers.lisp")
(load "DT;huh-world.lisp")

