;;;; Root directory

(defvar *art-of-ai-root-dir*
  #+LUCID (directory-namestring lucid::*source-pathname*)
  #+:CORAL (directory-namestring (car ccl::*loading-files*))
  #+GENERA (concatenate 'string
			(host-namestring sys:fdefine-file-pathname)
			":"
			(directory-namestring sys:fdefine-file-pathname)
			"/")
  #+NEXT (directory-namestring *source-pathname*)
  #-(OR LUCID :CORAL GENERA NEXT) ""
  "This is the root dir for ART of AI sources.")

;;;; Special features

#+CCL-2 (push :CL2 *features*)
#+CCL-2 (push :APPLE *features*)

;;;; Support for loading

(load (concatenate 'string *art-of-ai-root-dir* "common-load.lisp"))
(load (concatenate 'string *art-of-ai-root-dir* "packages.lisp"))
(load (concatenate 'string *art-of-ai-root-dir* "stubs.lisp"))

(use-package :loader)

;; Patch for buggy #+ in MACL 1.3
#+:CCL-1.3 (push 'HUH::APPLE *features*)
#+:CCL-1.3 (push 'AJ::APPLE *features*)

;;;; Important pathnames

(defparameter aj::*arlotje-directory*
  (kludge-pathname *art-of-ai-root-dir* "arlotje" ""))
(defparameter aj::*session-directory*
  (kludge-pathname *art-of-ai-root-dir* "arlotje" "sessions" ""))
(defparameter aj::*unit-directory*
  (kludge-pathname *art-of-ai-root-dir* "arlotje" "units" ""))
(defparameter huh::*huh-directory*
  (kludge-pathname *art-of-ai-root-dir* "huh" ""))

;;;; Load the loaders

(load (kludge-pathname *art-of-ai-root-dir* "loaders" "arlotje.lisp"))
(load (kludge-pathname *art-of-ai-root-dir* "loaders" "huh.lisp"))

(let ( #+GENERA (sys:inhibit-fdefine-warnings :just-warn))
  (aj::update-arlotje)
  (huh::update-huh)
  (cond ((member :clim *features*)
	 (update-file (kludge-pathname *art-of-ai-root-dir* "interfaces" "clim"))))
  (aj::user-init))

(defun huh::load-stories ()
  (load (kludge-pathname *art-of-ai-root-dir* "stories" "episodes.lisp"))
  (load (kludge-pathname *art-of-ai-root-dir* "stories" "excuses.lisp"))
  (use-package '(:stories :restaurant)))

(shadowing-import '( #+MACL aj::listener
		     #+GENERA aj:methods #+GENERA aj:color
		    #+CLIM aj:gensymbol aj:radius aj:x2 aj:x1 origin huh:color)
		  :user)
(use-package :aj :user)
(use-package :huh :user)
(use-package :aji :user)
