;;; -*- Syntax: Common-Lisp; Base: 10; Mode: LISP; Package: (HUH :use (lisp arlotje)) -*-

(in-package :huh)

(defvar huh::*huh-package* (find-package :huh))

(defparameter *huh-files*
  '("words" "grammars" "reference" "generate" "dinglish"
    "case-frames" "expectation" "top-level"
    "restaurant-background" "restaurant-script"
    ))

(defun load-huh ()
  (aj::loaded-session "Loading HUH" '(format T "~&\; HUH better be loaded already!"))
  (DOLIST (file *huh-files*)
    (load-file (merge-pathnames file *huh-directory*))))
(defun load-huh-source ()
  (aj::loaded-session "Loading HUH" '(format T "~&\; HUH better be loaded already!"))
  (dolist (file *huh-files*)
    (load-source-file (merge-pathnames file *huh-directory*))))
(defun update-huh ()
  (aj::loaded-session "Loading HUH" '(format T "~&\; HUH better be loaded already!"))
  (dolist (file *huh-files*)
    (update-file (merge-pathnames file *huh-directory*))))
(defun recompile-huh ()
  (aj::loaded-session "Loading HUH" '(format T "~&\; HUH better be loaded already!"))
  (dolist (file *huh-files*)
    (recompile-file (merge-pathnames file *huh-directory*))))

(export '(parse define-parser define-parser-macro defcase define-script
	  with-continuity continuing-with 
	  read-text read-story continue-story say answer read-words-from-string
	  trace-parser trace-reference trace-expectation trace-analogy
	  has-prop interpretation satisfies is-exactly-one-of exactly-matches
	  noise-word the-rest-of-the-sentence up-till up-till-or-end
	  the-end-of-the-sentence parse-eval
	  random-ref define-word define-adjective
	  register-word create-object extend-object
	  find-discourse-reference discourse-reference discourse-reference! introduce!
	  ;; Names of parsers
	  sentence noun-phrase adjectival-phrase verb-phrase prepositional-phrases
	  ;; Loading and compiling forms
	  load-huh compile-huh))