(in-package :huh)

(defun remove-illegal-results (specs)
  (default-sense-selector
    (remove-if-not #'(lambda (parse-result) 
                       (legal? (pr-object parse-result)))
                   specs)))

(defun legal? (expr)
  (type-check (flatten expr)))

(defun flatten (spec)
  (cond ((eq (car spec) 'quote) (cadr spec))
        ((eq (car spec) 'introduce!) (flatten (cadr spec)))
        ((eq (car spec) 'create-object)
         (mapcar #'(lambda (x) (list (car x) (flatten (cadr x))))
                 (cdr spec)))
        ((eq (car spec) 'create-named-object)
         (mapcar #'(lambda (x) (list (car x) (flatten (cadr x))))
                 (cddr spec)))
	((eq (car spec) 'extend-object)
         (let ((top (flatten (cadr spec)))
	       (props (mapcar #'(lambda (x) (list (car x) (flatten (cadr x))))
			      (cddr spec))))
           (if (listp top) (append top props) props)))))

(defun member-of-props (expr)
  (remove NIL (mapcar #'(lambda (x) (and (eq (car x) 'member-of) (cadr x)))
		      expr)))

(defun type-check (props)
  (block checking-type 
    (let* ((types (member-of-props props)))
      (dolist (prop props)
	(let ((domain (get-value (car prop) 'makes-sense-for))
	      (range (get-value (car prop) 'must-be)))
	  (unless (some #'(lambda (x) (query domain 'subsumes x)) types)
	    (break)
	    (return-from checking-type NIL))
	  (unless (if (listp (cadr prop))
		      (and (some #'(lambda (x) (query x 'subsumes range))
				 (member-of-props (cadr prop)))
			   (type-check (cadr prop)))
		    (satisfies? (cadr prop) range))
	    (break)
	    (return-from checking-type nil)))))
    T))

