;;;; -*- LISP -*-

(in-package :arlotje)

(defvar *bundling* nil
  "Whether type checking is being deferred.")

(defvar *bundling-assumptions* '()
  "A list of assumptions made so far.")

(defun check-put-value (unit slot value)
  "Checks the slot assignment of VALUE to SLOT of UNIT.
Uses the MAKES-SENSE-FOR and MUST-BE slots as arguments to SATISFIES?."
  (let ((domain (get-value slot 'makes-sense-for))
	(range  (get-value slot 'must-be)))
    (unless (satisfies? unit domain)
      (unless (or *bundling* (assuming? (satisfies? unit domain)))
	(cerror "Assume that ~*~S satisfies ~S"
		"The ~S slot doesn't make sense for ~S:~%it must pass ~S"
		slot unit domain))
      (if *bundling* 
	  (push (list (list unit domain) (list 'put-value unit slot value))
		*bundling-assumptions*)
	  (assuming (satisfies? unit domain)
		    "~S satisfies ~S (and can validly have a ~S slot of ~S)"
		    unit domain slot value)))
    (unless (satisfies? value range)
      (unless (or *bundling* (assuming? (satisfies? value range)))
	(cerror "Assume that ~*~S satisfies ~S"
		"The ~A slot can't be ~A:~%it must pass ~A"
		slot value range))
      (if *bundling* 
	  (push (list (list value range) (list 'put-value unit slot value))
		*bundling-assumptions*)
	(assuming (satisfies? value range)
		  "~S satisfies ~S (and can be the ~S slot of ~S)"
		  value range slot unit)))))
;;.@findex{check-put-value}

(defun check-get-value (unit slot)
  "Checks that UNIT makes sense for SLOT."
  (let ((domain (get-value slot 'makes-sense-for)))
    (unless (satisfies? unit domain)
      (unless (or *bundling* (assuming? (satisfies? unit domain)))
	(cerror "Assume that ~*~S satisfies ~S"
		"The ~S slot doesn't make sense for ~S:~%it must pass ~S"
		slot unit domain))
      (if *bundling* 
	  (push (list (list unit domain) (list 'get-value unit slot))
		*bundling-assumptions*)
	(assuming (satisfies? unit domain)
		  "~S satisfies ~S (and can validly have a ~S slot of ~S)"
		  unit domain slot value)))))

(defmacro bundling (&body body)
  `(if *bundling* (progn ,@body)
    (let ((*bundling-assumptions* '()))
      (unwind-protect (let ((*bundling* t)) ,@body)
	(dolist (assumption *bundling-assumptions*)
	  (let ((object (car (car assumption))) (test (cadr (car assumption)))
		(mistake (cadr assumption)))
	    (unless (satisfies? object test)
	      (if (yes-or-no-p "~S doesn't satisfy ~S: should I retract ~S" object test mistake)
		  (apply #'retract-value (cdr (cadr assumption)))
		(funcall (get-value test 'to-enforce-test) object test)))))))))