%* E.SW
%************************************************************************
%*									*
%*		PC Scheme/Geneva 4.00 Scheme-WEB code			*
%*									*
%* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
%* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
%*									*
%*----------------------------------------------------------------------*
%*									*
%*			To Compute digits of E				*
%*									*
%*----------------------------------------------------------------------*
%*									*
%* Created by: Larry Bartholdi		Date: 1992			*
%* Revision history:							*
%*									*
%*					``In nomine omnipotentii dei''	*
%************************************************************************

\documentstyle[a4,astyped]{article}
\title{Digits of e}
\author{Larry Bartholdi \& his gang}
\date{\today}

\newcommand{\pcs}{{\sc PcScheme}}
\newtheorem{mul-base}{Definition}

\begin{document}
\maketitle

We give here a simple algorithm to compute digits of E.
Its value is naturally available as a real number (type |(expt 1.)|),
but it is significantly more difficult to determine more than, say,
the 16 digits of 64-bit reals, for we must now develop the algorithm
to compute the exponential.

It is a known fact (almost a definition !) that
$$e^x = \lim_{n\rightarrow\infty}\left(1+\frac{x}{n}\right)^n.$$
If we take $x=1$, we get a formula which we can expand in a Newton
series:
$$e = \lim_{n\rightarrow\infty}\left(1+\frac{n}{n\cdot 1!}+
	\frac{n\cdot(n-1)}{n^2\cdot 2!}+\ldots\right);$$
taking the limit yields $(n-i)/n\rightarrow 1$, thus
$$e = \sum_{i=0}^\infty\frac{1}{i!}.$$

Of course the numbers involved get extremely large or small, so we need
some kind of computational trick to obtain a meaningful result. The idea
is to represent $e$ as a fixed-point multi-digit number in a {\em variable}
base, and then convert it to decimal. Let us first refine these concepts.

A number $x$ in $b$-base is a tuple $(\ldots x_1x_0.x_{-1}\ldots)$ such that
$$x = \sum_{i=-\infty}^{\infty}b^i\cdot x_i,$$
with $0 \leq x_i < b$. This can be understood as a special case where $b$
itself is a tuple whose values are all identical. We may then state:
\begin{mul-base}
A number $x$ in ${\bf b}$-base is a tuple $(\ldots x_1x_0.x_{-1}\ldots)$ such that
$$ x = \sum_{i=0}^{\infty}\left(\prod_{j=1}^i b_j\right)\cdot x_i
+ x_0 + \sum_{i=-\infty}^0\left(\prod_{j=i}^{-1}b_j^{-1}\right)\cdot x_i$$
with $0 \leq x_i < b_i$, and of course all these values in {\cal N}.
\end{mul-base}
If we take the base $(b_i)$ with $b_i = -i$, $e$ will be represented as
$1.111111\ldots$ All we have to do is convert this tuple in a decimal
representation. But that's enough of chatting! let's get to code.
 
The numbers are represented as infinite sequences extending one way using
streams (quick, dash to your manual to check your knowledge). The digits
will then be computed on demand, with no limitation except memory and time.

\newpage
This routine will convert the $e$-base number |x| to decimal.
The basic algorithm goes:
\begin{enumerate}
\item	leave the first digit unchanged.
\item	multiply the rest by 10, and shift it right one position.
	(this may be seen as a no-op in base 10. For instance,
	$1.11111111\ldots$ will become $1.0(10)(10)(10)\ldots$).
	Using this initialization, the digits will always be a little
	late in the stream, so we have some time to make adjustments.
\item	normalize it; that is, if the next digit is too big, reduce it
	and increment the current one.
\item	recurse on the normalization.
\item	recurse back to (1).
\end{enumerate}

Note the |(normalize 2 ...)| calls normalize with a source base of 2.
Normalize increments this value for successive digits.

(define (convert x)
  (cons-stream
    (head x)
    (convert (normalize 2 (cons-stream 0 (mult (tail x)))))))

Multiply a number by 10.
(define (mult x)
  (cons-stream (* 10 (head x))
               (mult (tail x))))

Normalize the number. If its second digit is small enough, leave the
current one unchanged; otherwise bump up the current digit and down the
second one. Then call normalize recursively on the tail, incrementing
the source base (|c|).

(define (normalize c x)
  (let ((d (head x))
        (e (head (tail x))))
    (if (< (+ e 9) c)
        (cons-stream d (normalize (+ c 1) (tail x)))
        (carry c (cons-stream d (normalize (+ c 1) (tail x)))))))

(define (carry c x)
  (cons-stream (+ (head x) (quotient (head (tail x)) c))
               (cons-stream (remainder (head (tail x)) c)
                            (tail (tail x)))))

This primitive will be useful in extracting a digit from the stream.
|(nth 10)| would return the $10^{th}$ digit of $e$.

(define (nth digit)
  ((named-lambda (n d s)
     (if (= d 0) (head s)
                 (n (-1+ d) (tail s))))
   digit e))

Here we cheat a little. $E$ should be represented as $1.111\ldots$,
but we prefer the representation $0.2111\ldots$, although this violates
our definition. This is why the source base starts at 2 in |convert|.

(define ones (cons-stream 1 ones))
(define e (convert (cons-stream 2 ones)))

And finally something useful\ldots

(define (digits n)
  (map nth ((named-lambda (loop from to)
              (if (> from to) '()
                              (cons from (loop (1+ from) to))))
            0 n)))

This code could be described as giving an infinite number of digits in
an infinite number of time. What we would like to know is how much time
is needed to compute $n$ digits.

Let us suppose $k$ digits are used in $e$. Then |convert| gets called
$k$ times, calling itself |normalize| $k$ times. The fact that a 0 gets
inserted in the stream in |convert| shows us that $k\approx n/2$.
Then the running time is $O(n^2)$.
\end{document}
