;* DOCTOR.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*			ELISA: The Psychiatrist				*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by:			Date: 19				*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

;;; doctor.el --- psychological help for frustrated users.

;; Copyright (C) 1985, 1987 Free Software Foundation, Inc.

;; Maintainer: FSF
;; Keywords: games

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;; The single entry point `doctor', simulates a Rogerian analyst using
;; phrase-production techniques similar to the classic ELIZA demonstration
;; of pseudo-AI.

;;; Code:

(define (doctor-cadr x) (car (cdr x)))
(define (doctor-caddr x) (car (cdr (cdr x))))
(define (doctor-cddr x) (cdr (cdr x)))

(define (doctor-substring string start . end)
  (if (null? end)
      (set! end (string-length string))
      (set! end (car end)))
  (if (negative? end)
      (set! end (+ (string-length string) end)))
  (if (negative? start)
      (set! start (+ (string-length string) start)))
  (substring string start end))

(macro while
  (lambda (expr)
    (let ((label (gensym)))
      `(LET ,label ()
	 (WHEN ,(cadr expr) ,@(cddr expr) (,label))))))

(define (insert . s) (map display s))
(define (capitalize s)
  (list->string (map char-upcase (string->list s))))

(define (// x) x)

(macro $
  (lambda (expr)
    (let ((what (cadr expr)))
      "quoted arg form of doctor-$"
      (list 'DOCTOR-$ (list 'QUOTE what)))))

(define (doctor-$ what)
  "Return the car of a list, rotating the list each time"
  (let* ((lookup-code (compile `(access XXX ,user-initial-environment)))
	 (doctor-lookup
	   (lambda (name)
	     (set-car! (member 'XXX (cadddr lookup-code)) name)
	     (%execute lookup-code)))
	 (vv (doctor-lookup what))
	 (first (car vv)))
    (set-cdr! (last-pair vv) (list first))
    (set-car! vv (cadr vv))
    (set-cdr! vv (cddr vv))
    first))

(define (doctor-mode)
  "Major mode for running the Doctor (Eliza) program.
Like Text mode with Auto Fill mode
except that RET when point is after a newline, or LFD at any time,
reads the sentence before point, and prints the Doctor's answer."
  (doctor-type '(I AM THE PSYCHOTHERAPIST |.|
		 ($ please) ($ describe) YOUR ($ problems) |.|
		 EACH TIME YOU ARE FINISHED |TALKING,| TYPE |<RET>.|))
  (insert #\NEWLINE))

(define (make-doctor-variables)
  (set! (access monosyllables user-initial-environment)
	"
     Your attitude at the end of the session was wholly unacceptable.
     Please try to come back next time with a willingness to speak more
     freely. If you continue to refuse to talk openly, there is little
     I can do to help!
")
  (set! (access typos user-initial-environment)
	(mapcar (lambda (x)
		  (putprop (car x) (doctor-cadr x) 'DOCTOR-CORRECTION)
		  (putprop (doctor-cadr x) (doctor-caddr x) 'DOCTOR-EXPANSION)
		  (car x))
		'((THEYLL |THEY'LL| (THEY WILL))
		  (THEYRE |THEY'RE| (THEY ARE))
		  (HES |HE'S| (HE IS))
		  (HE7S |HE'S| (HE IS))
		  (IM |I'M| (YOU ARE))
		  (I7M |I'M| (YOU ARE))
		  (ISA |IS A| (IS A))
		  (THIER THEIR (THEIR))
		  (DONT |DON'T| (DO NOT))
		  (DON7T |DON'T| (DO NOT))
		  (YOU7RE |YOU'RE| (I AM))
		  (YOU7VE |YOU'VE| (I HAVE))
		  (YOU7LL |YOU'LL| (I WILL)))))
  (set! (access found user-initial-environment) #F)
  (set! (access owner user-initial-environment) #F)
  (set! (access history user-initial-environment) #F)
  (set! (access *debug* user-initial-environment) #F)
  (set! (access inter user-initial-environment)
	'((|WELL,|)
	  (HMMM |... SO,|)
	  (SO)
	  (|...AND|)
	  (THEN)))
  (set! (access continue user-initial-environment)
	'((CONTINUE)
	  (PROCEED)
	  (GO ON)
	  (KEEP GOING) ))
  (set! (access relation user-initial-environment)
	'((YOUR RELATIONSHIP WITH)
	  (SOMETHING YOU REMEMBER ABOUT)
	  (YOUR FEELINGS TOWARD)
	  (SOME EXPERIENCES YOU HAVE HAD WITH)
	  (HOW YOU FEEL ABOUT)))
  (set! (access fears user-initial-environment) '( (($ whysay) YOU ARE ($ afraidof) (// feared) ?)
		 (YOU SEEM TERRIFIED BY (// feared) |.|)
		 (WHEN DID YOU FIRST FEEL ($ afraidof) (// feared) ?) ))
  (set! (access sure user-initial-environment) '((SURE) (POSITIVE) (CERTAIN) (ABSOLUTELY SURE)))
  (set! (access afraidof user-initial-environment) '( (AFRAID OF) (FRIGHTENED BY) (SCARED OF) ))
  (set! (access areyou user-initial-environment) '( (ARE YOU) (HAVE YOU BEEN) (HAVE YOU BEEN) ))
  (set! (access isrelated user-initial-environment) '( (HAS SOMETHING TO DO WITH) (IS RELATED TO)
		     (COULD BE THE REASON FOR) (IS CAUSED BY) (IS BECAUSE OF)))
  (set! (access arerelated user-initial-environment) '((HAVE SOMETHING TO DO WITH) (ARE RELATED TO)
		     (COULD HAVE CAUSED) (COULD BE THE REASON FOR) (ARE CAUSED BY)
		     (ARE BECAUSE OF)))
  (set! (access moods user-initial-environment) '( (($ areyou) (// found) OFTEN ?)
		 (WHAT CAUSES YOU TO BE (// found) ?)
		 (($ whysay) YOU ARE (// found) ?) ))
  (set! (access maybe user-initial-environment)
	'((MAYBE)
	  (PERHAPS)
	  (POSSIBLY)))
  (set! (access whatwhen user-initial-environment)
	'((WHAT HAPPENED WHEN)
	  (WHAT WOULD HAPPEN IF)))
  (set! (access hello user-initial-environment)
	'((HOW DO YOU DO ?) (HELLO |.|) (HOWDY!) (HELLO |.|) (HI |.|) (HI THERE |.|)))
  (set! (access drnk user-initial-environment)
	'((DO YOU DRINK A LOT OF (// found) ?)
	  (DO YOU GET DRUNK OFTEN ?)
	  (($ describe) YOUR DRINKING HABITS |.|) )) 
  (set! (access drugs user-initial-environment) '( (DO YOU USE (// found) OFTEN ?) (($ areyou)
						 ADDICTED TO (// found) ?) (DO YOU REALIZE THAT DRUGS CAN
						 BE VERY HARMFUL ?) (($ maybe) YOU SHOULD TRY TO QUIT USING (// found)
						 |.|)))
  (set! (access whywant user-initial-environment) '( (($ whysay) (// subj) MIGHT ($ want) (// obj) ?)
		   (HOW DOES IT FEEL TO WANT ?)
		   (WHY SHOULD (// subj) GET (// obj) ?)
		   (WHEN DID (// subj) FIRST ($ want) (// obj) ?)
		   (($ areyou) OBSESSED WITH (// obj) ?)
		   (WHY SHOULD I GIVE (// obj) TO (// subj) ?)
		   (HAVE YOU EVER GOTTEN (// obj) ?) ))
  (set! (access canyou user-initial-environment) '((OF COURSE I CAN |.|)
		 (WHY SHOULD I ?)
		 (WHAT MAKES YOU THINK I WOULD EVEN WANT TO ?)
		 (I AM THE DOCTOR\, I CAN DO ANYTHING I DAMN PLEASE |.|)
		 (NOT |REALLY,| |IT'S| NOT UP TO ME |.|)
		 (|DEPENDS,| HOW IMPORTANT IS IT ?)
		 (I |COULD,| BUT I |DON'T| THINK IT WOULD BE A WISE THING TO DO |.|)
		 (CAN YOU ?)
		 (MAYBE I |CAN,| MAYBE I |CAN'T| |...|)
		 (I |DON'T| THINK I SHOULD DO THAT |.|)))
  (set! (access want user-initial-environment) '( (WANT) (DESIRE) (WISH) (WANT) (HOPE) ))
  (set! (access shortlst user-initial-environment)
	'((CAN YOU ELABORATE ON THAT ?)
	  (($ please) CONTINUE |.|)
	  (GO |ON,| |DON'T| BE AFRAID |.|)
	  (I NEED A LITTLE MORE DETAIL PLEASE |.|)
	  (|YOU'RE| BEING A BIT |BRIEF,| ($ PLEASE) GO INTO DETAIL |.|)
	  (CAN YOU BE MORE EXPLICIT ?)
	  (AND ?)
	  (($ PLEASE) GO INTO MORE DETAIL ?)
	  (YOU |AREN'T| BEING VERY TALKATIVE TODAY!)
	  (IS THAT ALL THERE IS TO IT ?)
	  (WHY MUST YOU RESPOND SO BRIEFLY ?)))

  (set! (access famlst user-initial-environment)
	'((TELL ME ($ something) ABOUT (// owner) FAMILY |.|)
	  (YOU SEEM TO DWELL ON (// owner) FAMILY |.|)
	  (($ areyou) HUNG UP ON (// owner) FAMILY ?)))
  (set! (access huhlst user-initial-environment)
	'((($ whysay) (// sent) ?)
	  (IS IT BECAUSE OF ($ things) THAT YOU SAY (// sent) ?) ))
  (set! (access longhuhlst user-initial-environment)
	'((($ whysay) THAT ?)
	  (I |DON'T| UNDERSTAND |.|)
	  (($ thlst))
	  (($ areyou) ($ afraidof) THAT ?)))
  (set! (access feelings-about user-initial-environment)
	'((FEELINGS ABOUT)
	  (APREHENSIONS TOWARD)
	  (THOUGHTS ON)
	  (EMOTIONS TOWARD)))
  (set! (access random-adjective user-initial-environment)
	'((VIVID)
	  (EMOTIONALLY STIMULATING)
	  (EXCITING)
	  (BORING)
	  (INTERESTING)
	  (RECENT)
	  (RANDOM)   ;How can we omit this?
	  (UNUSUAL)
	  (SHOCKING)
	  (EMBARRASSING)))
  (set! (access whysay user-initial-environment)
	'((WHY DO YOU SAY)
	  (WHAT MAKES YOU BELIEVE)
	  (ARE YOU SURE THAT)
	  (DO YOU REALLY THINK)
	  (WHAT MAKES YOU THINK) ))
  (set! (access isee user-initial-environment)
	'((I SEE |...|)
	  (|YES,|)
	  (I UNDERSTAND |.|)
	  (OH |.|) ))
  (set! (access please user-initial-environment) 
	'((|PLEASE,|)
	  (I WOULD APPRECIATE IT IF YOU WOULD)
	  (PERHAPS YOU COULD)
	  (|PLEASE,|)
	  (WOULD YOU PLEASE)
	  (WHY |DON'T| YOU)
	  (COULD YOU)))
  (set! (access bye user-initial-environment)
	'((MY SECRETARY WILL SEND YOU A BILL |.|)
	  (BYE BYE |.|)
	  (SEE YA |.|)
	  (|OK,| TALK TO YOU SOME OTHER TIME |.|)
	  (TALK TO YOU LATER |.|)
	  (|OK,| HAVE FUN |.|)
	  (CIAO |.|)))
  (set! (access something user-initial-environment)
	'((SOMETHING)
	  (MORE)
	  (HOW YOU FEEL)))
  (set! (access things user-initial-environment) 
	'(;(YOUR INTERESTS IN COMPUTERS)   ;; let's make this less computer oriented
	  ;(THE MACHINES YOU USE)
	  (YOUR PLANS)
	  ;(YOUR USE OF COMPUTERS)
	  (YOUR LIFE)
	  ;(OTHER MACHINES YOU USE)
	  (THE PEOPLE YOU HANG AROUND WITH)
	  ;(COMPUTERS YOU LIKE)
	  (PROBLEMS AT SCHOOL)
	  (ANY HOBBIES YOU HAVE)
	  ;(OTHER COMPUTERS YOU USE)
	  (YOUR SEX LIFE)
	  (HANGUPS YOU HAVE)
	  (YOUR INHIBITIONS)
	  (SOME PROBLEMS IN YOUR CHILDHOOD)
	  ;(KNOWLEDGE OF COMPUTERS)
	  (SOME PROBLEMS AT HOME)))
  (set! (access describe user-initial-environment)
	'((DESCRIBE)
	  (TELL ME ABOUT)
	  (TALK ABOUT)
	  (DISCUSS)
	  (TELL ME MORE ABOUT)
	  (ELABORATE ON)))
  (set! (access ibelieve user-initial-environment) 
	'((I BELIEVE) (I THINK) (I HAVE A FEELING) (IT SEEMS TO ME THAT)
	  (IT LOOKS LIKE)))
  (set! (access problems user-initial-environment) '( (PROBLEMS)
		    (INHIBITIONS)
		    (HANGUPS)
		    (DIFFICULTIES)
		    (ANXIETIES)
		    (FRUSTRATIONS) ))
  (set! (access bother user-initial-environment)
	'((DOES IT BOTHER YOU THAT)
	  (ARE YOU ANNOYED THAT)
	  (DID YOU EVER REGRET)
	  (ARE YOU SORRY)
	  (arE YOU SATISFIED WITH THE FACT THAT)))
  (set! (access machlst user-initial-environment) 
	'((YOU HAVE YOUR MIND ON (// found) |,| IT SEEMS |.|)
	  (YOU THINK TOO MUCH ABOUT (// found) |.|)
	  (YOU SHOULD TRY TAKING YOUR MIND OFF OF (// found) |.|)
	  (ARE YOU A COMPUTER HACKER ?)))
  (set! (access qlist user-initial-environment)
	'((WHAT DO YOU THINK ?)
	  (|I'LL| ASK THE |QUESTIONS,| IF YOU |DON'T| MIND!)
	  (I COULD ASK THE SAME THING MYSELF |.|)
	  (($ please) ALLOW ME TO DO THE QUESTIONING |.|)
	  (I HAVE ASKED MYSELF THAT QUESTION MANY TIMES |.|)
	  (($ please) TRY TO ANSWER THAT QUESTION YOURSELF |.|)))
  (set! (access elist user-initial-environment)
	'((($ please) TRY TO CALM YOURSELF |.|)
	  (YOU SEEM VERY EXCITED |.| RELAX |.| ($ please) ($ describe) ($ things)
	       |.|)
	  (|YOU'RE| BEING VERY EMOTIONAL |.| CALM DOWN |.|)))
  (set! (access foullst user-initial-environment)
	'((($ please) WATCH YOUR TONGUE!)
	  (($ please) AVOID SUCH UNWHOLESOME THOUGHTS |.|)
	  (($ please) GET YOUR MIND OUT OF THE GUTTER |.|)
	  (SUCH LEWDNESS IS NOT APPRECIATED |.|)))
  (set! (access deathlst user-initial-environment)
	'((THIS IS NOT A HEALTHY WAY OF THINKING |.|)
	  (($ bother) |YOU,| |TOO,| MAY DIE SOMEDAY ?)
	  (I AM WORRIED BY YOUR OBSESSION WITH THIS TOPIC!)
	  (DID YOU WATCH A LOT OF CRIME AND VIOLENCE ON TELEVISION AS A CHILD ?))
	)
  (set! (access sexlst user-initial-environment) 
	'((($ areyou) ($ afraidof) SEX ?)
	  (($ describe) ($ something) ABOUT YOUR SEXUAL HISTORY |.|)
	  (($ please) ($ describe) YOUR SEX LIFE |...|)
	  (($ describe) YOUR ($ feelings-about) YOUR SEXUAL PARTNER |.|)
	  (($ describe) YOUR MOST ($ random-adjective) SEXUAL EXPERIENCE |.|)
	  (($ areyou) SATISFIED WITH (// lover) |...| ?)))
  (set! (access neglst user-initial-environment)
	'((WHY NOT ?)
	  (($ bother) I ASK THAT ?)
	  (WHY NOT ?)
	  (WHY NOT ?)
	  (HOW COME ?)
	  (($ bother) I ASK THAT ?)))
  (set! (access beclst user-initial-environment) '(
		 (IS IT BECAUSE (// sent) THAT YOU CAME TO ME ?)
		 (($ bother) (// sent) ?)
		 (WHEN DID YOU FIRST KNOW THAT (// sent) ?)
		 (IS THE FACT THAT (// sent) THE REAL REASON ?)
		 (DOES THE FACT THAT (// sent) EXPLAIN ANYTHING ELSE ?)
		 (($ areyou) ($ sure) (// sent) ? ) ))
  (set! (access shortbeclst user-initial-environment) '(
		      (($ bother) I ASK YOU THAT ?)
		      (|THAT'S| NOT MUCH OF AN ANSWER!)
		      (($ inter) WHY |WON'T| YOU TALK ABOUT IT ?)
		      (SPEAK UP!)
		      (($ areyou) ($ afraidof) TALKING ABOUT IT ?)
		      (|DON'T| BE ($ afraidof) ELABORATING |.|)
		      (($ please) GO INTO MORE DETAIL |.|)))
  (set! (access thlst user-initial-environment) '(
		(($ maybe) ($ things) ($ arerelated) THIS |.|)
		(IS IT BECAUSE OF ($ things) THAT YOU ARE GOING THROUGH ALL THIS ?)
		(HOW DO YOU RECONCILE ($ things) ? )
		(($ maybe) THIS ($ isrelated) ($ things) ?) ))
  (set! (access remlst user-initial-environment) '( (EARLIER YOU SAID ($ history) ?)
		  (YOU MENTIONED THAt ($ history) ?)
		  (($ whysay) ($ history) ? ) ))
  (set! (access toklst user-initial-environment)
	'((IS THIS HOW YOU RELAX ?)
	  (HOW LONG HAVE YOU BEEN SMOKING	GRASS ?)
	  (($ areyou) ($ afraidof) OF BEING DRAWN TO USING HARDER STUFF ?)))
  (set! (access states user-initial-environment)
	'((DO YOU GET (// found) OFTEN ?)
	  (DO YOU ENJOY BEING (// found) ?)
	  (WHAT MAKES YOU (// found) ?)
	  (HOW OFTEN ($ areyou) (// found) ?)
	  (WHEN WERE YOU LAST (// found) ?)))
  (set! (access replist user-initial-environment) 
	'((I . (YOU))
	  (MY . (YOUR))
	  (ME . (YOU))
	  (YOU . (ME))
	  (YOUR . (MY))
	  (MINE . (YOURS))
	  (YOURS . (MINE))
	  (OUR . (YOUR))
	  (OURS . (YOURS))
	  (WE . (YOU))
	  (DUNNO . (DO NOT KNOW))
;;	  (YES . ())
	  (|NO,| . ())
	  (|YES,| . ())
	  (YA . (I))
	  (AINT . (AM NOT))
	  (WANNA . (WANT TO))
	  (GIMME . (GIVE ME))
	  (GOTTA . (HAVE TO))
	  (GONNA . (GOING TO))
	  (NEVER . (NOT EVER))
	  (|DOESN'T| . (DOES NOT))
	  (|DON'T| . (DO NOT))
	  (|AREN'T| . (ARE NOT))
	  (|ISN'T| . (IS NOT))
	  (|WON'T| . (WILL NOT))
	  (|CAN'T| . (CANNOT))
	  (|HAVEN'T| . (HAVE NOT))
	  (|I'M| . (YOU ARE))
	  (OURSELVES . (YOURSELVES))
	  (MYSELF . (YOURSELF))
	  (YOURSELF . (MYSELF))
	  (|YOU'RE| . (I AM))
	  (|YOU'VE| . (I HAVE))
	  (|I'VE| . (YOU HAVE))
	  (|I'LL| . (YOU WILL))
	  (|YOU'LL| . (I SHALL))
	  (|I'D| . (YOU WOULD))
	  (|YOU'D| . (I WOULD))
	  (HERE . (THERE))
	  (PLEASE . ())
	  (|EH,| . ())
	  (EH . ())
	  (|OH,| . ())
	  (OH . ())
	  (|SHOULDN'T| . (SHOULD NOT))
	  (|WOULDN'T| . (WOULD NOT))
	  (|WON'T| . (WILL NOT))
	  (|HASN'T| . (HAS NOT))))
  (set! (access stallmanlst user-initial-environment) '(
		      (($ describe) YOUR ($ feelings-about) HIM |.|)
		      (($ areyou) A FRIEND OF STALLMAN ?)
		      (($ bother) STALLMAN IS ($ random-adjective) ?)
		      (($ ibelieve) YOU ARE ($ afraidof) HIM |.|)))
  (set! (access schoollst user-initial-environment) '(
		    (($ describe) YOUR (// found) |.|)
		    (($ bother) YOUR GRADES COULD ($ improve) ?)
		    (($ areyou) ($ afraidof) (// found) ?)
		    (($ maybe) THIS ($ isrelated) TO YOUR ATTITUDE |.|)
		    (($ areyou) ABSENT OFTEN ?)
		    (($ maybe) yOU SHOULD STUDY ($ something) |.|)))
  (set! (access improve user-initial-environment) '((IMPROVE) (BE BETTER) (BE IMPROVED) (BE HIGHER)))
  (set! (access elizalst user-initial-environment) '(
		   (($ areyou) ($ sure) ?)
		   (($ ibelieve) YOU HAVE ($ problems) WITH (// found) |.|)
		   (($ whysay) (// sent) ?)))
  (set! (access sportslst user-initial-environment) '(
		    (TELL ME ($ something) ABOUT (// found) |.|)
		    (($ describe) ($ relation) (// found) |.|)
		    (DO YOU FIND (// found) ($ random-adjective) ?)))
  (set! (access mathlst user-initial-environment) '(
		  (($ describe) ($ something) ABOUT MATH |.|)
		  (($ maybe) YOUR ($ problems) ($ arerelated) (// found) |.|)
		  (I |DO'NT| KNOW MUCH (// found) |,| BUT ($ continue)
		     ANYWAY |.|)))
  (set! (access zippylst user-initial-environment) '(
		   (($ areyou) ZIPPY ?)
		   (($ ibelieve) YOU HAVE SOME SERIOUS ($ problems) |.|)
		   (($ bother) YOU ARE A PINHEAD ?)))
  (set! (access chatlst user-initial-environment) '(
		  (($ maybe) WE COULD CHAT |.|)
		  (($ please) ($ describe) ($ something) ABOUT CHAT MODE |.|)
		  (($ bother) OUR DISCUSSION IS SO ($ random-adjective) ?)))
  (set! (access abuselst user-initial-environment) '(
		   (($ please) TRY TO BE LESS ABUSIVE |.|)
		   (($ describe) WHY YOU CALL ME (// found) |.|)
		   (|I'VE| HAD ENOUGH OF YOU!)))
  (set! (access abusewords user-initial-environment) '(BORING BOZO CLOWN CLUMSY CRETIN DUMB DUMMY
			    FOOL FOOLISH GNERD GNURD IDIOT JERK
			    LOSE LOSER LOUSE LOUSY LUSE LUSER
			    MORON NERD NURD OAF OAFISH REEK
			    STINK STUPID TOOL TOOLISH TWIT))
  (set! (access howareyoulst user-initial-environment)  '((HOW ARE YOU) (HOWS IT GOING) (HOWS IT GOING EH)
			(|HOW'S| IT GOING) (|HOW'S| IT GOING EH) (HOW GOES IT)
			(WHATS UP) (WHATS NEW) (|WHAT'S| UP) (|WHAT'S| NEW)
			(HOWRE YOU) (|HOW'RE| YOU) (|HOW'S| EVERYTHING)
			(HOW IS EVERYTHING) (HOW DO YOU DO)
			(|HOW'S| IT HANGING) (QUE PASA)
			(HOW ARE YOU DOING) (WHAT DO YOU SAY)))
  (set! (access whereoutp user-initial-environment) '( HUH REMEM RTHING ) )
  (set! (access subj user-initial-environment) #F)
  (set! (access verb user-initial-environment) #F)
  (set! (access obj user-initial-environment) #F)
  (set! (access feared user-initial-environment) #F)
  (set! (access observation-list user-initial-environment) #F)
  (set! (access repetitive-shortness user-initial-environment) '(0 . 0))
  (set! (access **mad** user-initial-environment) #F)
  (set! (access rms-flag user-initial-environment) #F)
  (set! (access eliza-flag user-initial-environment) #F)
  (set! (access zippy-flag user-initial-environment) #F)
  (set! (access lover user-initial-environment) '(YOUR PARTNER))
  (set! (access bak user-initial-environment) #F)
  (set! (access lincount user-initial-environment) 0)
  (set! (access *print-upcase* user-initial-environment) #F)
  (set! (access *print-space* user-initial-environment) #F)
  (set! (access howdyflag user-initial-environment) #F)
  (set! (access object user-initial-environment) #F))

;; Define equivalence classes of words that get treated alike.

(define (doctor-meaning x) (getprop x 'DOCTOR-MEANING))

(macro doctor-put-meaning
  (lambda (expr)
    (let ((symb (cadr expr))
	  (val (caddr expr)))
      "Store the base meaning of a word on the property list."
      `(PUTPROP ',symb ,val 'DOCTOR-MEANING))))

(doctor-put-meaning HOWDY 'HOWDY)
(doctor-put-meaning HI 'HOWDY)
(doctor-put-meaning GREETINGS 'HOWDY)
(doctor-put-meaning HELLO 'HOWDY)
(doctor-put-meaning TOPS20 'MACH)
(doctor-put-meaning TOPS-20 'MACH)
(doctor-put-meaning TOPS 'MACH)
(doctor-put-meaning PDP11 'MACH)
(doctor-put-meaning COMPUTER 'MACH)
(doctor-put-meaning UNIX 'MACH)
(doctor-put-meaning MACHINE 'MACH)
(doctor-put-meaning COMPUTERS 'MACH)
(doctor-put-meaning MACHINES 'MACH)
(doctor-put-meaning PDP11S 'MACH)
(doctor-put-meaning FOO 'MACH)
(doctor-put-meaning FOOBAR 'MACH)
(doctor-put-meaning MULTICS 'MACH)
(doctor-put-meaning MACSYMA 'MACH)
(doctor-put-meaning TELETYPE 'MACH)
(doctor-put-meaning LA36 'MACH)
(doctor-put-meaning VT52 'MACH)
(doctor-put-meaning ZORK 'MACH)
(doctor-put-meaning TREK 'MACH)
(doctor-put-meaning STARTREK 'MACH)
(doctor-put-meaning ADVENT 'MACH)
(doctor-put-meaning PDP 'MACH)
(doctor-put-meaning DEC 'MACH)
(doctor-put-meaning COMMODORE 'MACH)
(doctor-put-meaning VIC 'MACH)
(doctor-put-meaning BBS 'MACH)
(doctor-put-meaning MODEM 'MACH)
(doctor-put-meaning BAUD 'MACH)
(doctor-put-meaning MACINTOSH 'MACH)
(doctor-put-meaning VAX 'MACH)
(doctor-put-meaning VMS 'MACH)
(doctor-put-meaning IBM 'MACH)
(doctor-put-meaning PC 'MACH)
(doctor-put-meaning BITCHING 'FOUL)
(doctor-put-meaning SHIT 'FOUL)
(doctor-put-meaning BASTARD 'FOUL)
(doctor-put-meaning DAMN 'FOUL)
(doctor-put-meaning DAMNED 'FOUL)
(doctor-put-meaning HELL 'FOUL)
(doctor-put-meaning SUCK 'FOUL)
(doctor-put-meaning SUCKING 'FOUL)
(doctor-put-meaning SUX 'FOUL)
(doctor-put-meaning ASS 'FOUL)
(doctor-put-meaning WHORE 'FOUL)
(doctor-put-meaning BITCH 'FOUL)
(doctor-put-meaning ASSHOLE 'FOUL)
(doctor-put-meaning SHRINK 'FOUL)
(doctor-put-meaning POT 'TOKE)
(doctor-put-meaning GRASS 'TOKE)
(doctor-put-meaning WEED 'TOKE)
(doctor-put-meaning MARIJUANA 'TOKE)
(doctor-put-meaning ACAPULCO 'TOKE)
(doctor-put-meaning COLUMBIAN 'TOKE)
(doctor-put-meaning TOKIN 'TOKE)
(doctor-put-meaning JOINT 'TOKE)
(doctor-put-meaning TOKE 'TOKE)
(doctor-put-meaning TOKING 'TOKE)
(doctor-put-meaning |TOKIN'| 'TOKE)
(doctor-put-meaning TOKED 'TOKE)
(doctor-put-meaning ROACH 'TOKE)
(doctor-put-meaning PILLS 'DRUG)
(doctor-put-meaning DOPE 'DRUG)
(doctor-put-meaning ACID 'DRUG)
(doctor-put-meaning LSD 'DRUG)
(doctor-put-meaning SPEED 'DRUG)
(doctor-put-meaning HEROIN 'DRUG)
(doctor-put-meaning HASH 'DRUG)
(doctor-put-meaning COCAINE 'DRUG)
(doctor-put-meaning UPPERS 'DRUG)
(doctor-put-meaning DOWNERS 'DRUG)
(doctor-put-meaning LOVES 'LOVES)
(doctor-put-meaning LOVE 'LOVE)
(doctor-put-meaning LOVED 'LOVE)
(doctor-put-meaning HATES 'HATES)
(doctor-put-meaning DISLIKES 'HATES)
(doctor-put-meaning HATE 'HATE)
(doctor-put-meaning HATED 'HATE)
(doctor-put-meaning DISLIKE 'HATE)
(doctor-put-meaning STONED 'STATE)
(doctor-put-meaning DRUNK 'STATE)
(doctor-put-meaning DRUNKEN 'STATE)
(doctor-put-meaning HIGH 'STATE)
(doctor-put-meaning HORNY 'STATE)
(doctor-put-meaning BLASTED 'STATE)
(doctor-put-meaning HAPPY 'STATE)
(doctor-put-meaning PARANOID 'STATE)
(doctor-put-meaning WISH 'DESIRE)
(doctor-put-meaning WISHES 'DESIRE)
(doctor-put-meaning WANT 'DESIRE)
(doctor-put-meaning DESIRE 'DESIRE)
(doctor-put-meaning LIKE 'DESIRE)
(doctor-put-meaning HOPE 'DESIRE)
(doctor-put-meaning HOPES 'DESIRE)
(doctor-put-meaning DESIRES 'DESIRE)
(doctor-put-meaning WANTS 'DESIRE)
(doctor-put-meaning DESIRES 'DESIRE)
(doctor-put-meaning LIKES 'DESIRE)
(doctor-put-meaning NEEDS 'DESIRE)
(doctor-put-meaning NEED 'DESIRE)
(doctor-put-meaning FRUSTRATED 'MOOD)
(doctor-put-meaning DEPRESSED 'MOOD)
(doctor-put-meaning ANNOYED 'MOOD)
(doctor-put-meaning UPSET 'MOOD)
(doctor-put-meaning UNHAPPY 'MOOD)
(doctor-put-meaning EXCITED 'MOOD)
(doctor-put-meaning WORRIED 'MOOD)
(doctor-put-meaning LONELY 'MOOD)
(doctor-put-meaning ANGRY 'MOOD)
(doctor-put-meaning MAD 'MOOD)
(doctor-put-meaning PISSED 'MOOD)
(doctor-put-meaning JEALOUS 'MOOD)
(doctor-put-meaning AFRAID 'FEAR)
(doctor-put-meaning TERRIFIED 'FEAR)
(doctor-put-meaning FEAR 'FEAR)
(doctor-put-meaning SCARED 'FEAR)
(doctor-put-meaning FRIGHTENED 'FEAR)
(doctor-put-meaning VIRGINITY 'SEXNOUN)
(doctor-put-meaning VIRGINS 'SEXNOUN)
(doctor-put-meaning VIRGIN 'SEXNOUN)
(doctor-put-meaning COCK 'SEXNOUN)
(doctor-put-meaning COCKS 'SEXNOUN)
(doctor-put-meaning DICK 'SEXNOUN)
(doctor-put-meaning DICKS 'SEXNOUN)
(doctor-put-meaning CUNT 'SEXNOUN)
(doctor-put-meaning CUNTS 'SEXNOUN)
(doctor-put-meaning PROSTITUTE 'SEXNOUN)
(doctor-put-meaning CONDOM 'SEXNOUN)
(doctor-put-meaning SEX 'SEXNOUN)
(doctor-put-meaning RAPES 'SEXNOUN)
(doctor-put-meaning WIFE 'FAMILY)
(doctor-put-meaning FAMILY 'FAMILY)
(doctor-put-meaning BROTHERS 'FAMILY)
(doctor-put-meaning SISTERS 'FAMILY)
(doctor-put-meaning PARENT 'FAMILY)
(doctor-put-meaning PARENTS 'FAMILY)
(doctor-put-meaning BROTHER 'FAMILY)
(doctor-put-meaning SISTER 'FAMILY)
(doctor-put-meaning FATHER 'FAMILY)
(doctor-put-meaning MOTHER 'FAMILY)
(doctor-put-meaning HUSBAND 'FAMILY)
(doctor-put-meaning SIBLINGS 'FAMILY)
(doctor-put-meaning GRANDMOTHER 'FAMILY)
(doctor-put-meaning GRANDFATHER 'FAMILY)
(doctor-put-meaning MATERNAL 'FAMILY)
(doctor-put-meaning PATERNAL 'FAMILY)
(doctor-put-meaning STAB 'DEATH)
(doctor-put-meaning MURDER 'DEATH)
(doctor-put-meaning MURDERS 'DEATH)
(doctor-put-meaning SUICIDE 'DEATH)
(doctor-put-meaning SUICIDES 'DEATH)
(doctor-put-meaning KILL 'DEATH)
(doctor-put-meaning KILLS 'DEATH)
(doctor-put-meaning DIE 'DEATH)
(doctor-put-meaning DIES 'DEATH)
(doctor-put-meaning DIED 'DEATH)
(doctor-put-meaning DEAD 'DEATH)
(doctor-put-meaning DEATH 'DEATH)
(doctor-put-meaning DEATHS 'DEATH)
(doctor-put-meaning PAIN 'SYMPTOMS)
(doctor-put-meaning ACHE 'SYMPTOMS)
(doctor-put-meaning FEVER 'SYMPTOMS)
(doctor-put-meaning SORE 'SYMPTOMS)
(doctor-put-meaning ACHING 'SYMPTOMS)
(doctor-put-meaning STOMACHACHE 'SYMPTOMS)
(doctor-put-meaning HEADACHE 'SYMPTOMS)
(doctor-put-meaning HURTS 'SYMPTOMS)
(doctor-put-meaning DISEASE 'SYMPTOMS)
(doctor-put-meaning VIRUS 'SYMPTOMS)
(doctor-put-meaning VOMIT 'SYMPTOMS)
(doctor-put-meaning VOMITING 'SYMPTOMS)
(doctor-put-meaning BARF 'SYMPTOMS)
(doctor-put-meaning TOOTHACHE 'SYMPTOMS)
(doctor-put-meaning HURT 'SYMPTOMS)
(doctor-put-meaning RUM 'ALCOHOL)
(doctor-put-meaning GIN 'ALCOHOL)
(doctor-put-meaning VODKA 'ALCOHOL)
(doctor-put-meaning ALCOHOL 'ALCOHOL)
(doctor-put-meaning BOURBON 'ALCOHOL)
(doctor-put-meaning BEER 'ALCOHOL)
(doctor-put-meaning WINE 'ALCOHOL)
(doctor-put-meaning WHISKEY 'ALCOHOL)
(doctor-put-meaning SCOTCH 'ALCOHOL)
(doctor-put-meaning FUCK 'SEXVERB)
(doctor-put-meaning FUCKED 'SEXVERB)
(doctor-put-meaning SCREW 'SEXVERB)
(doctor-put-meaning SCREWING 'SEXVERB)
(doctor-put-meaning FUCKING 'SEXVERB)
(doctor-put-meaning RAPE 'SEXVERB)
(doctor-put-meaning RAPED 'SEXVERB)
(doctor-put-meaning KISS 'SEXVERB)
(doctor-put-meaning KISSING 'SEXVERB)
(doctor-put-meaning KISSES 'SEXVERB)
(doctor-put-meaning SCREWS 'SEXVERB)
(doctor-put-meaning FUCKS 'SEXVERB)
(doctor-put-meaning BECAUSE 'CONJ)
(doctor-put-meaning BUT 'CONJ)
(doctor-put-meaning HOWEVER 'CONJ)
(doctor-put-meaning BESIDES 'CONJ)
(doctor-put-meaning ANYWAY 'CONJ)
(doctor-put-meaning THAT 'CONJ)
(doctor-put-meaning EXCEPT 'CONJ)
(doctor-put-meaning WHY 'CONJ)
(doctor-put-meaning HOW 'CONJ)
(doctor-put-meaning UNTIL 'WHEN)
(doctor-put-meaning WHEN 'WHEN)
(doctor-put-meaning WHENEVER 'WHEN)
(doctor-put-meaning WHILE 'WHEN)
(doctor-put-meaning SINCE 'WHEN)
(doctor-put-meaning RMS 'RMS)
(doctor-put-meaning STALLMAN 'RMS)
(doctor-put-meaning SCHOOL 'SCHOOL)
(doctor-put-meaning SCHOOLS 'SCHOOL)
(doctor-put-meaning SKOOL 'SCHOOL)
(doctor-put-meaning GRADE 'SCHOOL)
(doctor-put-meaning GRADES 'SCHOOL)
(doctor-put-meaning TEACHER 'SCHOOL)
(doctor-put-meaning TEACHERS 'SCHOOL)
(doctor-put-meaning CLASSES 'SCHOOL)
(doctor-put-meaning PROFESSOR 'SCHOOL)
(doctor-put-meaning PROF 'SCHOOL)
(doctor-put-meaning PROFS 'SCHOOL)
(doctor-put-meaning PROFESSORS 'SCHOOL)
(doctor-put-meaning MIT 'SCHOOL)
(doctor-put-meaning EMACS 'ELIZA)
(doctor-put-meaning ELIZA 'ELIZA)
(doctor-put-meaning LIZA 'ELIZA)
(doctor-put-meaning ELISA 'ELIZA)
(doctor-put-meaning WEIZENBAUM 'ELIZA)
(doctor-put-meaning DOKTOR 'ELIZA)
(doctor-put-meaning ATHLETICS 'SPORTS)
(doctor-put-meaning BASEBALL 'SPORTS)
(doctor-put-meaning BASKETBALL 'SPORTS)
(doctor-put-meaning FOOTBALL 'SPORTS)
(doctor-put-meaning FRISBEE 'SPORTS)
(doctor-put-meaning GYM 'SPORTS)
(doctor-put-meaning GYMNASTICS 'SPORTS)
(doctor-put-meaning HOCKEY 'SPORTS)
(doctor-put-meaning LACROSSE 'SPORTS)
(doctor-put-meaning SOCCER 'SPORTS)
(doctor-put-meaning SOFTBALL 'SPORTS)
(doctor-put-meaning SPORTS 'SPORTS)
(doctor-put-meaning SWIMMING 'SPORTS)
(doctor-put-meaning SWIM 'SPORTS)
(doctor-put-meaning TENNIS 'SPORTS)
(doctor-put-meaning VOLLEYBALL 'SPORTS)
(doctor-put-meaning MATH 'MATH)
(doctor-put-meaning MATHEMATICS 'MATH)
(doctor-put-meaning MATHEMATICAL 'MATH)
(doctor-put-meaning THEOREM 'MATH)
(doctor-put-meaning AXIOM 'MATH)
(doctor-put-meaning LEMMA 'MATH)
(doctor-put-meaning ALGEBRA 'MATH)
(doctor-put-meaning ALGEBRAIC 'MATH)
(doctor-put-meaning TRIG 'MATH)
(doctor-put-meaning TRIGONOMETRY 'MATH)
(doctor-put-meaning TRIGONOMETRIC 'MATH)
(doctor-put-meaning GEOMETRY 'MATH)
(doctor-put-meaning GEOMETRIC 'MATH)
(doctor-put-meaning CALCULUS 'MATH)
(doctor-put-meaning ARITHMETIC 'MATH)
(doctor-put-meaning ZIPPY 'ZIPPY)
(doctor-put-meaning ZIPPY 'ZIPPY)
(doctor-put-meaning PINHEAD 'ZIPPY)
(doctor-put-meaning CHAT 'CHAT)

(define (doctor-read-print)
  "top level loop"
  (let ((sent (doctor-readin)))
    (set! lincount (1+ lincount))
    (doctor-doc sent)
    (set! bak sent)))

(define (doctor-readin)
  "Read a sentence.  Return it as a list of words."
  (let loop ((sentence '()))
    (let ((next (doctor-read-token)))
      (if (eof-object? next)
	  sentence
	  (loop (append sentence (list next)))))))

(define doctor-read-token)
(let ((read-buffer #F)
      (read-string ""))
  (set! doctor-read-token
    (lambda ()
      "read one word from buffer"
      (when (null? read-buffer)
	(set! read-string (read-line 'CONSOLE))
	(set! read-buffer (open-input-string read-string)))
      (let loop ((buf '()))
	(let ((new (read-char read-buffer)))
	  (cond ((and (eof-object? new) (null? buf))
		 (close-input-port read-buffer)
		 (if (not (string-null? read-string))
		     (read-line 'CONSOLE))	; bug
		 (set! read-buffer #F)
		 new)
		((and (char-whitespace? new) (null? buf))
		 (doctor-read-token))
		((or (char-whitespace? new)
		     (eof-object? new)
		     (member new '(#\? #\. #\: #\, #\; #\!)))
		 (unread-char)
		 (string->symbol (capitalize (list->string (reverse! buf)))))
		(else (loop (cons new buf)))))))))

;; Main processing function for sentences that have been read.

(define (doctor-doc sent)
  (set! (access sent user-initial-environment) sent)
  (private-doctor-doc))
(define (private-doctor-doc)
  (cond
   ((equal? sent '(FOO))
    (doctor-type '(BAR! ($ please) ($ continue))))
   ((member sent howareyoulst)
    (doctor-type '(|I'M| OK |.|  ($ describe) YOURSELF |.|)))
   ((or (member sent '((GOOD BYE) (SEE YOU LATER) (I QUIT) (SO LONG)
		       (GO AWAY) (GET LOST)))
	(memq (car sent)
	      '(BYE HALT BREAK QUIT DONE EXIT GOODBYE 
		    |BYE,| STOP PAUSE |GOODBYE,| STOP PAUSE)))
    (doctor-type ($ bye)))
   ((and (eq? (car sent) 'YOU)
	 (memq (doctor-cadr sent) abusewords))
    (set! found (doctor-cadr sent))
    (doctor-type ($ abuselst)))
   ((eq? (car sent) 'WHATMEANS)
    (doctor-def (doctor-cadr sent)))
   ((equal? sent '(PARSE))
    (doctor-type (list  'SUBJ '= subj ",  "
			'VERB '= verb #\NEWLINE
			'OBJECT 'PHRASE '= obj ","
			'NOUN 'FORM '=  object #\NEWLINE
			'CURRENT 'KEYWORD 'IS found
			", "
			'MOST 'RECENT 'POSSESSIVE
			'IS owner #\NEWLINE
			'SENTENCE 'USED 'WAS
			"..."
			'(// bak))))
   ;;   ((eq? (car sent) 'FORGET)
   ;;    (set (doctor-cadr sent) #F)
   ;;    (doctor-type '(($ isee) ($ please)
   ;;     ($ continue)|.|)))
   (else
    (if (doctor-defq sent) (doctor-define sent found))
    (if (> (length sent) 12) (doctor-shorten))
    (set! sent (doctor-correct-spelling (doctor-replace sent replist)))
    (cond ((and (not (memq 'ME sent)) (not (memq 'I sent))
		(memq 'AM sent))
	   (set! sent (doctor-replace sent '((AM . (ARE)))))))
    (cond ((equal? (car sent) 'YOW) (doctor-zippy))
	  ((< (length sent) 2)
	   (cond ((eq? (doctor-meaning (car sent)) 'HOWDY)
		  (doctor-howdy))
		 (else (doctor-short))))
	  (else
	   (if (memq 'AM sent)
	       (set! sent (doctor-replace sent '((ME . (I))))))
	   (set! sent (doctor-fixup sent))
	   (if (and (eq? (car sent) 'DO) (eq? (doctor-cadr sent) 'NOT))
	       (cond ((zero? (random 3))
		      (doctor-type '(ARE YOU ($ afraidof) THAT ?)))
		     ((zero? (random 2))
		      (doctor-type '(|DON'T| TELL ME WHAT TO DO |.| I AM THE
					    PSYCHIATRIST HERE!))
		      (doctor-rthing))
		     (else
		      (doctor-type '(($ whysay) THAT I |SHOULDN'T|
				     (doctor-cddr sent)
				     ?))))
	     (doctor-go (doctor-wherego sent))))))))

;; Things done to process sentences once read.

(define (doctor-correct-spelling sent)
  "Correct the spelling and expand each word in sentence."
  (if sent
      (apply append (mapcar (lambda (word)
			      (if (memq word typos)
				  (getprop (getprop word 'DOCTOR-CORRECTION) 'DOCTOR-EXPANSION)
				  (list word)))
			    sent))))

(define (doctor-shorten)
  "Make a sentence manageably short using a few hacks."
  (let ((foo '())
	(retval '())
	(temp '(BECAUSE BUT HOWEVER BESIDES ANYWAY UNTIL
		    WHILE THAT EXCEPT WHY HOW)))
    (while temp
	   (set! foo (memq (car temp) sent))
	   (if (and foo
		    (> (length foo) 3))
	       (begin (set! sent foo)
		      (set! sent (doctor-fixup sent))
		      (set! temp #F)
		      (set! retval #T))
	       (set! temp (cdr temp))))
    retval))

(define (doctor-define sent found)
  (doctor-svo sent found 1 #F)
  (and
    (doctor-nounp subj)
    (not (doctor-pronounp subj))
    subj
    (doctor-meaning object)
    (putprop subj (doctor-meaning object) 'DOCTOR-MEANING)
    #T))

(define (doctor-defq sent)
  "Set global var FOUND to first keyword found in sentence SENT."
  (set! found #F)
  (let ((temp '(MEANS APPLIES MEAN REFERS REFER RELATED
		      SIMILAR DEFINED ASSOCIATED LINKED LIKE SAME)))
    (while temp
	   (if (memq (car temp) sent)
	       (begin (set! found (car temp))
		      (set! temp #F))
	       (set! temp (cdr temp)))))
  found)

(define (doctor-def x)
  (doctor-type (list 'THE 'WORD x 'MEANS (doctor-meaning x) 'TO 'ME)) 
  #F)

(define (doctor-forget)
  "Delete the last element of the history list."
  (set! history (reverse (cdr (reverse history)))))

(define (doctor-query x)
  "Prompt for a line of input from the minibuffer until a noun or verb is seen.
Put dialogue in buffer."
  (let ((a '())
	(prompt (string-append (doctor-make-string x)
			" what ?  "))
	(retval '()))
    (while (not retval)
	   (while (not a)
	     (insert #\newline
		     prompt
		     (read-string prompt)
		     #\newline)
	     (set! a (doctor-readin)))
	   (while (and a (not retval))
		  (cond ((doctor-nounp (car a))
			 (set! retval (car a)))
			((doctor-verbp (car a))
			 (set! retval (doctor-build
				       (doctor-build x " ")
				       (car a))))
			((set! a (cdr a))))))
    retval))

(define (doctor-subjsearch sent key type)
  "Search for the subject of a sentence SENT, looking for the noun closest
to and preceding KEY by at least TYPE words.  Set global variable subj to
the subject noun, and return the portion of the sentence following it."
  (let ((i (- (length sent) (length (memq key sent)) type)))
    (while (and (> i -1) (not (doctor-nounp (list-ref sent i))))
      (set! i (-1+ i)))
    (cond ((> i -1)
	   (set! subj (list-ref sent i))
	   (list-tail sent (1+ i)))
	  (else
	   (set! subj 'YOU)
	   #F))))

(define (doctor-nounp x)
  "Returns t if the symbol argument is a noun."
	(or (doctor-pronounp x)
	    (not (or (doctor-verbp x)
		     (equal? x 'NOT)
		     (doctor-prepp x)
		     (doctor-modifierp x) )) ))

(define (doctor-pronounp x)
  "Returns t if the symbol argument is a pronoun."
  (memq x '(
	I ME MINE MYSELF
	WE US OURS OURSELVES OURSELF
	YOU YOURS YOURSELF YOURSELVES
	HE HIM HIMSELF SHE HERS HERSELF
	IT THAT THOSE THIS THESE THINGS THING
	THEY THEM THEMSELVES THEIRS
	ANYBODY EVERYBODY SOMEBODY
	ANYONE EVERYONE SOMEONE
	ANYTHING SOMETHING EVERYTHING)))

(mapcar (lambda (x) (putprop x 'VERB 'DOCTOR-SENTENCE-TYPE))
	'(ABORT ABORTED ABORTS ASK ASKED ASKS AM
		APPLIED APPLIES APPLY ARE ASSOCIATE
		ASSOCIATED ATE
		BE BECAME BECOME BECOMES BECOMING
		BEEN BEING BELIEVE BELIEVED BELIEVES
		BIT BITE BITES BORE BORED BORES BORING BOUGHT BUY BUYS BUYING
		CALL CALLED CALLING CALLS CAME CAN CAUGHT CATCH COME
		CONTRACT CONTRACTED CONTRACTS CONTROL CONTROLLED CONTROLS
		COULD CROAK CROAKS CROAKED CUT CUTS
		DARE DARED DEFINE DEFINES DIAL DIALED DIALS DID DIE DIED DIES
		DISLIKE DISLIKED
		DISLIKES DO DOES DRANK DRINK DRINKS DRINKING
		DRIVE DRIVES DRIVING DROVE DYING
		EAT EATING EATS EXPAND EXPANDED EXPANDS
		EXPECT EXPECTED EXPECTS EXPEL EXPELS EXPELLED
		EXPLAIN EXPLAINED EXPLAINS
		FART FARTS FEEL FEELS FELT FIGHT FIGHTS FIND FINDS FINDING
		FORGET FORGETS FORGOT FOUGHT FOUND FUCK FUCKED
		FUCKING FUCKS
		GAVE GET GETS GETTING GIVE GIVES GO GOES GOING GONE GOT GOTTEN
		HAD HARM HARMS HAS HATE HATED HATES HAVE HAVING
		HEAR HEARD HEARS HEARING HELP HELPED HELPING HELPS
		HIT HITS HOPE HOPED HOPES HURT HURTS
		IMPLIES IMPLY IS
		JOIN JOINED JOINS JUMP JUMPED JUMPS
		KEEP KEEPING KEEPS KEPT
		KILL KILLED KILLING KILLS KISS KISSED KISSES KISSING
		KNEW KNOW KNOWS
		LAID LAY LAYS LET LETS LIE LIED LIES LIKE LIKED LIKES
		LIKING LISTEN LISTENS
		LOGIN LOOK LOOKED LOOKING LOOKS
		LOSE LOSING LOST
		LOVE LOVED LOVES LOVING
		LUSE LUSING LUST LUSTS
		MADE MAKE MAKES MAKING MAY MEAN MEANS MEANT MIGHT
		MOVE MOVED MOVES MOVING MUST
		NEED NEEDED NEEDS 
		ORDER ORDERED ORDERS OUGHT
		PAID PAY PAYS PICK PICKED PICKING PICKS 
		PLACED PLACING PREFER PREFERS PUT PUTS
		RAN RAPE RAPED RAPES
		READ READING READS RECALL RECEIVE RECEIVED RECEIVES
		REFER REFERED REFERRED REFERS
		RELATE RELATED RELATES REMEMBER REMEMBERED REMEMBERS
		ROMP ROMPED ROMPS RUN RUNNING RUNS
		SAID SANG SAT SAW SAY SAYS
		SCREW SCREWED SCREWING SCREWS SCROD SEE SEES SEEM SEEMED
		SEEMS SEEN SELL SELLING SELLS
		SEND SENDIND SENDS SENT SHALL SHOOT SHOT SHOULD
		SING SINGS SIT SITS SITTING SOLD STUDIED STUDY
		TAKE TAKES TAKING TALK TALKED TALKING TALKS TELL TELLS TELLING
		THINK THINKS
		THOUGHT TOLD TOOK TOOLED TOUCH TOUCHED TOUCHES TOUCHING
		TRANSFER TRANSFERRED TRANSFERS TRANSMIT TRANSMITS TRANSMITTED
		TYPE TYPES TYPES TYPING
		WALK WALKED WALKING WALKS WANT WANTED WANTS WAS WATCH
		WATCHED WATCHING WENT WERE WILL WISH WOULD WORK WORKED WORKS
		WRITE WRITES WRITING WROTE USE USED USES USING))

(define (doctor-verbp x) (if (symbol? x)
			    (eq? (getprop x 'DOCTOR-SENTENCE-TYPE) 'VERB)))

(define (doctor-plural x)
  "Form the plural of the word argument."
  (let ((foo (doctor-make-string x)))
    (cond ((string=? (doctor-substring foo -1) "S")
	   (cond ((string=? (doctor-substring foo -2 -1) "S")
		  (string->symbol (string-append foo "ES")))
		 (else x)))
	   ((string=? (doctor-substring foo -1) "Y")
	    (string->symbol (string-append (doctor-substring foo 0 -1)
			    "IES")))
	   (else (string->symbol (string-append foo "S"))))))

(define (doctor-setprep sent key)
  (let ((val '())
	(foo (memq key sent)))
    (cond ((doctor-prepp (doctor-cadr foo))
	   (set! val (doctor-getnoun (doctor-cddr foo)))
	   (cond (val val)
		 (else 'SOMETHING)))
	  ((doctor-articlep (doctor-cadr foo))
	   (set! val (doctor-getnoun (doctor-cddr foo)))
	   (cond (val (doctor-build (doctor-build (doctor-cadr foo) " ") val))
		 (else 'SOMETHING)))
	  (else 'SOMETHING))))

(define (doctor-getnoun x)
  (cond ((null? x) (set! object 'SOMETHING))
	((atom? x) (set! object x))
	((eq? (length x) 1)
	 (set! object (cond
		       ((doctor-nounp (set! object (car x))) object)
		       (else (doctor-query object)))))
	((eq? (car x) 'TO)
	 (doctor-build '|TO | (doctor-getnoun (cdr x))))
	((doctor-prepp (car x))
	 (doctor-getnoun (cdr x)))
	((not (doctor-nounp (car x)))
	 (doctor-build (doctor-build (cdr (assq (car x)
						(append
						 '((A . THIS)
						   (SOME . THIS)
						   (ONE . THAT))
						 (list
						  (cons
						   (car x) (car x))))))
				     " ")
		       (doctor-getnoun (cdr x))))
	(else (set! object (car x))) ))

(define (doctor-modifierp x)
  (or (doctor-adjectivep x)
      (doctor-adverbp x)
      (doctor-othermodifierp x)))

(define (doctor-adjectivep x)
  (or (number? x)
      (doctor-nmbrp x)
      (doctor-articlep x)
      (doctor-colorp x)
      (doctor-sizep x)
      (doctor-possessivepronounp x)))

(define (doctor-adverbp xx)
  (string=? (doctor-substring (doctor-make-string xx) -2) "LY"))

(define (doctor-articlep x)
  (memq x '(THE A AN)))

(define (doctor-nmbrp x)
  (memq x '(ONE TWO THREE FOUR FIVE SIX SEVEN EIGHT NINE TEN
		ELEVEN TWELVE THIRTEEN FOURTEEN FIFTEEN
		SIXTEEN SEVENTEEN EIGHTEEN NINETEEN
		TWENTY THIRTY FORTY FIFTY SIXTY SEVENTY EIGHTY NINETY
		HUNDRED THOUSAND MILLION BILLION
		HALF QUARTER
		FIRST SECOND THIRD FOURTH FIFTH
		SIXTH SEVENTH EIGHTH NINTH TENTH)))
		 
(define (doctor-colorp x)
  (memq x '(BEIGE BLACK BLUE BROWN CRIMSON
		  GRAY GREY GREEN
		  ORANGE PINK PURPLE RED TAN TAWNY
		  VIOLET WHITE YELLOW)))

(define (doctor-sizep x)
  (memq x '(BIG LARGE TALL FAT WIDE THICK
		SMALL PETITE SHORT THIN SKINNY)))

(define (doctor-possessivepronounp x)
  (memq x '(MY YOUR HIS HER OUR THEIR)))

(define (doctor-othermodifierp x)
  (memq x '(ALL ALSO ALWAYS AMUSING ANY ANYWAY ASSOCIATED AWESOME
		BAD BEAUTIFUL BEST BETTER BUT CERTAIN CLEAR
		EVER EVERY FANTASTIC FUN FUNNY
		GOOD GREAT GROSS GROWDY HOWEVER IF IGNORANT
		LESS LINKED LOSING LUSING MANY MORE MUCH
		NEVER NICE OBNOXIOUS OFTEN POOR PRETTY REAL RELATED RICH
		SIMILAR SOME STUPID SUPER SUPERB
		TERRIBLE TERRIFIC TOO TOTAL TUBULAR UGLY VERY)))

(define (doctor-prepp x)
  (memq x '(ABOUT ABOVE AFTER AROUND AS AT
		  BEFORE BENEATH BEHIND BESIDE BETWEEN BY
		  FOR FROM IN INSIDE INTO
		  LIKE NEAR NEXT OF ON ONTO OVER
		  SAME THROUGH THRU TO TOWARD TOWARDS
		  UNDER UNDERNEATH WITH WITHOUT)))

(define (doctor-remember thing)
  (cond ((null? history)
	 (set! history (list thing)))
	(else (set! history (append history (list thing))))))

(define (doctor-type x)
  (set! x (doctor-fix-2 x))
  (doctor-txtype (doctor-assm x)))

(define (doctor-fixup sent)
  (set! sent (append
	      (cdr
	       (assq (car sent)
		     (append
		      '((ME  I)
			(HIM  HE)
			(HER  SHE)
			(THEM  THEY)
			(OKAY)
			(WELL)
			(SIGH)
			(HMM)
			(HMMM)
			(HMMMM)
			(HMMMMM)
			(GEE)
			(SURE)
			(GREAT)
			(OH)
			(FINE)
			(OK)
			(NO))
		      (list (list (car sent)
				  (car sent))))))
	      (cdr sent)))
  (doctor-fix-2 sent))

(define (doctor-fix-2 sent)
  (let ((foo sent))
    (while foo
      (if (and (eq? (car foo) 'ME)
	       (doctor-verbp (doctor-cadr foo)))
	  (set-car! foo 'I)
	  (begin
	(cond ((eq? (car foo) 'YOU)
	       (cond ((memq (doctor-cadr foo) '(AM BE BEEN IS))
		      (set-car! (cdr foo) 'ARE))
		     ((memq (doctor-cadr foo) '(HAS))
		      (set-car! (cdr foo) 'HAVE))
		     ((memq (doctor-cadr foo) '(WAS))
		      (set-car! (cdr foo) 'WERE))))
	      ((equal? (car foo) 'I)
	       (cond ((memq (doctor-cadr foo) '(ARE IS BE BEEN))
		      (set-car! (cdr foo) 'AM))
		     ((memq (doctor-cadr foo) '(WERE))
		      (set-car! (cdr foo) 'WAS))
		     ((memq (doctor-cadr foo) '(HAS))
		      (set-car! (cdr foo) 'HAVE))))
	      ((and (doctor-verbp (car foo))
		    (eq? (doctor-cadr foo) 'I)
		    (not (doctor-verbp (car (doctor-cddr foo)))))
	       (set-car! (cdr foo) 'ME))
	      ((and (eq? (car foo) 'A)
		    (doctor-vowelp (string-ref (doctor-make-string (doctor-cadr foo)) 0)
		    ))
	       (set-car! foo 'AN))
	      ((and (eq? (car foo) 'AN)
		    (not (doctor-vowelp (string-ref (doctor-make-string (doctor-cadr foo)) 0)
			 )))
	       (set-car! foo 'A)))
	    (set! foo (cdr foo)))))
    sent))

(define (doctor-vowelp x)
  (memq (char-upcase x) '(#\A #\E #\I #\O #\U)))

(define (doctor-replace sent rlist)
  "Replace any element of SENT that is the car of a replacement
element pair in RLIST."
  (apply append
	 (mapcar
	   (lambda (x)
	     (cdr (or (assq x rlist)   ; either find a replacement
		      (list x x))))    ; or fake an identity mapping
	  sent)))

(define (doctor-wherego sent)
  (cond ((null? sent) ($ whereoutp))
	((null? (doctor-meaning (car sent)))
	 (doctor-wherego (cond ((zero? (random 2))
				(reverse (cdr sent)))
			       (else (cdr sent)))))
	(else
	 (set! found (car sent))
	 (doctor-meaning (car sent)))))

(define (doctor-svo sent key type mem)
  "Find subject, verb and object in sentence SENT with focus on word KEY.
TYPE is number of words preceding KEY to start looking for subject.
MEM is t if results are to be put on Doctor's memory stack.
Return in the global variables SUBJ, VERB and OBJECT."
  (let ((foo (doctor-subjsearch sent key type)))
    (or foo
	(begin (set! foo sent)
	       (set! mem #F)))
    (while (and (null? (doctor-verbp (car foo))) (cdr foo))
      (set! foo (cdr foo)))
    (set! verb (car foo))
    (set! obj (doctor-getnoun (cdr foo)))
    (cond ((eq? object 'I) (set! object 'ME))
	  ((eq? subj 'ME) (set! subj 'I)))
    (cond (mem (doctor-remember (list subj verb obj))))))

(define (doctor-possess sent key)
  "Set possessive in SENT for keyword KEY.
Hack on previous word, setting global variable OWNER to correct result."
  (let* ((i (- (length sent) (length (memq key sent)) 1))
	 (prev (if (< i 0) 'YOUR
		 (list-ref sent i))))
    (set! owner (if (or (doctor-possessivepronounp prev)
			(string=? "S"
				      (doctor-substring (doctor-make-string prev)
						 -1)))
		    prev
		  'YOUR))))

;; Output of replies.

(define (doctor-txtype ans)
  "Output to buffer a list of symbols or strings as a sentence."
  (set! *print-upcase* #T)
  (set! *print-space* #F)
  (mapcar doctor-type-symbol ans)
  (insert #\newline))

(define (doctor-type-symbol word)
  "Output a symbol to the buffer with some fancy case and spacing hacks."
  (set! word (doctor-make-string word))
  (if (string=? word "I") (set! word "I"))
  (if *print-upcase*
      (begin
	(set! word (capitalize word))
	(if *print-space*
	    (insert " "))))
  (cond ((or (substring-find-next-char-in-set word 0 (min 1 (string-length word)) ".,;:?! ")
	     (not *print-space*))
	 (insert word))
	(else (insert #\space word)))
  (set! *print-upcase* (substring-find-next-char-in-set
			 word (max 0 (-1+ (string-length word)))
			 (string-length word) "[.?!]$"))
  (set! *print-space* #T))

(define (doctor-build str1 str2)
  "Make a symbol out of the concatenation of the two non-list arguments."
  (cond ((null? str1) str2)
	((null? str2) str1)
	((and (atom? str1)
	      (atom? str2))
	 (string->symbol (string-append (doctor-make-string str1)
			 (doctor-make-string str2))))
	(else #F)))

(define (doctor-make-string obj)
  (cond ((string? obj) obj)
	((symbol? obj) (symbol->string obj))
	((number? obj) (number->string obj))
	(else "")))

(define (doctor-concat x y)
  "Like append, but force atomic arguments to be lists."
  (append
   (if (and x (atom? x)) (list x) x)
   (if (and y (atom? y)) (list y) y)))

(define (doctor-assm proto)
  (cond ((null? proto) #F)
	((atom? proto) (list proto))
	((atom? (car proto))
	 (cons (car proto) (doctor-assm (cdr proto))))
	(else (doctor-concat (doctor-assm (eval (car proto))) (doctor-assm (cdr proto))))))

;; Functions that handle specific words or meanings when found.

(define (doctor-go destination)
  "Call a `doctor-*' function."
  (eval (list (string->symbol (string-append "DOCTOR-" (doctor-make-string destination))))))

(define (doctor-desire1)
  (doctor-go ($ whereoutp)))

(define (doctor-huh)
  (cond ((< (length sent) 9) (doctor-type ($ huhlst)))
	(else (doctor-type ($ longhuhlst)))))

(define (doctor-rthing) (doctor-type ($ thlst)))

(define (doctor-remem) (cond ((null? history) (doctor-huh))
			     ((doctor-type ($ remlst)))))

(define (doctor-howdy)
  (cond ((not howdyflag)
	 (doctor-type '(($ hello) WHAT BRINGS YOU TO SEE ME ?))
	 (set! howdyflag #T))
	(else
	 (doctor-type '(($ ibelieve) |WE'VE| INTRODUCED OURSELVES ALREADY |.|))
	 (doctor-type '(($ please) ($ describe) ($ things) |.|)))))

(define (doctor-when)
  (cond ((< (length (memq found sent)) 3) (doctor-short))
	(else
	 (set! sent (cdr (memq found sent)))
	 (set! sent (doctor-fixup sent))
	 (doctor-type '(($ whatwhen) (// sent) ?)))))

(define (doctor-conj)
  (cond ((< (length (memq found sent)) 4) (doctor-short))
	(else
	 (set! sent (cdr (memq found sent)))
	 (set! sent (doctor-fixup sent))
	 (cond ((eq? (car sent) 'OF)
		(doctor-type '(ARE YOU ($ sure) THAT IS THE REAL REASON ?))
		(set! things (cons (cdr sent) things)))
	       (else
		(doctor-remember sent)
		(doctor-type ($ beclst)))))))

(define (doctor-short)
  (cond ((= (car repetitive-shortness) (-1+ lincount))
	 (set-cdr! repetitive-shortness
		 (1+ (cdr repetitive-shortness))))
	(else
	 (set-cdr! repetitive-shortness 1)))
  (set-car! repetitive-shortness lincount)
  (cond ((> (cdr repetitive-shortness) 6)
	 (cond ((not **mad**)
		(doctor-type '(($ areyou)
			       JUST TRYING TO SEE WHAT KIND OF THINGS
			       I HAVE IN MY VOCABULARY ? PLEASE TRY TO
			       CARRY ON A REASONABLE CONVERSATION!))
		(set! **mad** #T))
	       (else
		(doctor-type '(I GIVE UP |.| YOU NEED A LESSON IN CREATIVE
				 WRITING |...|))
		;;(push monosyllables observation-list)
		)))
	(else
	 (cond ((equal? sent (doctor-assm '(YES)))
		(doctor-type '(($ isee) ($ inter) ($ whysay) THIS IS SO ?)))
	       ((equal? sent (doctor-assm '(BECAUSE)))
		(doctor-type ($ shortbeclst)))
	       ((equal? sent (doctor-assm '(NO)))
		(doctor-type ($ neglst)))
	       (else (doctor-type ($ shortlst)))))))
	   
(define (doctor-alcohol) (doctor-type ($ drnk)))

(define (doctor-desire)
  (let ((foo (memq found sent)))
    (cond ((< (length foo) 2)
	   (doctor-go (doctor-build (doctor-meaning found) 1)))
	  ((memq (doctor-cadr foo) '(A AN))
	   (set-cdr! foo (append '(TO HAVE) (cdr foo)))
	   (doctor-svo sent found 1 #F)
	   (doctor-remember (list subj 'WOULD 'LIKE obj))
	   (doctor-type ($ whywant)))
	  ((not (eq? (doctor-cadr foo) 'TO))
	   (doctor-go (doctor-build (doctor-meaning found) 1)))
	  (else
	   (doctor-svo sent found 1 #F)
	   (doctor-remember (list subj 'WOULD 'LIKE obj))
	   (doctor-type ($ whywant))))))

(define (doctor-drug)
  (doctor-type ($ drugs))
  (doctor-remember (list 'YOU 'USED found)))

(define (doctor-toke)
  (doctor-type ($ toklst)))

(define (doctor-state)
  (doctor-type ($ states)) (doctor-remember (lisT 'YOU 'WERE found)))

(define (doctor-mood)
  (doctor-type ($ moods)) (doctor-remember (list 'YOU 'FELT found)))

(define (doctor-fear)
  (set! feared (doctor-setprep sent found))
  (doctor-type ($ fears))
  (doctor-remember (list 'YOU 'WERE 'AFRAID 'OF feared)))

(define (doctor-hate)
  (doctor-svo sent found 1 #T)
  (cond ((memq 'NOT sent) (doctor-forget) (doctor-huh))
	((equal? subj 'YOU)
	 (doctor-type '(WHY DO YOU (// verb) (// obj) ?)))
	(else (doctor-type '(($ whysay) (list subj verb obj))))))

(define (doctor-symptoms)
  (doctor-type '(($ maybe) YOU SHOULD CONSULT A DOCTOR OF |MEDICINE,|
		 I AM A PSYCHIATRIST |.|)))

(define (doctor-hates)
  (doctor-svo sent found 1 #T)
  (doctor-hates1))

(define (doctor-hates1)
  (doctor-type '(($ whysay) (list subj verb obj))))

(define (doctor-loves)
  (doctor-svo sent found 1 #T)
  (doctor-qloves))

(define (doctor-qloves)
  (doctor-type '(($ bother) (list subj verb obj) ?)))

(define (doctor-love)
  (doctor-svo sent found 1 #T)
  (cond ((memq 'NOT sent) (doctor-forget) (doctor-huh))
	((memq 'TO sent) (doctor-hates1))
	(else
	 (cond ((equal? object 'SOMETHING)
		(set! object '(THIS PERSON YOU LOVE))))
	 (cond ((equal? subj 'YOU)
		(set! lover obj)
		(cond ((equal? lover '(THIS PERSON YOU LOVE))
		       (set! lover '(YOUR PARTNER))
		       (doctor-forget)
		       (doctor-type '(WITH WHOM ARE YOU IN LOVE ?)))
		      ((doctor-type '(($ please)
				      ($ describe)
				      ($ relation)
				      (// lover)
				      |.|)))))
	       ((equal? subj 'I)
		(doctor-txtype '(WE WERE DISCUSSING YOU!)))
	       (else (doctor-forget)
		  (set! obj 'SOMEONE)
		  (set! verb (doctor-build verb 'S))
		  (doctor-qloves))))))

(define (doctor-mach)
  (set! found (doctor-plural found))
  (doctor-type ($ machlst)))

(define (doctor-sexnoun) (doctor-sexverb))

(define (doctor-sexverb)
  (if (or (memq 'ME sent) (memq 'MYSELF sent) (memq 'I sent))
      (doctor-foul)
    (doctor-type ($ sexlst))))

(define (doctor-death) (doctor-type ($ deathlst)))

(define (doctor-foul)
  (doctor-type ($ foullst)))

(define (doctor-family)
  (doctor-possess sent found)
  (doctor-type ($ famlst)))

;; I did not add this -- rms.
;; But he might have removed it.  I put it back.  --roland
(define (doctor-rms)
  (cond (rms-flag (doctor-type ($ stallmanlst)))
	(else (set! rms-flag #T) (doctor-type '(DO YOU KNOW STALLMAN ?)))))

(define (doctor-school) (doctor-type ($ schoollst)))

(define (doctor-eliza)
  (cond (eliza-flag (doctor-type ($ elizalst)))
	(else (set! eliza-flag #T)
	      (doctor-type '((// found) ? HAH !
			     ($ please) ($ continue) |.|)))))

(define (doctor-sports)  (doctor-type ($ sportslst)))

(define (doctor-math) (doctor-type ($ mathlst)))

(define (doctor-zippy)
  (cond (zippy-flag (doctor-type ($ zippylst)))
	(else (set! zippy-flag #T)
	   (doctor-type '(YOW! ARE WE INTERACTIVE YET ?)))))


(define (doctor-chat) (doctor-type ($ chatlst)))

(define (doctor-strangelove)
  (interactive)
  (insert "MEIN FUHRER!!\N")
  (doctor-read-print))

;;; doctor.el ends here

(define (doctor)
  (make-doctor-variables)
  (doctor-type '(I AM THE PSYCHOTHERAPIST |.|
		 ($ please) ($ describe) YOUR ($ problems) |.|
		 EACH TIME YOU ARE FINISHED |TALKING,| TYPE |<RET>.|))
  (insert #\newline)
  (let loop ()
    (doctor-read-print)
    (loop)))

