(define (dist n)
  (define (compute n)
    (if (<= n 10)
	(vector-ref #(0 1 7 2 5 8 16 3 19 6) (-1+ n))
	(let loop ((bits 3) (pow 8))
	  (let ((next (* pow pow)))
	    (if (>= next n)
		(let* ((qt (quotient n pow))
		       (rt (remainder n pow))
		       (u (CollatzMod rt bits)))
		  (+ (cdr u) bits
		     (compute (+ (car u) (* qt (expt 3 (cdr u)))))))
		(loop (+ bits bits) next))))))
  (if (or (not (integer? n))
	  (< n 1))
      (error "Invalid argument" n))
  (compute n))

(define (CollatzMod a b)
  (if (<= b 3)
      (vector-ref (vector-ref '#(#((0 . 0) (0 . 0) (0 . 0))
				 #((2 . 1) (1 . 1) (2 . 2))
				 #(() (2 . 1) (1 . 1))
				 #(() (8 . 2) (4 . 2))
				 #(() () (2 . 1))
				 #(() () (2 . 1))
				 #(() () (8 . 2))
				 #(() () (26 . 3))) a) (-1+ b))
      (let* ((b2 (quotient b 2))
	     (pow (expt 2 b2))
	     (u1 (CollatzMod (remainder a pow) b2))
	     (t (+ (* (quotient a pow) (expt 3 (cdr u1)))
		   (car u1)))
	     (u2 (CollatzMod (remainder t pow) b2)))
	(cons (+ (* (quotient t pow) (expt 3 (cdr u2))) (car u2))
	      (+ (cdr u1) (cdr u2))))))


