;;; -*-Scheme-*-
;;;
;;;	$Header: studen.scm,v 13.4 87/08/21 22:10:23 GMT cph Rel $
;;;
;;;	Copyright (c) 1987 Massachusetts Institute of Technology
;;;
;;;	This material was developed by the Scheme project at the
;;;	Massachusetts Institute of Technology, Department of
;;;	Electrical Engineering and Computer Science.  Permission to
;;;	copy this software, to redistribute it, and to use it for any
;;;	purpose is granted, subject to the following restrictions and
;;;	understandings.
;;;
;;;	1. Any copy made of this software must include this copyright
;;;	notice in full.
;;;
;;;	2. Users of this software agree to make their best efforts (a)
;;;	to return to the MIT Scheme project any improvements or
;;;	extensions that they make, so that these may be included in
;;;	future releases; and (b) to inform MIT of noteworthy uses of
;;;	this software.
;;;
;;;	3. All materials developed as a consequence of the use of this
;;;	software shall duly acknowledge such use, in accordance with
;;;	the usual standards of acknowledging credit in academic
;;;	research.
;;;
;;;	4. MIT has made no warrantee or representation that the
;;;	operation of this software will be error-free, and MIT is
;;;	under no obligation to provide any services, by way of
;;;	maintenance, update, or otherwise.
;;;
;;;	5. In conjunction with products arising from the use of this
;;;	material, there shall be no use of the name of the
;;;	Massachusetts Institute of Technology nor of any adaptation
;;;	thereof in any advertising, promotional, or sales literature
;;;	without prior written consent from MIT in each case.
;;;

;;;; Environment, syntax and read table hacking for 6.001 students.

(declare (usual-integrations))

;;; Define the #/ syntax.

(in-package parser-package
  (define-char-special #\/
    (lambda ()
      (discard-char)
      (char->ascii (read-char)))))

(define user-global-environment)

(define student-package
  (make-environment

;;;; Syntax Restrictions

(define system-global-parser-table
  *parser-table*)

(define sicp-parser-table
  (parser-table-copy system-global-parser-table))

(define *student-parser-table*)

(define sicp-syntax-table
  (make-syntax-table))

(define *student-syntax-table*)

(define (enable-system-syntax)
  (set! *parser-table* system-global-parser-table)
  (set-rep-base-syntax-table! system-global-syntax-table))

(define (disable-system-syntax)
  (set! *parser-table* *student-parser-table*)
  (set-rep-base-syntax-table! *student-syntax-table*))

(define (initialize-syntax!)
  ;; First hack the parser (reader) table
  ;; Remove backquote and comma
  (let ((undefined-entry (parser-table-entry system-global-parser-table "|")))
    (set-parser-table-entry! sicp-parser-table "`" undefined-entry)
    (set-parser-table-entry! sicp-parser-table "," undefined-entry))
  ;; Add brackets as extended alphabetic since they are used in book (ugh!)
  (let ((extended-entry (parser-table-entry system-global-parser-table "/")))
    (set-parser-table-entry! sicp-parser-table "[" extended-entry)
    (set-parser-table-entry! sicp-parser-table "]" extended-entry))
  ;; Remove balanced comments and characters
  (let ((undefined-entry (parser-table-entry system-global-parser-table "#[")))
    (set-parser-table-entry! sicp-parser-table "#|"
			     undefined-entry)
    (set-parser-table-entry! sicp-parser-table "#\\"
			     undefined-entry))
  ;; Now, hack the syntax (special form) table.
  (for-each (lambda (name)
	      (syntax-table-define
		  sicp-syntax-table
		  name
		(or (syntax-table-ref system-global-syntax-table name)
		    (error "Missing syntactic keyword" name))))
	    '(BKPT COLLECT COND CONS-STREAM DEFINE DELAY ERROR IF
		   LAMBDA LET MAKE-ENVIRONMENT QUOTE SEQUENCE
		   SET! THE-ENVIRONMENT))
  (set! *student-parser-table* (parser-table-copy sicp-parser-table))
  (set! *student-syntax-table* (copy-syntax-table sicp-syntax-table))
  #T)

;;;; Global Environment

(define (global-environment-enabled?)
  (or (eq? user-global-environment system-global-environment)
      (environment-has-parent? user-global-environment)))

(define (in-user-environment-chain? environment)
  (or (eq? environment user-global-environment)
      (and (not (eq? environment system-global-environment))
	   (environment-has-parent? environment)
	   (in-user-environment-chain? (environment-parent environment)))))

(define (enable-global-environment)
  ((access system-environment-add-parent! environment-package)
   user-global-environment
   system-global-environment)
  'ENABLED)

(define (disable-global-environment)
  ((access system-environment-remove-parent! environment-package)
   user-global-environment)
  'DISABLED)

(define (student-environment-warning-hook environment)
  (if (not (in-user-environment-chain? environment))
      (begin
	(newline)
	(write-string "This environment is part of the Scheme system.")
	(newline)
	(write-string
	 "Performing side-effects in it may cause damage to the system."))))

;;;; Feature hackery

(define (enable-language-features . prompt)
  (without-interrupts
   (lambda ()
     (enable-global-environment)
     (enable-system-syntax)
     (change-prompt-wrapper "]" ""
			    (coerce-prompt 'ENABLE-LANGUAGE-FEATURES prompt))
     *the-non-printing-object*)))

(define (disable-language-features . prompt)
  (without-interrupts
   (lambda ()
     (disable-global-environment)
     (disable-system-syntax)
     (change-prompt-wrapper "" "" 
			    (coerce-prompt 'DISABLE-LANGUAGE-FEATURES prompt))
     *the-non-printing-object*)))

(define (language-features-enabled?)
  (global-environment-enabled?))

(define (coerce-prompt name prompt)
  (cond ((null? prompt) #F)
	((string? (car prompt)) (car prompt))
	(else (error "Prompt is not a string" name (car prompt)))))

(define (change-prompt-wrapper prefix suffix string)
  (let ((base-prompt (rep-base-prompt))
	(current-prompt (rep-prompt)))
    (set-rep-base-prompt!
     (make-student-prompt prefix
			  (if (eq? base-prompt current-prompt)
			      (or string (student-prompt-string base-prompt))
			      (student-prompt-string base-prompt))
			  suffix))
    (set-rep-prompt!
     (make-student-prompt prefix
			  (or string (student-prompt-string current-prompt))
			  suffix))))

(define (reset-student-prompt string)
  (let ((prompt (make-student-prompt "" string "")))
    (set-rep-base-prompt! prompt)
    (set-rep-prompt! prompt)))

(define (make-student-prompt prefix string suffix)
  #|
  ;; This should just be
  (standard-rep-prompt (string-append prefix string suffix))
  ;; but it does not work because of the student-prompt-string kludge.
  |#
  (let ((real-string (string-append prefix string suffix)))
    (lambda ()
      (if rep-prompt-hook
	  (rep-prompt-hook (rep-level) real-string)
	  (begin (newline)
		 (newline)
		 (write (rep-level))
		 (write-char #\Space)
		 (write-string real-string)
		 (write-char #\Space))))))		     

(define (student-prompt-string prompt)
  (access string (procedure-environment prompt)))

;;;; Clean environment hackery

(define user-global-names
  '(
    (%EXIT)
    (%GE)
    (%IN) 
    (%OUT)
    (%VE)
    (*)
    (*ARGS*)
    (*PROC*)
    (*RESULT*)
    (+)
    (-)
    (-1+)
    (/)
    (1+)
    (<)
    (<=)
    (=)
    (>)
    (>=)
    (ABS)
    (ACCUMULATE)
    (ACCUMULATE-DELAYED)
    (ADD-STREAMS)
    (ADVICE)
    (ADVISE-ENTRY)
    (ADVISE-EXIT)
    (ALPHALESS?)
    (AND . AND*)
    (APPEND)
    (APPEND-STREAMS)
    (APPLICABLE?)
    (APPLY)
    (ASCII)
    (ASSOC)
    (ASSQ . USER-ASSQ)
    (ASSV)
    (ATAN)
    (ATOM?)
    ;; (BACKUP-FLOPPY)
    (BREAK . BREAK-ENTRY)
    (BREAK-BOTH . BREAK)
    (BREAK-ENTRY)
    (BREAK-EXIT)
    (BREAKPOINT-PROCEDURE)

    (CAR)
    (CAAAAR)
    (CAAADR)
    (CAAAR)
    (CAADAR)
    (CAADDR)
    (CAADR)
    (CAAR)
    (CADAAR)
    (CADADR)
    (CADAR)
    (CADDAR)
    (CADDDR)
    (CADDR)
    (CADR)
    (CDR)
    (CDAAAR)
    (CDAADR)
    (CDAAR)
    (CDADAR)
    (CDADDR)
    (CDADR)
    (CDAR)
    (CDDAAR)
    (CDDADR)
    (CDDAR)
    (CDDDAR)
    (CDDDDR)
    (CDDDR)
    (CDDR)
    (CEILING)
    (CHAR)
    (CLEAR-GRAPHICS)
    (CLEAR-POINT)
    (CLOSE-CHANNEL)
    (CONS)
    (CONS*)
    (COPY-FILE)
    (COS)
    (DEBUG)
    (DELETE-FILE)
    (DISK-SAVE . STUDENT-BAND)
    (DRAW-LINE-TO)
    (DRAW-POINT)
    (DUMP-WORLD . STUDENT-DUMP)

    ;; (EDIT)
    (EIGHTH)
    (EMPTY-STREAM?)
    (ENABLE-LANGUAGE-FEATURES)
    (ENUMERATE-FRINGE)
    (ENUMERATE-INTERVAL)
    (ENVIRONMENT?)
    (EQ?)
    (EQUAL?)
    (EQV?)
    (ERROR-PROCEDURE)
    (EVAL)
    (EVEN?)
    (EXP)
    (EXPLODE)
    (EXPT)
    (FALSE)
    (FIFTH)
    (FILE-EXISTS?)
    (FILTER)
    (FIRST)
    (FLATMAP)
    (FLATTEN)
    (FLOOR)
    (FORCE)
    (FOURTH)
    (GCD)
    (GENERATE-UNINTERNED-SYMBOL)
    (HEAD)
    (IMPLODE)
    ;; (INITIALIZE-FLOPPY)
    (INTEGER-DIVIDE)
    (INTEGER?)
    (INTEGERS)
    (INTEGERS-FROM)
    (INTERLEAVE-DELAYED)
    (LAST . LAST-PAIR)
    (LENGTH)
    (LIST)
    (LIST* . CONS*)
    ;; (LIST-FILE)
    (LIST-REF)
    (LIST-TAIL)
    (LIST?)
    (LOAD)
    (LOAD-NOISILY)
    (LOG)

    (MAP-STREAM)
    (MAP-STREAM-2)
    (MAPC . FOR-EACH)
    (MAPCAR . MAP)
    (MAX)
    (MEMBER)
    (MEMQ . USER-MEMQ)
    (MEMV)
    (MERGE)
    (MIN)
    (NEGATIVE?)
    (NEWLINE)
    (NIL)
    (NOT)
    (NTH)
    (NTH-STREAM)
    (NTHCDR)
    (NULL?)
    (NUMBER?)
    (OBJECT-TYPE)
    (ODD?)
    (OPEN-READER-CHANNEL . OPEN-INPUT-FILE)
    (OPEN-PRINTER-CHANNEL . OPEN-OUTPUT-FILE)
    (OR . OR*)
    (PAIR?)
    (PEEKCH)
    (PHOTO . TRANSCRIPT-ON)
    (POSITION-PEN)
    (POSITIVE?)
    (PP)
    (PRIN1 . WRITE)
    (PRINC . DISPLAY)
    (PRINT)
    (PRINT-BREADTH)
    (PRINT-DEPTH)
    (PRINT-STREAM)
    (PROCEED)
    (QUIT)
    (QUOTIENT)
    (RANDOM)
    (READ)
    (READCH)
    (RELOAD)
    (REMAINDER)
    (REVERSE)
    (ROUND)
    (RUNTIME)

    (SCALE-STREAM)
    (SECOND)
    (SET-CAR!)
    (SET-CDR!)
    (SEVENTH)
    (SIN)
    (SIXTH)
    (SPREAD-TUPLE)
    (SQRT)
    (STRING-LESS?. STRING<?)
    (SYMBOL?)
    (T)
    (TAIL)
    (TAN)
    (THE-EMPTY-STREAM)
    (THIRD)
    (TOFU . TRANSCRIPT-OFF)
    (TRACE . TRACE-ENTRY)
    (TRACE-BOTH . TRACE)
    (TRACE-ENTRY)
    (TRACE-EXIT)
    (TRUE)
    (TRUNCATE)
    (TYI)
    (TYIPEEK)
    (TYO)
    (UNADVISE)
    (UNADVISE-ENTRY)
    (UNADVISE-EXIT)
    (UNBREAK)
    (UNBREAK-ENTRY)
    (UNBREAK-EXIT)
    (UNTRACE)
    (UNTRACE-ENTRY)
    (UNTRACE-EXIT)
    (USER-GLOBAL-ENVIRONMENT . #T)
    (USER-INITIAL-ENVIRONMENT . #T)
    (VECTOR)
    (VECTOR-CONS)
    (VECTOR-REF)
    (VECTOR-SET!)
    (VECTOR-SIZE . VECTOR-LENGTH)
    (VECTOR?)
    (WHERE)
    (ZERO?)))

;;; Environment setup code

(define (warn-about-missing-objects missing)
  (for-each
   (lambda (name)
     (newline)
     (write-string "Warning -- missing name: ")
     (write name))
   missing))

(define (setup-user-global-environment!)
  (define (copy-if-proc object)
    (if (compound-procedure? object)
	(scode-eval (lambda-components (procedure-lambda object)
		      make-lambda)
		    (procedure-environment object))
	object))

  (build-environment
   user-global-names
   system-global-environment	; Where to look
   system-global-environment	; Parent frame
   copy-if-proc			; What to do to each value
   (lambda (frame missing)
     (scode-eval (scode-quote
		  (begin
		    (set! user-global-environment (the-environment))
		    (set! user-initial-environment (make-environment))))
		 frame)
     (set! user-global-environment frame)
     (set! user-initial-environment
	   (lexical-reference frame 'user-initial-environment))
     (warn-about-missing-objects missing))))

;;;; Saving and restoring the student system

(define student-band-pathname)

(define (initialize-system)
  (set! init-file-pathname
	(merge-pathnames
	 (make-pathname #F #F #F "sicp" #F)
	 init-file-pathname))
  (set! student-band-pathname
	(merge-pathnames
	 (make-pathname #F #F "sicp" "bin" #F)
	 (->pathname
	  (or ((make-primitive-procedure 'reload-band-name))
	      ((make-primitive-procedure 'microcode-tables-filename))))))
  (add-event-receiver!
   event:after-restart
   (lambda ()
     (if (language-features-enabled?)
	 (disable-language-features))
     (if (graphics-available?)
	 (init-graphics)
	 (begin
	   (newline)
	   (display "*** Note: no graphics available in this system. ***")))))
  #T)

(define (reload #!optional filename)
  (disk-restore
   (if (unassigned? filename)
       student-band-pathname
       (merge-pathnames (->pathname filename)
			student-band-pathname))))   

(define (student-band #!optional filename)
  (if (not (unassigned? filename))
      (set! student-band-pathname
	    (merge-pathnames (->pathname filename)
			     student-band-pathname)))
  (disk-save student-band-pathname))

(define (student-dump filename)
  (dump-world filename))

;;; End STUDENT-PACKAGE.
))

;;;; Exports

(define enable-language-features
  (access enable-language-features student-package))

(define disable-language-features
  (access disable-language-features student-package))

(define reload
  (access reload student-package))

(define student-band
  (access student-band student-package))

(define student-dump
  (access student-dump student-package))

;;; Install the student package

((access initialize-syntax! student-package))
((access setup-user-global-environment! student-package))
((access initialize-system student-package))
(set! environment-warning-hook
      (access student-environment-warning-hook student-package))
(set-rep-base-environment! user-initial-environment)
((access reset-student-prompt student-package) "==>")
(disable-language-features)