### -*-Midas-*-
###
###	Copyright (c) 1987 Massachusetts Institute of Technology
###
###	This material was developed by the Scheme project at the
###	Massachusetts Institute of Technology, Department of
###	Electrical Engineering and Computer Science.  Permission to
###	copy this software, to redistribute it, and to use it for any
###	purpose is granted, subject to the following restrictions and
###	understandings.
###
###	1. Any copy made of this software must include this copyright
###	notice in full.
###
###	2. Users of this software agree to make their best efforts (a)
###	to return to the MIT Scheme project any improvements or
###	extensions that they make, so that these may be included in
###	future releases; and (b) to inform MIT of noteworthy uses of
###	this software.
###
###	3. All materials developed as a consequence of the use of this
###	software shall duly acknowledge such use, in accordance with
###	the usual standards of acknowledging credit in academic
###	research.
###
###	4. MIT has made no warrantee or representation that the
###	operation of this software will be error-free, and MIT is
###	under no obligation to provide any services, by way of
###	maintenance, update, or otherwise.
###
###	5. In conjunction with products arising from the use of this
###	material, there shall be no use of the name of the
###	Massachusetts Institute of Technology nor of any adaptation
###	thereof in any advertising, promotional, or sales literature
###	without prior written consent from MIT in each case.
###

#### $Header: cmp68020.s,v 9.56 87/11/09 21:25:24 GMT cph Rel $
####
#### Compiled Code Interface for HP9000 series 300

define(rfree, %a5)
define(regs, %a6)
define(rmask, %d7)

define(switch_to_compiled_code_registers,
	`mov.l	%sp,c_save_stack
	mov.l	_Ext_Stack_Pointer,%sp
	mov.l	_Free,rfree
	lea	_Registers,regs')

define(switch_to_interpreter_registers,
	`mov.l	rfree,_Free
	mov.l	%sp,_Ext_Stack_Pointer
	mov.l	c_save_stack,%sp')

define(compiler_invoke_continuation,
	`clr.b	(%sp)
	rts')

### push the arguments in order, left to right.

define(push,
	`ifelse(eval($# > 1), 1,
	`mov.l	$1,-(%sp)
	push(shift($*))',
	eval((len($1)) > 0), 1,
	`mov.l	$1,-(%sp)')')

### push the arguments in order, right to left.

define(push_reversed,
	`ifelse(eval($# > 1), 1,
	`push_reversed(shift($*))
	mov.l	$1,-(%sp)',
	eval((len($1)) > 0), 1,
	`mov.l	$1,-(%sp)')')

### pop the arguments in order, right to left.

define(pop,
	`ifelse(eval($# > 1), 1,
	`pop(shift($*))
	mov.l	(%sp)+,$1',
	eval((len($1)) > 0), 1,
	`mov.l	(%sp)+,$1')')

define(pop_discard,
	`ifelse(eval($1 > 2), 1,
	`lea	eval($1 * 4)(%sp),%sp',
	eval($1 > 0), 1,
	`addq.l	&eval($1 * 4),%sp')')

define(push_frame_count,
	`ext.l	$1
	push($1)')

define(make_object, `$1*0x1000000+$2')

define(false_object, make_object(tc_null, 0))
define(null_object, make_object(tc_null, 0))
define(true_object, make_object(tc_true, 0))

define(push_return_code,
	`push(&false_object)
	push(&make_object(tc_return_code,$1))')

define(push_fixnum_word,
	`mov.w	$1,-(%sp)
	mov.w	&tc_fixnum*0x100,-(%sp)')

define(push_fixnum_long,
	`mov.l	$1,-(%sp)
	mov.b	&tc_fixnum,(%sp)')

define(push_compiled_code_block,
	`mov.l	$1,-(%sp)
	mov.b	&tc_compiled_code_block,(%sp)')

define(c_call_c,
	`push_reversed(shift($*))
	jsr	_$1
	pop_discard(eval($# - 1))')

define(c_call,
	`switch_to_interpreter_registers()
	c_call_c($*)
	switch_to_compiled_code_registers()')

define(define_c_label,
`	global	_$1
_$1:')

define(define_debugging_label,
`	global	$1
$1:')

define(define_simple_c_procedure,
`define_c_label($1)')

define(define_c_procedure,
`define_c_label($1)
	movm.l	%d2-%d7/%a0-%a6,-(%sp)
	mov.l	&0x00ffffff,rmask
	switch_to_compiled_code_registers()')

define(adjust_return_address,
	`addq.l	&2,(%sp)
	mov.b	&tc_return_address,(%sp)')

# The first few (/4) must match const.h

# 10 registers for the compiled code interface.
	set	regblock_memtop,0
	set	regblock_stackguard,4
	set	regblock_val,8
	set	regblock_env,12
	set	regblock_temp,16
	set	regblock_expr,20
	set	regblock_return,24
#	set	regblock_spare,28
#	set	regblock_spare,32
#	set	regblock_spare,36

# 50 registers for compiled code temporaries.
	set	regblock_temporaries,40
	set	regblock_ntemps,50

# 20 6-byte entry points.
	set	regblock_entries,(regblock_temporaries + (regblock_ntemps * 4))
	set	regblock_nentries,20
	set	offset_return_to_interpreter,(regblock_entries + (15 * 6))

# An area for popper code.
	set	regblock_messages,(regblock_entries + (regblock_nentries * 6))

# 40 more 6-byte entry points.
	set	regblock_entries_2,(regblock_messages + 192)
	set	regblock_nentries_2,40
	set	regblock_length,(regblock_entries_2 + (regblock_nentries_2 * 6))
	set	offset_fake_uuo_link_trap,(regblock_entries_2 + 6)
	set	offset_uuo_link_trap,(regblock_entries_2 + (21 * 6))

# types and other constants required.

	set	prim_done,-1
	set	prim_do_expression,-2
	set	prim_apply,-3
	set	prim_interrupt,-4
	set	prim_no_trap_eval,-5
	set	prim_no_trap_apply,-6
	set	prim_pop_return,-7

	set	tc_null,0x00
	set	tc_manifest_vector,0x00
	set	tc_list,0x01
	set	tc_flonum,0x06
	set	tc_true,0x08
	set	tc_vector,0x0a
	set	tc_return_code,0x0b
	set	tc_compiled_procedure,0x0d
	set	tc_environment,0x12
	set	tc_fixnum,0x1a
	set	tc_manifest_nm_vector,0x27
	set	tc_reference_trap,0x32
	set	tc_return_address,0x39
	set	tc_compiled_code_block,0x3d

	set	pc_zero,0xe6
	set	pc_positive,0xe7
	set	pc_negative,0xe8
	set	pc_equal,0xe9
	set	pc_less,0xea
	set	pc_greater,0xeb
	set	pc_plus,0xec
	set	pc_minus,0xed
	set	pc_multiply,0xee
	set	pc_divide,0xef
	set	pc_increment,0xf1
	set	pc_decrement,0xf2

	set	err_wrong_number_of_arguments,0x0c
	set	err_compiled_code_error,0x31

	set	int_gc_bit,2

	set	fobject_compiler_error_procedure,0x21*4

	set	rc_comp_reference_restart,0x1f
	set	rc_comp_assignment_restart,0x28
	set	rc_comp_interrupt_restart,0x43
	set	rc_comp_lookup_apply_restart,0x4b
	set	rc_comp_access_restart,0x4c
	set	rc_comp_unassigned_p_restart,0x4d
	set	rc_comp_unbound_p_restart,0x4e
	set	rc_comp_definition_restart,0x4f
	set	rc_comp_lexpr_interrupt_restart,0x50
	set	rc_comp_safe_reference_restart,0x51
	set	rc_comp_cache_lookup_restart,0x52
	set	rc_comp_lookup_trap_restart,0x53
	set	rc_comp_assignment_trap_restart,0x54
	set	rc_comp_cache_operator_restart,0x55
	set	rc_comp_op_ref_trap_restart,0x56
	set	rc_comp_cache_reference_apply_restart,0x57
	set	rc_comp_safe_ref_trap_restart,0x58
	set	rc_comp_unassigned_p_trap_restart,0x59
	set	rc_comp_cache_assignment_restart,0x5A

	data
define_c_label(Registers)
	space	regblock_length
define_c_label(compiler_utilities)
	space	4
define_c_label(return_to_interpreter)
	space	4
define_c_label(fake_uuo_link_trap)
	space	4
define_c_label(uuo_link_trap)
	space	4
define_debugging_label(c_save_stack)
	space	4

	text
define_c_procedure(enter_compiled_expression)
	mov.l	regblock_expr(regs),%d0	# Mask and branch on the expression.
	and.l	rmask,%d0
	mov.l	%d0,%a0
	jmp	(%a0)

define_c_procedure(apply_compiled_procedure)
	pop(%d0)			# Get frame length in d0.

define_debugging_label(apply_compiled_procedure_common)
	mov.l	(%sp),%d1		# Get procedure.
	and.l	rmask,%d1
	mov.l	%d1,%a1
	mov.l	(%a1),%d1		# Take car to get entry address.
	and.l	rmask,%d1
	mov.l	%d1,%a0
	jmp	(%a0)			# Apply.

define_debugging_label(return_to_interpreter_error)
	mov.l	_compiled_code_error_code,%d0
	tst.l	%d0
	blt.b	return_to_interpreter
	mov.l	&err_compiled_code_error,%d0
	bra.b	return_to_interpreter

define_debugging_label(compiler_return_to_interpreter)
	movq	&prim_done,%d0

define_debugging_label(return_to_interpreter)
	switch_to_interpreter_registers()
	movm.l	(%sp)+,%d2-%d7/%a0-%a6
	rts

### compiler_error
### compiler_apply
###
### Expects the procedure and arguments to be pushed on the stack, and
### the count to be in D0.W (no type code needed).

define_debugging_label(compiler_error)
	mov.l	_Fixed_Objects,%d1
	and.l	rmask,%d1
	mov.l	%d1,%a0
	push(fobject_compiler_error_procedure(%a0))

### macroize the application code so that other places can call it
### without speed penalty.

define_debugging_label(compiler_apply)
	cmp.b	(%sp),&tc_compiled_procedure
	beq.b	apply_compiled_procedure_common
	push_frame_count(%d0)
	movq	&prim_apply,%d0
	bra.b	return_to_interpreter

define_c_procedure(return_to_compiled_code)
	compiler_invoke_continuation()

### compiler_primitive_apply
###
### Expects the primitive number to be in D6.W.  D6 is expected to be
### preserved by the primitive so we can use it on return; this is
### consistent with this C compiler's calling conventions.
###
### The primitive is also saved in Ext_Expression so that the system can
### back out in case of an error/interrupt during the primitive.

define_debugging_label(compiler_primitive_apply)
	ext.l	%d6			# Assumes that tc_primitive not 0.
	mov.l	%d6,regblock_expr(regs)
	switch_to_interpreter_registers()
	lea	_Primitive_Procedure_Table,%a0	# call
	jsr	([0,%a0,%d6.w*4],0)
	switch_to_compiled_code_registers()
	mov.l	%d0,regblock_val(regs)
	lea	_Primitive_Arity_Table,%a0	# pop primitive arguments.
	mov.l	(0,%a0,%d6.w*4),%d0
	lea	(0,%sp,%d0.w*4),%sp
	compiler_invoke_continuation()

### compiler_lookup_apply
###
### Expects the arguments to be pushed on the stack, the environment
### in D4, the variable in D5, and the frame count in D0.W.

define(compiler_lookup_error,
	`push_return_code(rc_comp_$1_restart)
	mov.l	%d0,_compiled_code_error_code
	bra.w	return_to_interpreter_error')

define_debugging_label(compiler_lookup_apply)
	push_frame_count(%d0)
	push(%d5, %d4)

compiler_lookup_apply_1:
	c_call(Lex_Ref, %d4, %d5)
	cmp.l	%d0,&prim_done
	bne.b	compiler_lookup_apply_error
	pop_discard(2)
	mov.l	(%sp),%d0
	mov.l	regblock_val(regs),(%sp)
	bra.w	compiler_apply

compiler_lookup_apply_error:
	compiler_lookup_error(lookup_apply)

define_c_procedure(comp_lookup_apply_restart)
	mov.l	(%sp),%d4
	mov.l	4(%sp),%d5
	bra.w	compiler_lookup_apply_1

### compiler_reference
### compiler_safe_reference
### compiler_access
### compiler_unassigned_p
### compiler_unbound_p
###
### Expects an environment in A0, and a name in A1.
### Returns the value in D0.

define(define_compiler_reference,
`define_debugging_label(compiler_$1)
	adjust_return_address()
	push(%a1, %a0)

compiler_$1_1:
	c_call($2, %a0, %a1)
	cmp.l	%d0,&prim_done
	bne.b	compiler_$1_error
	pop_discard(2)
	mov.l	regblock_val(regs),%d0
	compiler_invoke_continuation()

compiler_$1_error:
	compiler_lookup_error($1)

define_c_procedure(comp_$1_restart)
	mov.l	(%sp),%a0
	mov.l	4(%sp),%a1
	bra.w	compiler_$1_1')

define_compiler_reference(reference, Lex_Ref)

define_compiler_reference(safe_reference, safe_lex_ref)

define_compiler_reference(access, Symbol_Lex_Ref)

define_compiler_reference(unassigned_p, Symbol_Lex_unassigned_p)

define_compiler_reference(unbound_p, Symbol_Lex_unbound_p)

### compiler_assignment
### compiler_definition
###
### Expects an environment in A0, a name in A1, and a value in A2.
### Returns the old value in D0.

define(define_compiler_assignment,
`define_debugging_label(compiler_$1)
	adjust_return_address()
	push(%a2, %a1, %a0)

compiler_$1_1:
	c_call($2, %a0, %a1, %a2)
	cmp.l	%d0,&prim_done
	bne.b	compiler_$1_error
	pop_discard(3)
	mov.l	regblock_val(regs),%d0
	compiler_invoke_continuation()

compiler_$1_error:
	compiler_lookup_error($1)

define_c_procedure(comp_$1_restart)
	mov.l	(%sp),%a0
	mov.l	4(%sp),%a1
	mov.l	8(%sp),%a2
	bra.w	compiler_$1_1')

define_compiler_assignment(assignment, Lex_Set)

define_compiler_assignment(definition, Local_Set)

### compiler_cache_lookup{_multiple}
### compiler_cache_assignment{_multiple}
### compiler_cache_operator{_multiple}
###
### Expects a compiled-code block address in A0 and the address of a
### constant area offset in A1.  The "_multiple" entry points expect
### D1.W to contain a count indicating how many caches to initialize.

define(define_compiler_variable_init,
`define_debugging_label(comentry_$1)
	movq	&1,%d1

define_debugging_label(comentry_$1_multiple)
	adjust_return_address()
	mov.l	%a1,%d0
	sub.l	%a0,%d0
	lsr.l	&2,%d0
	push_fixnum_word(%d1)
	push_fixnum_long(%d0)
	push_compiled_code_block(%a0)
	dbf	%d1,comentry_$1_retry
	bra.b	comentry_$1_done

comentry_$1_loop:
	mov.l	4(%sp),%d0
	addq.l	&1,%d0
	mov.l	%d0,4(%sp)

comentry_$1_retry:
	and.l	rmask,%d0		# Offset
	mov.w	%d1,10(%sp)
	mov.l	(%sp),%d2
	and.l	rmask,%d2
	mov.l	%d2,%a0
	mov.l	(0,%a0,%d0.l*4),%d2	# Symbol
	mov.l	(%sp),%a0		# Block
	c_call($2, %d2, %a0, %d0)
	cmp.l	%d0,&prim_done
	bne.b	comentry_$1_error
	mov.w	10(%sp),%d1
	dbf	%d1,comentry_$1_loop

comentry_$1_done:
	clr.b	(%sp)			# preserve block argument.
	pop(%a0)			#
	pop_discard(2)
	compiler_invoke_continuation()

comentry_$1_error:
	compiler_lookup_error($1)

define_c_procedure(comp_$1_restart)
	mov.w	10(%sp),%d1
	mov.l	4(%sp),%d0
	bra.w	comentry_$1_retry')

define_compiler_variable_init(cache_lookup, compiler_cache_lookup)
define_compiler_variable_init(cache_assignment, compiler_cache_assignment)
define_compiler_variable_init(cache_operator, compiler_cache_operator)

### compiled_entry_to_block
###
### Expects a Scheme object representing a compiled code entry point in D1.
### Returns the address of the block to which it belongs in A0.

define_debugging_label(compiled_entry_to_block)
	and.l	rmask,%d1
	mov.l	%d1,%a0
	bra.b	enter_compiled_entry_to_block_loop

compiled_entry_to_block_loop:
	lea	1(%a0),%a0

enter_compiled_entry_to_block_loop:
	mov.w	-2(%a0),%d1
	sub.w	%d1,%a0
	lsr.w	&1,%d1
	bcs.b	compiled_entry_to_block_loop
	rts

### compiler_lookup_trap
### compiler_safe_reference_trap
### compiler_unassigned_p_trap
###
### Expects a cached-variable extension object in A0 (this is what is
### left in the constant area slot by compiler_cache_mumble).
### Returns the value of the variable in D0.

define(define_reference_trap,
`define_debugging_label(comentry_$1)
	adjust_return_address()
	push(%a0)
	c_call($2, %a0)
	cmp.l	%d0,&prim_done
	bne.b	comentry_$1_error
	pop_discard(1)
	mov.l	regblock_val(regs),%d0
	compiler_invoke_continuation()

comentry_$1_error:
	mov.l	4(%sp),%d1		# Get return address
	bsr	compiled_entry_to_block
	compiler_reference_trap_error($1)

define_c_procedure(comp_$1_restart)
	mov.l	(%sp),%d0		# name
	mov.l	4(%sp),%d1		# environment
	c_call($3, %d1, %d0)
	cmp.l	%d0,&prim_done
	beq.b	comentry_$1_restart_continue
	mov.l	%d0,_compiled_code_error_code
	push_return_code(rc_comp_$1_restart)
	bra.w	return_to_interpreter_error

comentry_$1_restart_continue:
	pop_discard(2)
	mov.l	regblock_val(regs),%d0
	compiler_invoke_continuation()')

define(compiler_reference_trap_error,
	`mov.l	%d0,_compiled_code_error_code
	mov.l	(%a0),%d0		# Extract environment
	and.l	rmask,%d0
	mov.l	(0,%a0,%d0.l*4),%a0
	mov.l	(%sp),%a1		# Get extension
	mov.l	%a0,(%sp)		# Save environment
	c_call(compiler_var_error, %a1, %a0)
	push(%d0)			# Save name
	push_return_code(rc_comp_$1_restart)
	bra.w	return_to_interpreter_error')

define_reference_trap(lookup_trap, compiler_lookup_trap, Symbol_Lex_Ref)
define_reference_trap(safe_ref_trap, compiler_safe_lookup_trap,
		      safe_symbol_lex_ref)
define_reference_trap(unassigned_p_trap, compiler_unassigned_p_trap,
		      Symbol_Lex_unassigned_p)

### compiler_cache_reference_apply
###
### Expects the arguments on the stack, frame count in D0.W,
### a cached-variable extension object in A3, and the address of the
### compiled-code block in A1.

define_debugging_label(comentry_cache_reference_apply)
	push_compiled_code_block(%a1)
	push_frame_count(%d0)
	push(%a3)

comentry_cache_reference_apply_1:
	c_call(compiler_lookup_trap, %a3)
	cmp.l	%d0,&prim_done
	bne.b	comentry_cache_reference_apply_error
	pop_discard(1)
	pop(%d0)
	mov.l	regblock_val(regs),(%sp)
	bra.w	compiler_apply

comentry_cache_reference_apply_error:
	mov.l	8(%sp),%d1		# Block
	and.l	rmask,%d1
	mov.l	%d1,%a0
	compiler_reference_trap_error(cache_reference_apply)

define_c_procedure(comp_cache_ref_apply_restart)
	mov.l	(%sp),%d0		# name
	mov.l	4(%sp),%d1		# environment
	c_call(Symbol_Lex_Ref, %d1, %d0)
	cmp.l	%d0,&prim_done
	beq.b	comentry_cache_ref_restart_continue
	mov.l	%d0,_compiled_code_error_code
	push_return_code(rc_comp_cache_reference_apply_restart)
	bra.w	return_to_interpreter_error

comentry_cache_ref_restart_continue:
	pop_discard(2)
	pop(%d0)
	mov.l	regblock_val(regs),(%sp)
	bra.w	compiler_apply

### compiler_assignment_trap
###
### Expects a cached-variable extension object in A0, and the assignment
### value in A1.

define_debugging_label(comentry_assignment_trap)
	adjust_return_address()
	push(%a1, %a0)

comentry_assignment_trap_1:
	c_call(compiler_assignment_trap, %a0, %a1)
	cmp.l	%d0,&prim_done
	bne.b	comentry_assignment_trap_error
	pop_discard(2)
	compiler_invoke_continuation()

comentry_assignment_trap_error:
	mov.l	8(%sp),%d1		# Get return address
	bsr	compiled_entry_to_block
	compiler_reference_trap_error(assignment_trap)

define_c_procedure(comp_assignment_trap_restart)
	mov.l	(%sp),%d0		# name
	mov.l	4(%sp),%d1		# environment
	mov.l	8(%sp),%d2		# value
	c_call(Symbol_Lex_Set, %d1, %d0, %d2)
	cmp.l	%d0,&prim_done
	beq.b	comentry_assignment_trap_restart_continue
	mov.l	%d0,_compiled_code_error_code
	push_return_code(rc_comp_assignment_trap_restart)
	bra.w	return_to_interpreter_error

comentry_assignment_trap_restart_continue:
	pop_discard(3)
	compiler_invoke_continuation()

### compiler_operator_reference_trap
###
### Called when a uuo-link references a variable which needs special attention.
### The conditions are the same as for COMPILER_APPLY.

define_debugging_label(comentry_operator_reference_trap)
	push_frame_count(%d0)

comentry_operator_reference_trap_1:
	lea	4(%sp),%a0		# Stack slot
	mov.l	(%a0),%d0
	and.l	rmask,%d0
	mov.l	%d0,%a1
	mov.l	4(%a1),%d0		# Extension
	c_call(complr_operator_reference_trap, %a0, %d0)
	cmp.l	%d0,&prim_done
	bne.b	comentry_operator_reference_trap_error
	pop(%d0)
	bra.w	compiler_apply

comentry_operator_reference_trap_error:
	compiler_lookup_error(op_ref_trap)

define_c_procedure(comp_op_ref_trap_restart)
	bra.w	comentry_operator_reference_trap_1

### compiler_operator_trap
###
### Called when a uuo-link has been established to a value which is not
### a compiled procedure.  The call must be performed by apply.
### The conditions are the same as for COMPILER_APPLY.

define_debugging_label(comentry_operator_trap)
	mov.l	(%sp),%d1			# uuo link
	and.l	rmask,%d1
	mov.l	%d1,%a0
	mov.l	4(%a0),(%sp)			# real operator
	push_frame_count(%d0)
	movq	&prim_apply,%d0
	bra.w	return_to_interpreter

### extract_uuo_link
###
### Get a compiled procedure from a cached operator reference.

define_simple_c_procedure(extract_uuo_link)
	mov.l	4(%sp),%d0			# block
	and.l	&0xffffff,%d0
	mov.l	%d0,%a0
	mov.l	8(%sp),%d0			# offset
	mov.l	(0,%a0,%d0.l*4),%d0		# uuo link
	rts

### make_uuo_link
###
### Check its argument, and if it is a compiled procedure, store it in the
### destination.  Otherwise store a fake compiled procedure which will use
### apply when invoked.

define_simple_c_procedure(make_uuo_link)
	cmp.b	4(%sp),&tc_compiled_procedure	# operator
	bne.b	make_uuo_link_1
	mov.l	12(%sp),%d0			# block
	and.l	&0xffffff,%d0
	mov.l	%d0,%a0
	mov.l	16(%sp),%d0			# offset
	mov.l	4(%sp),(0,%a0,%d0.l*4)		# Store!
	movq	&prim_done,%d0
	rts

make_uuo_link_1:
	mov.l	_uuo_link_trap,%d0		# entry
	lea	12(%sp),%a1			# args
	bra.w	make_fake_uuo_link_common

### make_fake_uuo_link
###
### Makes a fake compiled procedure which calls uuo_link_trap when invoked.

define_simple_c_procedure(make_fake_uuo_link)
	mov.l	_fake_uuo_link_trap,%d0		# entry
	lea	8(%sp),%a1			# args

make_fake_uuo_link_common:
	mov.l	_Free,%a0
	cmp.l	%a0,_MemTop
	bge.b	make_fake_uuo_link_2

make_fake_uuo_link_1:
	pea	(%a0)
	mov.b	&tc_compiled_procedure,(%sp)
	mov.l	%d0,(%a0)+			# entry
	mov.l	8(%sp),(%a0)+			# env
	mov.l	%a0,_Free
	mov.l	(%a1)+,%d0			# block
	and.l	&0xffffff,%d0
	mov.l	%d0,%a0
	mov.l	(%a1),%d0			# offset
	mov.l	(%sp)+,(0,%a0,%d0.l*4)		# Store!
	movq	&prim_done,%d0
	rts

make_fake_uuo_link_2:
	bset	&int_gc_bit,_IntCode+3	# Set the GC interrupt bit.
	btst	&int_gc_bit,_IntEnb+3	# If GC not enabled, ignore it.
	bne.b	make_fake_uuo_link_1
	movq	&prim_interrupt,%d0
	rts

### compiled_block_environment
###
### Given a compiled code block, it extracts the environment where
### the block was "loaded".

define_simple_c_procedure(compiled_block_environment)
	mov.l	4(%sp),%d0
	and.l	&0xffffff,%d0
	mov.l	%d0,%a0
	mov.l	(%a0),%d0
	and.l	&0xffffff,%d0
	mov.l	(0,%a0,%d0.l*4),%d0
	rts

### extract_variable_cache
###
### Given a compiled code block, and an offset, it extracts the
### variable cache at that location.

define_simple_c_procedure(extract_variable_cache)
	mov.l	4(%sp),%d0		# block
	and.l	&0xffffff,%d0
	mov.l	%d0,%a0
	mov.l	8(%sp),%d0		# offset
	mov.l	(0,%a0,%d0.l*4),%d0
	rts

### store_variable_cache
###
### Given a variable cache, a compiled code block, and an offset,
### it stores the variable cache at that location.

define_simple_c_procedure(store_variable_cache)
	mov.l	8(%sp),%d0		# block
	and.l	&0xffffff,%d0
	mov.l	%d0,%a0
	mov.l	12(%sp),%d0		# offset
	mov.l	4(%sp),(0,%a0,%d0.l*4)	# Store!
	rts

### compiler_enclose
###
### inputs:	size of vector in D0.W
### outputs:	vector in A0
### used:	A0, A1, D0
###
### **** This probably doesn't work anymore.  No one uses it. ****
###
### Optimized for size of the calling sequence rather than speed.  It
### is assumed that this is inline coded when speed is required.
### Warning!  This does not check for GC overflow.

define_debugging_label(compiler_enclose)
	mov.l	rfree,%a0		# Allocate space.
	lea	(4,rfree,%d0.w*4),rfree
	mov.l	%a0,regblock_temp(regs)	# Save result.
	mov.b	&tc_vector,regblock_temp(regs)
	mov.w	&tc_manifest_vector*0x10000,(%a0)+ # Write vector header.
	mov.w	%d0,(%a0)+
	pop(%a1)			# Get return address off stack.
	bra.b	compiler_enclose_loop_entry

compiler_enclose_loop:
	pop((%a0)+)
compiler_enclose_loop_entry:
	dbf	%d0,compiler_enclose_loop

	mov.l	regblock_temp(regs),%a0
	jmp	(%a1)

### compiler_wrong_number_of_arguments
###
### Expects to be used just after entering a compiled closure, so the
### conditions should be the same as for COMPILER_APPLY.

define_debugging_label(compiler_wrong_number_of_arguments)
	push_frame_count(%d0)
	mov.l	&err_wrong_number_of_arguments,%d0
	bra.w	return_to_interpreter

### compiler_interrupt_procedure
### compiler_interrupt_continuation
###
### We are expecting the compiler to generate the following code at
### a procedure or continuation entry point:
###
###	label1:
###		jsr	regblock_compiler_interrupt_procedure(regs)
###		dc.w	<offset to block start for gc of tc_return_address>
###	entry_label:
###		cmp.l	rfree,regblock_memtop(regs)
###		bge.b	label1

define_debugging_label(compiler_interrupt_procedure)
	adjust_return_address()
	push(&false_object)		# Dummy value.

compiler_interrupt_common:
	tst.b	regblock_memtop(regs)	# Interrupt or GC?
	bmi.b	compiler_interrupt
	bset	&int_gc_bit,_IntCode+3	# Set the GC interrupt bit.
	btst	&int_gc_bit,_IntEnb+3	# If GC not enabled, ignore it.
	bne.b	compiler_interrupt_common_1
	pop_discard(1)
	clr.b	(%sp)			# Resume, skipping past entry test.
	pop(%a0)
	jmp	4(%a0)

compiler_interrupt_common_1:
	mov.l	&-1,regblock_memtop(regs) # Set interrupt mark in register.

define_debugging_label(compiler_interrupt)
	push_return_code(rc_comp_interrupt_restart)
	movq	&prim_interrupt,%d0
	bra.w	return_to_interpreter

define_debugging_label(compiler_interrupt_continuation)
	adjust_return_address()
	push(regblock_val(regs))	# Save VAL.
	bra.b	compiler_interrupt_common

define_c_procedure(comp_interrupt_restart)
	pop(regblock_val(regs))		# Restore VAL.
	compiler_invoke_continuation()

### compiler_setup_lexpr
###
### inputs:	number of supplied arguments in D0.W
###		number of required+optional arguments in D1.W
###		rest argument (1 = yes, 0 = no) in D2.W
###
### Adjusts the stack frame by the appropriate amount; also performs a
### GC check.  Expects to be called with the following sequence so
### that it can compute the GC address to push if needed:
###
###		mov.w	&n,%d1
###		movq	&r,%d2
###		jsr	<compiler_setup_lexpr offset>(regs)

define_debugging_label(compiler_setup_lexpr)
	mov.w	%d1,%d3			# Compute number of missing optionals.
	sub.w	%d0,%d3
	blt.b	setup_lexpr_5

### Simple case.  Shift the frame up enough to make room for the
### missing optionals and the rest variable, then clobber them with
### appropriate values.  Since this case does no consing, we do an
### explicit GC check here.

	cmp.l	rfree,regblock_memtop(regs)
	blt.b	setup_lexpr_10
	bsr.b	setup_lexpr_interrupt
setup_lexpr_10:

	mov.l	%sp,%a0			# Source pointer for loop.
	mov.w	%d3,%d1			# Allocate extra space on stack.
	neg.w	%d1
	sub.w	%d2,%d1
	lea	(0,%sp,%d1.w*4),%sp
	mov.l	%sp,%a1			# Target pointer for loop.

### Because of the return address, we must loop d0+1 times.

setup_lexpr_1:
	mov.l	(%a0)+,(%a1)+
	dbf	%d0,setup_lexpr_1

	bra.b	setup_lexpr_3

setup_lexpr_2:
	mov.l	&make_object(tc_reference_trap, 0),(%a1)+
setup_lexpr_3:
	dbf	%d3,setup_lexpr_2

	tst.w	%d2			# Write the rest argument if any.
	beq.b	setup_lexpr_4
	mov.l	&null_object,(%a1)
setup_lexpr_4:
	rts

### In all subsequent cases, it is assumed that D2.W = 1, since the
### number of supplied arguments exceeds the number of fixed ones.
### This is because we assume that the procedure has been passed a
### legal number of arguments.

setup_lexpr_5:
	cmp.w	%d3,&-1
	bne.b	setup_lexpr_6

### Another easy case: just one extra argument needs to be made into a
### list, no stack frame shifting is required.

	cmp.l	rfree,regblock_memtop(regs)
	blt.b	setup_lexpr_11
	bsr.b	setup_lexpr_interrupt
setup_lexpr_11:

	lea	(0,%sp,%d0.w*4),%a0	# Get the argument.
	mov.l	(%a0),%d3
	mov.l	rfree,(%a0)		# Cons it into a list.
	mov.b	&tc_list,(%a0)
	mov.l	%d3,(rfree)+
	mov.l	&null_object,(rfree)+
	rts

### The tough case.  We must cons a list, then shift the stack frame
### down over the (now listified) extra arguments.

setup_lexpr_6:
	lea	(4,%sp,%d1.w*4),%a0	# Compute pointer to rest arguments.
	mov.l	%a0,%a2			# Save it for shift-down.
	neg.w	%d3			# Get length of list.
	mov.l	%d3,%d4			# Save for compiler_list_unconditional

	bsr.w	compiler_list		# Cons the list.
	tst.w	%d3
	bne.b	setup_lexpr_12
	bsr.b	setup_lexpr_interrupt
	mov.l   %d4,%d3
	bsr.w	compiler_list_unconditional	# Cons the list.

setup_lexpr_12:

	mov.l	%a1,-(%a0)		# Save the rest argument in place.

setup_lexpr_7:
	mov.l	-(%a2),-(%a0)		# Shift the stack frame down.
	dbf	%d1,setup_lexpr_7

	mov.l	%a0,%sp
	rts

define_debugging_label(setup_lexpr_interrupt)
	tst.b	regblock_memtop(regs)	# Interrupt or GC?
	bmi.b	compiler_lexpr_interrupt
	bset	&int_gc_bit,_IntCode+3	# Set the GC interrupt bit.
	btst	&int_gc_bit,_IntEnb+3	# If GC not enabled, ignore it.
	bne.b	compiler_lexpr_interrupt
	rts

define_debugging_label(compiler_lexpr_interrupt)
	pop_discard(1)			# Don't need to continue caller.
	sub.l	&10,(%sp)		# Create GC-able return address.
	mov.b	&tc_return_address,(%sp)
	push_fixnum_word(%d0)		# Save arguments.
	push_fixnum_word(%d1)
	push_fixnum_word(%d2)
	push_return_code(rc_comp_lexpr_interrupt_restart)
	mov.l	&prim_interrupt,%d0
	bra.w	return_to_interpreter

define_c_procedure(comp_lexpr_interrupt_restart)
	pop(%d2)			# Restore arguments.
	pop(%d1)
	pop(%d0)
	clr.b	(%sp)			# Restore return address.
	add.l	&10,(%sp)
	bra.w	compiler_setup_lexpr

### compiler_list
###
### inputs:	pointer to block of objects in A0
###		number of objects in block in D3.W
### outputs:	pointer past block of objects in A0
###		pointer to list in A1
###		GC needed in D3.W (0 = true)

### Assumes that D3 is at least 1.

compiler_list:
	movm.l	%d1/%a2,-(%sp)
	lea	(0,rfree,%d3.w*8),%a2	# Allocate the free space needed.
	cmp.l	%a2,regblock_memtop(regs)
	blt.b	compiler_list_1
	clr.w	%d3
	movm.l	(%sp)+,%d1/%a2
	rts

### Create list regardless of whether Free has collided with MemTop

compiler_list_unconditional:
	movm.l	%d1/%a2,-(%sp)
	lea	(0,%a5,%d3.w*8),%a2	# Allocate the free space needed.

### Clever loop to create list.  Create a pointer to the head of the
### list which has pair type code.  Bump this in the loop to write the
### cdr of each of the pairs in the list.  The loop counter is
### decremented by two, causing the main loop to stop just before the
### last pair, which is handled specially.

compiler_list_1:
	exg	%a2,rfree
	mov.l	%a2,%d1			# Create a pointer to the first pair.
	or.l	&make_object(tc_list, 0),%d1
	mov.l	%d1,%a1			# Save this as the return value.

	subq.w	&1,%d3			# Adjust to stop loop before last arg.
	bra.b	compiler_list_3

compiler_list_2:
	mov.l	(%a0)+,(%a2)+		# Copy argument to car of pair.
	addq.l	&8,%d1			# Adjust pointer to next pair.
	mov.l	%d1,(%a2)+		# Put it in this pair's cdr.
compiler_list_3:
	dbf	%d3,compiler_list_2

	mov.l	(%a0)+,(%a2)+		# Copy last argument to last pair.
	mov.l	&null_object,(%a2)	# Put '() in last pair's cdr.
	movm.l	(%sp)+,%d1/%a2
	rts

#### Special coded arithmetic
###
### Arguments on the stack.  Compiler return address above.
###

define(define_unary_generic,
	`define_debugging_label(comentry_$1)
	cmp.b	(%sp),&tc_fixnum
	bne.b	$1_generic
	$2
	pop_discard(1)
	compiler_invoke_continuation()
$1_generic:
	mov.w	&pc_$1,%d6
	bra	compiler_primitive_apply')

define(generic_fixnum_result,
	`bvs.b	$1_generic
	lsr.l	&8,%d0
	mov.l	%d0,regblock_val(regs)
	mov.b	&tc_fixnum,regblock_val(regs)')

unary_return_true:
	mov.l	&true_object,regblock_val(regs)
	pop_discard(1)
	compiler_invoke_continuation()	

define(define_unary_generic_predicate,
	`define_unary_generic($1,
	`mov.l	(%sp),%d0
	lsl.l	&8,%d0
	b$2	unary_return_true
	mov.l	&false_object,regblock_val(regs)')')
	
define_unary_generic_predicate(zero, eq)
define_unary_generic_predicate(positive, gt)
define_unary_generic_predicate(negative, lt)

define(define_unary_generic_operator,
	`define_unary_generic($1,
	`mov.l	(%sp),%d0
	lsl.l	&8,%d0
	$2.l	&256,%d0
	generic_fixnum_result($1)')')

define_unary_generic_operator(increment, add)
define_unary_generic_operator(decrement, sub)

#### Binary procedures

define(define_binary_generic,
	`define_debugging_label(comentry_$1)
	cmp.b	(%sp),&tc_fixnum
	bne.b	$1_generic
	cmp.b	4(%sp),&tc_fixnum
	bne.b	$1_generic
	$2
	pop_discard(2)
	compiler_invoke_continuation()
$1_generic:
	mov.w	&pc_$1,%d6
	bra	compiler_primitive_apply')

binary_return_true:
	mov.l	&true_object,regblock_val(regs)
	pop_discard(2)
	compiler_invoke_continuation()	

define(define_binary_generic_predicate,
	`define_binary_generic($1,
	`mov.l	(%sp),%d0
	lsl.l	&8,%d0
	mov.l	4(%sp),%d1
	lsl.l	&8,%d1
	cmp.l	%d0,%d1
	b$2	binary_return_true
	mov.l	&false_object,regblock_val(regs)')')

define_binary_generic_predicate(equal, eq)
define_binary_generic_predicate(less, lt)
define_binary_generic_predicate(greater, gt)

define(define_binary_generic_operator,
	`define_binary_generic($1,
	`mov.l	(%sp),%d0
	lsl.l	&8,%d0
	mov.l	4(%sp),%d1
	lsl.l	&8,%d1
	$2.l	%d1,%d0
	generic_fixnum_result($1)')')

define_binary_generic_operator(plus, add)
define_binary_generic_operator(minus, sub)

define_binary_generic(multiply,
	`mov.l	(%sp),%d0
	lsl.l	&8,%d0
	mov.l	4(%sp),%d1
	lsl.l	&8,%d1
	asr.l	&8,%d1
	muls.l	%d1,%d0
	generic_fixnum_result(multiply)')

# This one is not optimized yet.

define_debugging_label(comentry_divide)
	mov.w	&pc_divide,%d6
	bra	compiler_primitive_apply

#### Popper Entries

### Here are the three message receivers which are pushed on the stack
### by compiled code:

###	closure:
###		short	0x0000			# Type = closure receiver
###		short	<frame-size>		# Stack frame size
###		space	<frame-size>		# Stack frame
###		long	???			# Return address

###	stack:
###		short	0x0010			# Type = stack receiver
###		short	<frame-size>		# Stack frame size
###		space	<frame-size>		# Stack frame

###	subproblem:
###		short	0x0020			# Type = subproblem receiver
###		short	0x0000			# Stack frame size (always 0)
###		long	???			# Return address

### Here is the code for each of the message senders.  In each case,
### `frame_size' is the size of the stack frame about to be applied
### (in longwords), and `receiver_offset' is the distance to the first
### receiver (in bytes).

###	apply_closure:
###		mov.w	&frame_size,%d1
###		lea	receiver_offset(%sp),%a0
###		lea	<application>,%a1
###		jmp	apply_closure_offset(regs)

###	apply_stack:
###		movq	&n_levels,%d0
###		mov.w	&frame_size,%d1
###		lea	receiver_offset(%sp),%a0
###		lea	<application>,%a1
###		jmp	apply_stack_offset(regs)

###	value:
###		lea	receiver_offset(%sp),%sp
###		jmp	value_offset(regs)

message_block_start:

### Numbers in brackets are the sizes of the corresponding
### instructions in bytes.  If the entries exceed 16 bytes, then the
### compiler must be changed to have the new offsets into the array.

### If the total size of the message block exceeds 192 bytes, update
### the value of `regblock_length' accordingly.

define(message_dispatch,
	`mov.w	($1),%d2
	jmp	((($2 + 14) - .),%pc,%d2.w)')

define(increment_frame_pointer,
	`addq.l	&2,$1
	add.w	($1)+,$1')

define(copy_invoke,
	`lea	(0,%sp,%d1.w*4),%a2
	bra.b	copy_invoke_loop_entry')

### ------------------------------------------------------------------

message_apply_closure:
	message_dispatch(%a0,message_apply_closure) # [6]
	space	10			# Pad to 16 bytes.

### closure:
	increment_frame_pointer(%a0)	# [4] Pointer to frame start.
	copy_invoke()			# [6]
	space	6			# Pad to 16 bytes.

### stack:
	increment_frame_pointer(%a0)	# [4] Move to next receiver.
	message_dispatch(%a0,message_apply_closure) # [6]
	space	6			# Pad to 16 bytes.

### subproblem:
	addq.l	&4,%a0			# [2] Discard message receiver.
	copy_invoke()			# [6]
	space	8			# Pad to 16 bytes.

message_apply_stack:
	message_dispatch(%a0,message_apply_stack) # [6]

copy_invoke_loop:
	mov.l	-(%a2),-(%a0)		# [2] Copy the frame down.
copy_invoke_loop_entry:
	dbf	%d1,copy_invoke_loop	# [4]

	mov.l	%a0,%sp			# [2]
	jmp	(%a1)			# [2] Perform invocation.

### closure:
	copy_invoke()			# [6]

message_apply_stack_continue:
	increment_frame_pointer(%a0)	# [4] Move to next receiver.
	message_dispatch(%a0,message_apply_stack) # [6]

### stack:
	dbf	%d0,message_apply_stack_continue # [4]
	copy_invoke()			# [6]
	space	6			# Pad to 16 bytes.

### subproblem:
	copy_invoke()			# [6]
	space	10			# Pad to 16 bytes.

### ------------------------------------------------------------------

message_value:
	message_dispatch(%sp,message_value) # [6]
	space	10			# Pad to 16 bytes.

### closure:
	increment_frame_pointer(%sp)	# [4] Move to return address.
	compiler_invoke_continuation()	# [4] Return to caller.
	space	8			# Pad to 16 bytes.

### stack:
	increment_frame_pointer(%sp)	# [4] Move to next receiver.
	message_dispatch(%sp,message_value) # [6]
	space	6			# Pad to 16 bytes.

### subproblem:
	increment_frame_pointer(%sp)	# [4] Move to return address.
	compiler_invoke_continuation()	# [4] Return to caller.
	space	8			# Pad to 16 bytes.

### compiler_initialize

define(setup_register,
	`mov.w	&0x4ef9,(%a0)+
	mov.l	&$1,(%a0)+')

define_simple_c_procedure(compiler_initialize)
	lea	_Registers,%a0		# first 20 entry points
	lea	regblock_entries(%a0),%a0
	setup_register(compiler_apply)				#  0
	setup_register(compiler_error)				#  1
	setup_register(compiler_wrong_number_of_arguments)	#  2
	setup_register(compiler_interrupt_procedure)		#  3
	setup_register(compiler_interrupt_continuation)		#  4
	setup_register(compiler_lookup_apply)			#  5
	setup_register(compiler_reference)			#  6
	setup_register(compiler_access)				#  7
	setup_register(compiler_unassigned_p)			#  8
	setup_register(compiler_unbound_p)			#  9
	setup_register(compiler_assignment)			# 10
	setup_register(compiler_definition)			# 11
	setup_register(compiler_primitive_apply)		# 12
	setup_register(compiler_enclose)			# 13
	setup_register(compiler_setup_lexpr)			# 14
###
### The definition of `offset_return_to_interpreter' depends on this.
###
	setup_register(compiler_return_to_interpreter)		# 15
###
	setup_register(compiler_safe_reference)			# 16
	setup_register(comentry_cache_lookup)			# 17
	setup_register(comentry_lookup_trap)			# 18
	setup_register(comentry_assignment_trap)		# 19

	lea	_Registers,%a0		# second 20 entry points
	lea	regblock_entries_2(%a0),%a0
	setup_register(comentry_cache_operator)			# 20
###
### The definition of `offset_fake_uuo_link_trap' depends on this.
###
	setup_register(comentry_operator_reference_trap)	# 21
	setup_register(comentry_cache_reference_apply)		# 22
	setup_register(comentry_safe_ref_trap)			# 23
	setup_register(comentry_unassigned_p_trap)		# 24
	setup_register(comentry_cache_lookup_multiple)		# 25
	setup_register(comentry_cache_operator_multiple)	# 26
	setup_register(comentry_plus)				# 27
	setup_register(comentry_minus)				# 28
	setup_register(comentry_multiply)			# 29
	setup_register(comentry_divide)				# 30
	setup_register(comentry_equal)				# 31
	setup_register(comentry_less)				# 32
	setup_register(comentry_greater)			# 33
	setup_register(comentry_increment)			# 34
	setup_register(comentry_decrement)			# 35
	setup_register(comentry_zero)				# 36
	setup_register(comentry_positive)			# 37
	setup_register(comentry_negative)			# 38
	setup_register(comentry_cache_assignment) 		# 39
	setup_register(comentry_cache_assignment_multiple)	# 40
###
### The definition of `offset_uuo_link_trap' depends on this.
###
	setup_register(comentry_operator_trap)			# 41

### Initialize message block.

	lea	_Registers,%a0
	lea	regblock_messages(%a0),%a0
	lea	message_block_start,%a1
	movq	&47,%d0

copy_message_loop:
	mov.l	(%a1)+,(%a0)+
	dbf	%d0,copy_message_loop

	tst.l	4(%sp)				# FASL_It
	bne.b	init_constant_space
	rts

### Create a compiled code block with special entry points.

init_constant_space:
	lea	constant_end,%a0
	mov.l	%a0,%d0
	lea	constant_start,%a0
	sub.l	%a0,%d0
	lsr.l	&2,%d0
	mov.l	%d0,-(%sp)
	c_call_c(copy_to_constant_space, %a0, %d0)
	mov.l	%d0,%a0
	mov.l	(%sp)+,%d0

	subq.l	&1,%d0				# init vector header
	mov.l	%d0,(%a0)
	mov.b	&tc_manifest_vector,(%a0)
	subq.l	&1,%d0				# init NM vector header
	mov.l	%d0,4(%a0)
	mov.b	&tc_manifest_nm_vector,4(%a0)

compiler_reset:
	mov.l	%a0,-(%sp)
	mov.b	&tc_compiled_code_block,(%sp)
	mov.l	(%sp),_compiler_utilities

	mov.b	&tc_return_address,(%sp)
	mov.l	(%sp)+,%d0

	mov.l	%d0,%d1
	add.l	&constant_return_to_interpreter-constant_start,%d1
	mov.l	%d1,_return_to_interpreter

	mov.l	%d0,%d1
	add.l	&constant_uuo_link_trap-constant_start,%d1
	mov.l	%d1,_uuo_link_trap

	add.l	&constant_fake_uuo_link_trap-constant_start,%d0
	mov.l	%d0,_fake_uuo_link_trap
	rts

### The following is called after a disk-restore.
###
### The only consistency check performed is that the blocks
### have the same length.

define_simple_c_procedure(compiler_reset)
	cmp.b	4(%sp),&tc_compiled_code_block
	bne.w	compiler_reset_error

	mov.l	4(%sp),%d0
	and.l	&0xffffff,%d0
	mov.l	%d0,%a0
	mov.l	(%a0),%d1
	and.l	&0xffffff,%d1
	lea	constant_end,%a1
	mov.l	%a1,%d0
	lea	constant_start,%a1
	sub.l	%a1,%d0
	lsr.l	&2,%d0
	subq.l	&1,%d0
	cmp.l	%d0,%d1
	bne.w	compiler_reset_error
	subq.l	&1,%d0
	bra.w	compiler_reset	

compiler_reset_error:
	c_call_c(compiler_reset_error)
	rts

### The following block is copied to constant space, and the
### interpreter variable return_to_interpreter is made to point
### to the entry point.

	lalign	4
constant_start:
	long	0				# Vector header
	long	0				# NM header
###
	short	constant_return_to_interpreter-constant_start
constant_return_to_interpreter:
	jmp	offset_return_to_interpreter(regs)
###
	short	constant_fake_uuo_link_trap-constant_start
constant_fake_uuo_link_trap:
	jmp	offset_fake_uuo_link_trap(regs)
###
	short	constant_uuo_link_trap-constant_start
constant_uuo_link_trap:
	jmp	offset_uuo_link_trap(regs)
###
	lalign	4
constant_end:
	long	0
