;;; -*- Mode: Scheme; Syntax: Scheme; Package: (SCHEME :USE (PSEUDOSCHEME)) -*-

;;;
;;;	$Header$
;;;
;;;	Copyright (c) 1986, 1987 Massachusetts Institute of Technology
;;;     Initial implementation due to Ken Haase (KWH@AI.AI.MIT.EDU)
;;;
;;;	This material was developed by the Scheme project at the
;;;	Massachusetts Institute of Technology, Department of
;;;	Electrical Engineering and Computer Science.  Permission to
;;;	copy this software, to redistribute it, and to use it for any
;;;	purpose is granted, subject to the following restrictions and
;;;	understandings.
;;;
;;;	1. Any copy made of this software must include this copyright
;;;	notice in full.
;;;
;;;	2. Users of this software agree to make their best efforts (a)
;;;	to return to the MIT Scheme project any improvements or
;;;	extensions that they make, so that these may be included in
;;;	future releases; and (b) to inform MIT of noteworthy uses of
;;;	this software.
;;;
;;;	3. All materials developed as a consequence of the use of this
;;;	software shall duly acknowledge such use, in accordance with
;;;	the usual standards of acknowledging credit in academic
;;;	research.
;;;
;;;	4. MIT has made no warrantee or representation that the
;;;	operation of this software will be error-free, and MIT is
;;;	under no obligation to provide any services, by way of
;;;	maintenance, update, or otherwise.
;;;
;;;	5. In conjunction with products arising from the use of this
;;;	material, there shall be no use of the name of the
;;;	Massachusetts Institute of Technology nor of any adaptation
;;;	thereof in any advertising, promotional, or sales literature
;;;	without prior written consent from MIT in each case.
;;;

(declare (usual-integrations))
(declare (integrate-external "/u/kwh/programs/utility/plus")
	 (integrate-external "/u/kwh/programs/utility/mutable")
	 (integrate-external "/u/kwh/programs/utility/tuple")
	 (integrate-external "/u/kwh/programs/typical/kernel"))

;;; This files contains commands for EF, a structure inspector based
;;; on TYPICAL.


;;;; Commands for all objects.

(define (ef-one of-list)
  (define (line obj) (newline) (printout-printer obj))
  (ef (choose-one of-list line)))
(define (ef-is-a x)
  (define (line obj) (newline) (printout-printer obj))
  (ef (choose-one (is-a x) line)))

(defcommand-for-type! 'DESCRIBE lattice-top "Describe (using DF)"
  (procedure->command df 'value))
(defcommand-for-type! 'DF lattice-top "Describe (using DF)"
  (procedure->command df 'value))
(defcommand-for-type! 'PP lisp-objects "Pretty Print"
  (procedure->command pp 'value))
(defcommand-for-type! 'INDEX lattice-top "Call the indexer"
  (procedure->command index 'value))
(defcommand-for-type! 'ELEMENT lattice-top "Edit (using EF) one element of a list"
  (procedure->command ef-one 'value))
(defcommand-for-type! 'ELT lattice-top "Edit (using EF) one element of a list"
  (procedure->command ef-one 'value))
(defcommand-for-type! 'IS-A lattice-top "Edit one of the fringe types."
  (procedure->command ef-is-a 'value))
(defcommand-for-type! 'ISA lattice-top "Edit one of the fringe types."
  (procedure->command ef-is-a 'value))

(defcommand-for-type! 'DESCRIBE-PROPERTY lattice-top "Describe (using DF)"
  (procedure->command df 'property))


;;;; Commands for types.

(define (ef-generalization object)
  (define (line obj) (newline) (printout-printer obj))
  (ef (choose-one (genzns object) line)))
(define (ef-specialization object)
  (define (line obj) (newline) (printout-printer obj))
  (ef (choose-one (speczns object) line)))
(define (ef-daemon type)
  (define (print-daemon daemon) (printout $NL ($daemon daemon)))
  (ef (choose-one (daemons-for-type type) print-daemon)))

(defcommand-for-type! 'UP types "Ascend up the lattice"
  (procedure->command ef-generalization 'object))
(defcommand-for-type! 'DOWN types "Descend the lattice"
  (procedure->command ef-specialization 'object))
(defcommand-for-type! 'DAEMON types "Edit an attached daemon"
  (procedure->command ef-daemon 'object))
(defcommand-for-type! 'DAEMONS types "Edit an attached daemon"
  (procedure->command ef-daemon 'object))


;;;; Commands for tasks.

(defcommand-for-type! 'ADVANCE-TASK tasks "Execute a cycle of this task"
  (procedure->command noisy-advance-task 'TASK))
