;;; -*- Mode: Scheme; Syntax: Scheme; Package: (SCHEME :USE (PSEUDOSCHEME)) -*-

;;;
;;;	$Header$
;;;
;;;	Copyright (c) 1986, 1987 Massachusetts Institute of Technology
;;;     Initial implementation due to Ken Haase (KWH@AI.AI.MIT.EDU)
;;;
;;;	This material was developed by the Scheme project at the
;;;	Massachusetts Institute of Technology, Department of
;;;	Electrical Engineering and Computer Science.  Permission to
;;;	copy this software, to redistribute it, and to use it for any
;;;	purpose is granted, subject to the following restrictions and
;;;	understandings.
;;;
;;;	1. Any copy made of this software must include this copyright
;;;	notice in full.
;;;
;;;	2. Users of this software agree to make their best efforts (a)
;;;	to return to the MIT Scheme project any improvements or
;;;	extensions that they make, so that these may be included in
;;;	future releases; and (b) to inform MIT of noteworthy uses of
;;;	this software.
;;;
;;;	3. All materials developed as a consequence of the use of this
;;;	software shall duly acknowledge such use, in accordance with
;;;	the usual standards of acknowledging credit in academic
;;;	research.
;;;
;;;	4. MIT has made no warrantee or representation that the
;;;	operation of this software will be error-free, and MIT is
;;;	under no obligation to provide any services, by way of
;;;	maintenance, update, or otherwise.
;;;
;;;	5. In conjunction with products arising from the use of this
;;;	material, there shall be no use of the name of the
;;;	Massachusetts Institute of Technology nor of any adaptation
;;;	thereof in any advertising, promotional, or sales literature
;;;	without prior written consent from MIT in each case.
;;;

(declare (usual-integrations))
(declare (integrate-external "/u/kwh/programs/utility/plus")
	 (integrate-external "/u/kwh/programs/utility/mutable")
	 (integrate-external "/u/kwh/programs/utility/tuple")
	 (integrate-external "/u/kwh/programs/typical/kernel"))


;;; Printing simple properties (which are just functions).

(define property-printer (make-mutable))

(define (simple-printer value) (printout value))
(define (set-property-printer! property printer)
  ((modifier property-printer) property printer))
(define (set-property-name! property name)
  ((modifier property-printer) property
   (lambda (v) (printout $NL name ":  " v))))
(define (set-property-name+format! property name format)
  ((modifier property-printer) property
   (lambda (v) (printout $NL name ":  " (format v)))))

(define (describe-property thing property)
  (if (defined? (property-printer property))
      ((property-printer property) (property thing))
      (printout $NL ($procedure property) ":  " (property thing))))
(define (maybe-describe-property thing property)
  (if (defined? (property thing))
      (if (defined? (property-printer property))
	  ((property-printer property) (property thing))
	  (printout $NL ($procedure property) ":  " (property thing)))))

(define (describe-properties thing properties)
  (if (not (null? properties))
      (sequence (describe-property thing (first properties))
		(describe-properties thing (rest properties)))))
(define (maybe-describe-properties thing properties)
  (if (not (null? properties))
      (sequence (maybe-describe-property thing (first properties))
		(maybe-describe-properties thing (rest properties)))))

(define ($list-field name elements . format)
  (define (field-entry-format1 entry) (list $NL "     " entry))
  (define (field-entry-format2 entry) (list $NL "     " ((car format) entry)))
  ($nested $NL name "::  "
	   (if (null? elements) "None"
	       (if (null? (rest elements)) (first elements)
		   ($for-each (if (null? format) field-entry-format1 field-entry-format2)
			      elements)))))

(define (list-field-printer name format)
  (define (item-format item) ($nested $NL "     " (format item)))
  (define (print-list-field v)
    (printout $NL name "::  "
	      (if (null? v) "None"
		  (if (null? (cdr v)) (format (car v))
		      ($printout (map item-format v))))))
  print-list-field)


;;;; Figuring out the properties for an object.

;;; Objects are described based on class-wide properties and unique properties
;;;  for the object.  Properties are just functions.

(define unique-properties (make-mutable))
(define set-unique-properties! (modifier unique-properties))
(define (add-unique-property! x property)
  ((mutator unique-properties) x
   (lambda (v) (if (undefined? v) (list property)
		   (if (memq property v) v (cons property v))))))
(define (delete-unique-property! x property)
  ((mutator unique-properties) x
   (lambda (v) (if (undefined? v) v (or (delete property v) (%undefined))))))

(define (type-properties type)
  ((td-properties type) ':properties))
(begin ((modifier mutator) type-properties
	(lambda (v f) ((mutator (td-properties v)) ':properties f))))

(define (set-type-properties! type properties)
  ((modifier type-properties) type properties))
(define (add-type-property! property type)
  ((mutator type-properties) type
   (lambda (v) (if (undefined? v) (list property)
		   (if (memq property v) v (cons property v))))))
(define (delete-type-property! property type)
  ((mutator type-properties) type
   (lambda (v) (if (undefined? v) v (or (delete property v) (%undefined))))))

(define (add-property! property type name)
  (add-type-property! property type)
  (set-property-name! property name))


;;;; Describing objects.

(define show-complements-in-df #F)

(define (description-template object)
  (let ((fringe ()) (properties ()))
    (define (check-type type)
      (let ((relevant-properties (type-properties type)))
	(if (defined? relevant-properties)
	    (set! properties (append relevant-properties properties)))
	(if (every? fringe (lambda (f) (not (<<? f type))))
	    (set! fringe (cons type fringe)))))
    (maptypes check-type object)
    (let ((specials (unique-properties object)))
      (if (defined? specials)
	  (list fringe (append specials properties))
	  (list fringe properties)))))

(define (df x . properties)
  (let ((description (description-template x)))
    (printout $NL ">>>> The object " x
	      $NL ">>>> is in these classes (and their generalizations):")
    (for-each (lambda (c) (if (or show-complements-in-df (not (in? c complements)))
			      (printout $NL ">>>>        " c)))
	      (first description))
    (printout $NL ">>>> and has the following properties:")
    (maybe-describe-properties x properties)
    (maybe-describe-properties x (second description))))

(define (dt type) (df (->td type)))
    
