;;; -*- Mode: Scheme; Syntax: Scheme; Package: (SCHEME :USE (PSEUDOSCHEME)) -*-

(declare (usual-integrations)
	 (integrate-external "/u/kwh/programs/utility/plus")
	 (integrate-external "/u/kwh/programs/utility/mutable")
	 (integrate-external "/u/kwh/programs/utility/tuple")
	 (integrate-external "/u/kwh/programs/typical/kernel")
	 (integrate-external "/u/kwh/programs/cyrano/rel"))



;;;;;; Noticing extrema of mappings

(define (for-extrema procedure table)
  (let ((sum 0) (square-sum 0) (size 0))
    (define (gather-statistics key count)
      (set! size (1+ size))
      (set! sum (+ sum count))
      (set! square-sum (+ square-sum (* count count))))
    ((enumerator table) gather-statistics)
    (if (> size 0) 
	(let ((mean (/ sum size)) (square-mean (/ square-sum size)))
	  (let ((standard-deviation  (sqrt (-  square-mean (* mean mean)))))
	    (define (note-extrema key count)
	      (if (> (abs (/ (- count mean) standard-deviation)) 3)
		  (procedure key count size mean standard-deviation)))
	    (message $NL "### Analysis results: samples=" size ", mean=" mean
		     ", standard deviation=" standard-deviation)
	    ((enumerator table) note-extrema))))))


;;;; Noticing extremal elements.

(define (property-analysis class property extrema-function)
  (let* ((key (list 'FREQUENCY property class))
	 (frequency (td-property key))
	 (mutate-frequency! (mutator frequency))
	 (source (get-instance-generator class))
	 (space (mapping-constraint property class))
	 (sample-count 0))
    (define (enumerate-frequencies proc)
      (define (check-type t)
	(if (defined? (frequency t)) (proc t (frequency t))))
      (for-each check-type (collection-elements potential-foci)))
    (define (sample-example ex)
      (let ((result (property ex)) (satisfied-types ()))
	(define (note-satisfaction t)
	  (if (not (and space  (<<? space t)))
	      ;; It might be a good idea to just check declared
	      ;; potential foci, but I don't know...
	      (set! satisfied-types (cons t satisfied-types))))
	(define (increment-bucket x) (if (undefined? x) 1 (1+ x)))
	(maptypes note-satisfaction result)
	(for-each (lambda (x) (mutate-frequency! x increment-bucket))
		  satisfied-types)
	(set! sample-count (1+ sample-count))))
    (define (progress-reporter)
      (printout "Analyzed " ($count sample-count "instance")
		" of the " ($procedure property) " of " class))
    (define (countdown from)
      (if (= from 0)
	  (sequence (for-extrema extrema-function frequency)
		    (go countdown 20))
	  (let ((attempt (source)))
	    (if (undefined? attempt) (go countdown from)
		(sequence (sample-example attempt)
			  (go countdown (-1+ from)))))))
    (progress-reporter! progress-reporter)
    (go countdown 50)))

(define (generate-image-specialization of-type mapping type)
  (let ((speczn (<AND> of-type (image-constraint left (complement subtype)))))
    (infer-given! right-deterministic of-type speczn)
    (infer-given! left-deterministic  of-type speczn)
    (infer-given! symmetric-relations of-type speczn)
    (infer-given! reflexive-relations of-type speczn)
    (focus! speczn)))

(define (find-left-extrema relation)
  (let ((extremal-types ()))
    (define (process-extrema subtype frequency sample-size mean sd)
      (cond ((memq subtype extremal-types) #F)
	    ((< frequency mean)
	     (message $NL "### !!! " (/ frequency sample-size)
		      " of the LEFT's of " relation " satisfy " subtype)
	     (set! extremal-types (cons subtype extremal-types))
	     (generate-image-specialization relation left subtype))
	    ((not (= frequency sample-size))
	     (message $NL "### !!! " (/ frequency sample-size)
		      " of the LEFT's of " relation " satisfy " subtype)
	     (set! extremal-types (cons subtype extremal-types))
	     (generate-image-specialization relation left (complement subtype)))))
    (task property-analysis relation left process-extrema)))

(define (find-right-extrema relation)
  (let ((extremal-types ()))
    (define (process-extrema subtype frequency sample-size mean sd)
      (cond ((memq subtype extremal-types) #F)
	    ((< frequency mean)
	     (message $NL "### !!! " (/ frequency sample-size)
		      " of the RIGHT's of " relation " satisfy " subtype)
	     (set! extremal-types (cons subtype extremal-types))
	     (generate-image-specialization relation right subtype))
	    ((not (= frequency sample-size))
	     (set! extremal-types (cons subtype extremal-types))
	     (message $NL "### !!! " (/ frequency sample-size)
		      " of the RIGHT's of " relation " satisfy " subtype)
	     (generate-image-specialization relation right (complement subtype)))))
    (task property-analysis relation right process-extrema)))


;;;; Defining cumulative properties of types.

(define (make-property-type property type)
  (let* ((property-type (declarable-type (mapping-constraint property type)))
	 (declare! (collection-modifier property-type)))
    (define (get-and-declare x)
      (let ((result (property x)))
	(declare! result #T)
	result))
    (add-generator! get-and-declare property type)
    (add-daemon! get-and-declare type)
    property-type))



