;;; -*- Mode: Scheme; Syntax: Scheme; Package: (SCHEME :USE (PSEUDOSCHEME)) -*-

(declare (usual-integrations)
	 (integrate-external "/u/kwh/programs/utility/plus")
	 (integrate-external "/u/kwh/programs/utility/mutable")
	 (integrate-external "/u/kwh/programs/utility/tuple")
	 (integrate-external "/u/kwh/programs/typical/kernel")
	 (integrate-external "/u/kwh/programs/cyrano/rel"))



;;;; Algebraic relations

(define algebraic-relations
  (type "Algebraic Relations"
	<AND> pairings (complement lisp-application-types)))


;;;; Checking reflexive relations.

(define reflexive-relations
  (type "Reflexive Relations" empirical-class algebraic-relations
	(lambda (r) (<AND> eq-pairs (relation-space r)))
	(lambda (r) r)))

(define anti-reflexive-relations
  (type "Anti-Reflexive Relations" empirical-class algebraic-relations
	(lambda (r) (<AND> eq-pairs (relation-space r)))
	(lambda (r) (complement r))))


;;;; Checking symmetric relations.

(define symmetric-relations
  (type "Symmetric Relations" empirical-class algebraic-relations
	(lambda (rel) (<AND> (inverse-relation rel) (complement eq-pairs)))
	identity))
(define anti-symmetric-relations
  (type "Anti-Symmetric Relations" empirical-class algebraic-relations
	(lambda (rel) (<AND> (inverse-relation rel) (complement eq-pairs)))
	complement))



;;;; Algebraic Clusters

(define (make-clustering-abstraction relation)
  (let* ((cluster-space (<AND> (right-constraints relation)
			       (left-constraints relation)))
	 (cluster-collection
	  (generated-collection (subtypes-of cluster-space))))
    (define (make-cluster around-left)
      (define (in-cluster? right)
	(satisfies? (tuple around-left right) relation))
      (type (list "Left Cluster of " relation " around " around-left)
	    simple-type in-cluster? cluster-space))
    (let ((make-new-cluster
	   (collection-generator cluster-collection make-cluster)))
      (define (get-cluster for-x)
	(define (find-cluster among-clusters)
	  (if (null? among-clusters) (make-new-cluster for-x)
	      (if (in? for-x (first among-clusters))
		  (first among-clusters)
		  (find-cluster (rest among-clusters)))))
	(find-cluster (collection-elements cluster-collection)))
      (make-abstraction
       (function! (simple-cache get-cluster) cluster-space cluster-collection
		  relation "-CLUSTER")))))
(define clustering-abstraction-cache (td-property 'clustering-abstraction))
(define clustering-abstraction
  (generate-memoizer clustering-abstraction-cache make-clustering-abstraction))


;;;; Reducing operations

(define reducing-operations
  (type "Reducing Operations" <AND>
	implemented-operations many-to-one
	(image-constraint tuple-type->type-tuple >>?-rel)
	(image-constraint tuple-type->type-tuple (complement eq-pairs))))

