/* Zcodeerror.c zilla 23aug91 .
 * keep in a separate file so programs can use routines in libz but
 * define their own Zcodeerror.
 * modified
 * 28apr        bugfix in varargs version
 * 22           apr ansiupdates
 * 5mar         perror()
 */

#include <theusual.h>

#if Evarargs
# include <varargs.h>
#endif
#if Estdarg
# include <stdarg.h>
#endif


#if !Eunix
# define perror(msg)
#endif

#if (Estdarg&&Evprintf)
#define _Zcodeerror_def_
proc Zcodeerror(char *msg,...)
{
    va_list ap;

    fflush(stdout);
    perror("");
    va_start(ap,msg);
    fprintf(stderr,"CODEERROR: ");
    vfprintf(stderr,msg,ap);
    putc('\n',stderr);
    va_end(ap);
    abort();
}
#endif

#if (Evarargs&&Evprintf)
#define _Zcodeerror_def_
proc Zcodeerror(va_alist)
 va_dcl
{
    va_list ap;
    char *msg;
    
    fflush(stdout);
    perror("");
    va_start(ap);
    msg = va_arg(ap,char *);
    fprintf(stderr,"CODEERROR: ");
    vfprintf(stderr,msg,ap);
    putc('\n',stderr);
    va_end(ap);
    abort();
}
#endif

#ifndef _Zcodeerror_def_
Zcodeerror(msg)
  char *msg;
{
    fflush(stdout);
    perror("");
	fprintf(stderr,"CODEERROR: %s\n",msg);
    abort();
}
#endif
#undef _Zcodeerror_def_
