;;;;       PS3-TRI.SCM
;;; This is code for problem set 3.
;;;  It implements a Henderson-like
;;;  drawing language, based on triangles.

;;; vectors and operations on vectors

(define (vector-shift v o1 o2)
  (vector-sub (vector-add v o1) o2))


;;; representing triangles

(define make-triangle list)

(define triangle-origin car)
(define triangle-side1 cadr)
(define triangle-side2 caddr)

;;; a triangle defines a map on points

(define (coord-map triangle)
  (define (triangle-map point)
    (vector-add
     (vector-add (vector-scale (vector-xcor point)
			       (triangle-side1 triangle))
		 (vector-scale (vector-ycor point)
			       (triangle-side2 triangle)))
     (triangle-origin triangle)))
  triangle-map)


;;; Making a picture from a list of segments

(define make-segment cons)
(define segment-start car)
(define segment-end cdr)

(define (segments->drawing seglist)
  (define (drawing triangle)
    (let ((m (coord-map triangle)))
      (for-each
       (lambda (segment)
	 (drawline (m (segment-start segment))
		   (m (segment-end segment))))
       seglist)))
  drawing)


;;; one means of combination

(define (split pict1 pict2 ratio)
  (define (combo triangle)
    (let ((p (vector-scale ratio (triangle-side1 triangle)))
	  (oa (triangle-origin triangle)))
      (let ((ob (vector-shift p oa zero-vector)))
	(pict1
	 (make-triangle oa p (triangle-side2 triangle)))
	(pict2
	 (make-triangle ob
			(vector-shift (triangle-side1 triangle) oa ob)
			(vector-shift (triangle-side2 triangle) oa ob))))))
  combo)

;;; some simple drawings

(define empty-drawing (segments->drawing '()))

(define outline-drawing-segments
  (let ((v1 (make-vect 0 0))
	(v2 (make-vect 0 1))
	(v3 (make-vect 1 0)))
    (list (make-segment v1 v2)
	  (make-segment v2 v3)
	  (make-segment v3 v1))))

(define outline-drawing
  (segments->drawing outline-drawing-segments))

(define midpoints-segments
  (let ((center (make-vect (/ 1 3) (/ 1 3)))
	(m1 (make-vect (/ 1 2) 0))
	(m2 (make-vect 0 (/ 1 2)))
	(m3 (make-vect (/ 1 2) (/ 1 2))))
    (list (make-segment m1 center)
	  (make-segment m2 center)
	  (make-segment m3 center))))

(define midpoints 
  (segments->drawing midpoints-segments))


(define band-segments
  (let ((a1 (make-vect .4 0))
        (a2 (make-vect .6 0))
        (b1 (make-vect 0 .4))
        (b2 (make-vect 0 .6)))
    (list (make-segment a1 b1)
	  (make-segment a2 b2))))

(define band
  (segments->drawing band-segments))


(define v-shape-segments
  (let ((m1 (make-vect (/ 2 9) (/ 2 9)))
        (m2 (make-vect (/ 4 9) (/ 4 9)))
        (a1 (make-vect (/ 1 3) 0))
        (a2 (make-vect (/ 2 3) 0))
        (b1 (make-vect 0 (/ 1 3)))
        (b2 (make-vect 0 (/ 2 3))))
    (list (make-segment a1 m1)
	  (make-segment m1 b1)
	  (make-segment a2 m2)
	  (make-segment m2 b2))))

(define v-shape
  (segments->drawing v-shape-segments))

;;; drawing lines

(define *current-window*)

(define (draw window pict)
  (if (not (graphics-device? window))
      (error "Bad window" window))
  (graphics-clear window)
  (set! *current-window* window)
  (pict (screen-triangle window)))

(define (screen-triangle window)
  (with-values 
      (lambda ()
	(graphics-coordinate-limits window))
    (lambda (west south east north)
      (let ((screen-lower-left (make-vect west south))
	    (screen-lower-right (make-vect east south))
	    (screen-upper-left (make-vect west north)))
	(let ((screen-lower-edge
	       (vector-sub screen-lower-right screen-lower-left))
	      (screen-left-edge
	       (vector-sub screen-upper-left screen-lower-left)))
	  (make-triangle screen-lower-left
			 (vector-add screen-left-edge
				     (vector-scale 0.5
						   screen-lower-edge))
			 screen-lower-edge))))))

(define (drawline start end)
  (graphics-draw-line *current-window*
		      (exact->inexact (vector-xcor start))
		      (exact->inexact (vector-ycor start))
		      (exact->inexact (vector-xcor end))
		      (exact->inexact (vector-ycor end))))
