;;; ps1go.scm ldb 11-jan-1993

;;; Changed window sizes to make printer work... Cannot print larger than 
;;; about 512x512 picture. -- GJS


;;make Edwin window narrower, to allow room for graphics window
(in-package (->environment '(edwin x-commands))
  (using-syntax (access edwin-syntax-table (->environment '(edwin)))
    ((ref-command x-set-size) 80 65)))


(if (lexical-unreferenceable? user-initial-environment
			      'lissajous-window)
    (define lissajous-window false))

(define (start-lissajous-graphics)
  (if lissajous-window (graphics-close lissajous-window))
  (set! lissajous-window (make-window 512 512 -10 +300))
  (graphics-set-coordinate-limits lissajous-window -1.0 -1.0 1.0 1.0)
  (graphics-operation lissajous-window 'set-window-name "Lissajous Window"))

;(define (close-lissajous-graphics)
;  (graphics-close lissajous-window))

(define (lissajous-draw-to x y)
  (graphics-drag-cursor   lissajous-window   x   y))
(define (lissajous-go-to x y)
  (graphics-move-cursor   lissajous-window   x   y))
(define (clear-lissajous-graphics)
  (graphics-clear lissajous-window))
(start-lissajous-graphics)
;(close-lissajous-graphics)
;(graphics-close graphics-window)


(if (lexical-unreferenceable? user-initial-environment
			      'waveform-window)
    (define waveform-window false))

(define (start-waveform-graphics)
  (if waveform-window (graphics-close waveform-window))
  (set! waveform-window (make-window 512 256 -10 +10))
  (graphics-set-coordinate-limits waveform-window 0.0 -1.0 1.0 1.0)
  (graphics-operation waveform-window 'set-window-name "Waveform Window"))

;(define (close-waveform-graphics)
;  (graphics-close waveform-window))

(define (waveform-draw-to x y)
  (graphics-drag-cursor   waveform-window   x   y))
(define (waveform-go-to x y)
  (graphics-move-cursor   waveform-window   x   y))
(define (clear-waveform-graphics)
  (graphics-clear waveform-window))
(start-waveform-graphics)
;(close-waveform-graphics)
;(graphics-close graphics-window)

