;;; -*- Mode: LISP -*-
(setq limit 5.)


;; do a 1d version first

(defun drop-can ()
  (let ((x (- (random (1+ (* 2 limit))) limit)))
    (setq x-can-position x)))

(defun found-it? (pos)
  (<= (abs (- pos x-can-position)) 1))

;; do a version where don't limit steps out... ask what is wrong

(defun random-search (x)
  (print x)
  (cond ((found-it? x)
	 (print 'found-it!!)
	 t)
	((= x limit) (random-search (1- x)))
	((= x (- limit)) (random-search (1+ x)))
	((= (random 2) 0)			;flip a can
	 (random-search (1- x)))
	(t (random-search (1+ x)))))

;;; need a way of both telling when have found can, and of counting
;;; how many steps... since don't have compound data yet, use
;;; unmitigated hack of letting sign of count indicate location

(defun random-search-count (x search)
  (print x)
  (cond ((found-it? x)
	 (print 'found-it!!)
	 search)
	((= x limit) (random-search-count (1- x) (1+ search)))
	((= x (- limit)) (random-search-count (1+ x) (1+ search)))
	((= (random 2) 0)			;flip a coin
	 (random-search-count (1- x) (1+ search)))
	(t (random-search-count (1+ x) (1+ search)))))

(defun careful-search (x steps-out)
  (print x)
  (cond ((found-it? x)
	 (print 'found-it!!)
	 t)
	((= x limit) nil)
	((= x (- limit)) nil)
	((= steps-out (* 2 limit)) nil)
	(t (or (careful-search (1+ x) (1+ steps-out))
	       (careful-search (1- x) (1+ steps-out))))))

(defun careful-search-count (x steps-out search)
  (print x)
  (cond ((found-it? x)
	 (print 'found-it!!)
	 (- search))				; negative sign says have found
	((= x limit) search)			;dont' go out any further
	((= x (- limit)) search)
	((= steps-out (* 2 limit)) search)
	(t (let ((count (careful-search-count (1+ x) (1+ steps-out) (1+ search))))
	     (cond ((< count 0)			; if true, have found, so simply
						;return value
		    count)
		   (t 
		    (careful-search-count (1- x) (1+ steps-out) (1+ count))))))))

(defun linear-search (x)
  (or (linear-search-aux x 1)
      (linear-search-aux x -1)))

(defun linear-search-aux (x increment)
  (print x)
  (cond ((found-it? x)
	 (print 'found-it!!)
	 t)
	((= x limit) nil)
	((= x (- limit)) nil)
	(t (linear-search-aux (+ x increment) increment))))

(defun linear-search-count (x search)
  (let ((count (linear-search-count-aux x 1 search)))
    (if (< count 0)
	count
	(linear-search-count-aux x -1 count))))

(defun linear-search-count-aux (x increment search)
  (print x)
  (cond ((found-it? x)
	 (print 'found-it!!)
	 (- search))
	((= x limit) search)
	((= x (- limit)) search)
	(t (linear-search-count-aux (+ x increment) increment (1+ search)))))

(defun metal-detector (pos)
  (if (> x-can-position pos)
      1
      -1))

(defun metal-linear-search (x)
  (print x)
  (cond ((found-it? x)
	 (print 'found-it!!)
	 t)
	(t (metal-linear-search (+ x (metal-detector x))))))

(defun metal-linear-search-count (x search)
  (print x)
  (cond ((found-it? x)
	 (print 'found-it!!)
	 (- search))
	(t (metal-linear-search-count (+ x (metal-detector x)) (1+ search)))))

(defun binary-search (pos low high)
  (print pos)
  (cond ((found-it? pos)
	 (print 'found-it!!)
	 t)
	((= (metal-detector pos) 1)
	 ;; go to high side
	 (binary-search (* .5 (+ low high))
			(* .5 (+ low high))
			high))
	(t
	 (binary-search (* .5 (+ low high))
			low
			(* .5 (+ low high))))))

(defun binary-search-count (pos low high search)
  (print pos)
  (cond ((found-it? pos)
	 (print 'found-it!!)
	 (- search))
	((= (metal-detector pos) 1)
	 ;; go to high side
	 (binary-search-count (* .5 (+ low high))
			      (* .5 (+ low high))
			      high
			      (1+ search)))
	(t
	 (binary-search-count (* .5 (+ low high))
			      low
			      (* .5 (+ low high))
			      (1+ search)))))

%(define metal-straight-search
%  (lambda ()
%    (define metal-search-aux
%       (lambda (x search)
%         (print x)
%         (cond ((found-it? x)
%                (print 'found-it!!)
%                (- search))
%               (t (metal-search-aux (+ x (metal-detector x)) (1+ search))))))))

%(define binary-search
%  (lambda ()
%    (define binary-aux (pos low high search)
%      (print pos)
%      (cond ((found-it? pos)
%             (print 'found-it!!)
%             (- search))
%            ((= (metal-detector pos) 1)
%             ;; go to high side
%             (binary-aux (* .5 (+ low high))
%                         (* .5 (+ low high))
%                         high
%                         (1+ search)))
%            (t
%             (binary-aux (* .5 (+ low high))
%                         low
%                         (* .5 (+ low high))
%                         (1+ search)))))
%    (binary-aux (- limit) (- limit) limit 1)))

