;;; This is the code for Problem Set 7  -- Fall 1989

(define (square x) (* x x))

(define print-stream
  (let ()
    (define (loop rest)
      (if (empty-stream? rest)
	  (princ ")")
	  (sequence
	   (princ (head rest))
	   (princ " ")
	   (loop (tail rest)))))
    (lambda (s)
      (print "([STREAM] ")
      (loop s))))

(define (add-streams s1 s2)
  (cond ((empty-stream? s1) s2)
	((empty-stream? s2) s1)
	(else
	 (cons-stream (+ (head s1) (head s2))
		      (add-streams (tail s1) (tail s2))))))

(define (scale-stream constant s)
  (map (lambda (x) (* constant x)) s))

(define (filter pred s)
  (if (empty-stream? s)
      the-empty-stream
      (if (pred (head s))
	  (cons-stream (head s) (filter pred (tail s)))
	  (filter pred (tail s)))))

(define (map proc s)
  (if (empty-stream? s)
      the-empty-stream
      (cons-stream (proc (head s))
		   (map proc (tail s)))))



(define (make-audio-signal d theta v b noise-bound signal-strength)
   ;; generate two signals, in noise, based on a distance d away, 
   ;; at angle theta, with baseline b
  (newline)
  (print "Making a signal")
  (let ((dist-left (sqrt (+ (square d) (square b) (* -2 d b (sin theta)))))
        (dist-right (sqrt (+ (square d) (square b) (* 2 d b (sin theta)))))
        (onset (+ (random 10) 10)))
    (newline)
    (print "distances are =")
    (print dist-left)
    (print dist-right)
    (let ((time-left (+ onset (round (/ dist-left v))))
          (time-right (+ onset (round (/ dist-right v))))
          (strength-left (/ signal-strength (square dist-left)))
          (strength-right (/ signal-strength (square dist-right))))
       (newline)
       (print "time onsets are =")
       (print time-left)
       (print time-right)
       (newline)
       (print "signals are =")
       (print strength-left)
       (print strength-right)
      (define (make-counter)
        (let ((x 0))
          (lambda ()
             (set! x (+ x 1))         
             x)))
      (define (gen-stream c strength timing-on)
        (cons-stream (if (> (c) timing-on)
                         (+ (random noise-bound) strength)
                         (random noise-bound))
                     (gen-stream c strength timing-on)))
       (let ((left-counter (make-counter))
             (right-counter (make-counter)))    
         (cons (gen-stream left-counter strength-left time-left)
               (gen-stream right-counter strength-right time-right))))))

(define signal-on 3)
(define signal-off 10)

(define (filter-list lst pred)
   (cond ((null? lst)
          '())
         ((pred (car lst))
          (cons (car lst) (filter-list (cdr lst) pred)))
         (else 
           (filter-list (cdr lst) pred))))

(define d-theta-values
  (let ((ang (* (/ 3.14159 180) 45)))
    (list (list 100 ang 10)
          (list 50 ang 80)    
          (list 20 ang 150))))

(define (make-audio-signal-multiple d-theta-list v b noise-bound signal-strength)
  (newline)
  (print "Making a multi-signal")
   ;; generate two signals, in noise, based on a distance d away, 
   ;; at angle theta, with baseline b
   (define (make-counter)
     (let ((x 0))
       (lambda ()
          (set! x (+ x 1))         
          x)))
  (define (compute-signal-factors d theta on)
    (let ((dist-left (sqrt (+ (square d) (square b) (* -2 d b (sin theta)))))
          (dist-right (sqrt (+ (square d) (square b) (* 2 d b (sin theta)))))
          (onset (+ (random 10) on)))
      (newline)
      (print "distances are =")
      (print dist-left)
      (print dist-right)
      (let ((time-left (+ onset (round (/ dist-left v))))
            (time-right (+ onset (round (/ dist-right v))))
            (strength-left (/ signal-strength (square dist-left)))
            (strength-right (/ signal-strength (square dist-right))))
         (newline)
         (print "time onsets are =")
         (print time-left)
         (print time-right)
         (newline)
         (print "signals are =")
         (print strength-left)
         (print strength-right)
         (list dist-left dist-right time-left time-right strength-left strength-right))))
   (let ((data (mapcar (lambda (x) (compute-signal-factors (car x) (cadr x) (caddr x)))
                       d-theta-list)))
      (let ((left-data (mapcar (lambda (x) (list (first x) (third x) (fifth x))) data))
            (right-data (mapcar (lambda (x) (list (second x) (fourth x) (sixth x))) data)))
      (define (gen-stream c data-list)
        (cons-stream (let ((time (c)))
                       (let
                           ((strength 
                            (filter-list (mapcar (lambda (datum)
                                                   (if 
                                                    (and (>= time (cadr datum))
                                                         (< time (+ (cadr datum) signal-on)))
                                                    (caddr datum)
                                                    nil))
                                               data-list)
                                         (lambda (x) x))))
                       (if strength
                         (+ (random noise-bound) (car strength))
                         (random noise-bound))))
                     (gen-stream c data-list)))
       (let ((left-counter (make-counter))
             (right-counter (make-counter)))    
         (cons (gen-stream left-counter left-data)
               (gen-stream right-counter right-data))))))

(define signal-velocity 1)
(define baseline 10)

(define trial-signal (make-audio-signal 500 (* (/ 3.14159 180) 45) signal-velocity
                                        baseline 10 50000000))

(define multiple-trial-signal (make-audio-signal-multiple d-theta-values signal-velocity
                                 baseline 10 500000))

(define (make-test-signal-multi noise)
   (make-audio-signal-multiple d-theta-values signal-velocity baseline noise 50000000))

(define (make-test-signal noise)
   (make-audio-signal 100 (* (/ 3.14159 180) 45) signal-velocity baseline noise 50000000))

(define left-signal (car trial-signal))
(define right-signal (cdr trial-signal))

(define left-signal-multi (car multiple-trial-signal))
(define right-signal-multi (cdr multiple-trial-signal))

(define mean 0)
(define dev 20)

(define (plot-stream s max-y num-vals)
  (define (sign x) (if (< x 0) -1 1))
  (define hp-screen-width 200)
  (define hp-screen-height 180)
  (define x-scale (* 2 (/ hp-screen-width num-vals)))
  (define y-scale (/ hp-screen-height max-y))
  (define (screen-x-point x)
    (round (- (* x x-scale)
	      hp-screen-width)))
  (define (screen-y-point y)
    (let ((intended-y (round (* y-scale y))))
      (if (> (abs intended-y) hp-screen-height)
	  (* (sign intended-y) hp-screen-height)
	  intended-y)))
  (define (iter s count)
    (if (> count num-vals)
	'done
	(sequence (draw-line-to (screen-x-point count)
				(screen-y-point (head s)))
		  (iter (tail s) (1+ count)))))
  (clear-graphics)
  (position-pen (screen-x-point 0)
		(screen-y-point (head s)))
  (iter (tail s) 1))

;; new additions 

(define (smooth st)
  (map (lambda (x) (* .5 x))
       (add-streams st (tail st))))

(define (smooth-n st n)
  (if (= n 0)
      st
      (smooth-n (smooth st) (-1+ n))))

(define (diff st)
  (add-streams  (scale-stream -1 st)
                (tail st)))



(define (mark st mean dev)
  (map (lambda (el) (if (> (abs (- el mean)) (* 3 dev))
                        1
                        0))
       st))

(define (get-signal-strength marked-st smooth-st)
  (cons-stream (if (= (head marked-st) 1)
                   (* .5 (+ (head smooth-st) (head (tail smooth-st))))
                   0)
               (get-signal-strength (tail marked-st) (tail smooth-st))))

(define (make-counter)
  (let ((x 0))
    (lambda ()
       (set! x (+ x 1))
       x)))

(define (dev-posns st)
  (let ((counter (make-counter)))
    (filter (lambda (x)
               (> (car x) 0))
            (map (lambda (x)
                    (list x (counter)))
                 st))))


(define (process-em lst rst smoothing v b)
   (let ((lsmooth (smooth-n lst smoothing))
         (rsmooth (smooth-n rst smoothing)))
     (let ((lvals (dev-posns (get-signal-strength (mark (diff lsmooth) mean dev)
                                                  lsmooth)))
           (rvals (dev-posns (get-signal-strength (mark (diff rsmooth) mean dev)
                                                  rsmooth))))
       (map (lambda (x)
                (compute-distance-and-angle (car x) (cadr x) (caddr x) v b))
            (measure-time-spread-and-signals lvals rvals)))))

(define (measure-time-spread-and-signals lst rst)
   (cons-stream (list (- (cadr (head lst)) (cadr (head rst)))
                      (car (head lst))
                      (car (head rst)))
                (measure-time-spread-and-signals (tail lst) (tail rst))))

(define (compute-distance-and-angle time-shift lsig rsig v b)
   (let ((theta (atan (- (* v time-shift))
                      (sqrt (- (square (* 2 b))
                               (square (* v time-shift))))))
         (dist (/ (* v time-shift)
                  (- (sqrt (/ rsig lsig)) 1))))
    (list dist theta)))



(define (first-n st n)
  (define (help st n sum)
    (if (= n 0)
        (cons sum st)
        (help (tail st) (-1+ n) (+ sum (head st)))))
  (help st n 0))

(define (set-up-sums st n)
  (let ((start (first-n st n)))
    (let ((sum (car start))
          (front (cdr start))
          (back st))
     (define running-sum
        (cons-stream sum
                     (add-streams running-sum
                                  (add-streams (scale-stream -1 back)
                                               front))))
     running-sum)))

(define (set-up-squares st n)
  (let ((sq-st (map square st)))
   (let ((start (first-n sq-st n)))
    (let ((sum (car start))
          (front (cdr start))
          (back sq-st))
     (define running-sum
        (cons-stream sum
                     (add-streams running-sum
                                  (add-streams (scale-stream -1 back)
                                               front))))
     running-sum))))

(define (mean-st st n)
  (map (lambda (x) (/ x n))
       (set-up-sums st n)))

(define (dev-st st n)
  (map sqrt
       (add-streams (map (lambda (x) (/ x n)) (set-up-squares st n))
                    (scale-stream -1 (map square (mean-st st n))))))


(define (glue-streams st1 st2 glue)
  (cond ((empty-stream? st1) (map (lambda (x) (glue nil x)) st2))
        ((empty-stream? st2) (map (lambda (x) (glue x nil)) st1))
        (else (cons-stream (glue (head st1) (head st2))
                           (glue-streams (tail st1) (tail st2) glue)))))

(define (glued-data st n)
  (glue-streams (nth-tail (round (/ n 2)) st)
                (glue-streams (mean-st st n)
                              (dev-st st n)
                              list)
                cons))

(define (nth-tail n st)
  (if (= (round n) 0)
      st
      (nth-tail (-1+ n) (tail st))))

(define dev-mag 3)

(define (new-mark st)
  ;; assumes st is a glued version of needed data
  (map (lambda (el) (let ((val (car el))
                          (mean (cadr el))
                          (dev (caddr el)))
                 (if (> (abs (- val mean)) (* dev-mag dev))	
                        1
                        0)))
       st))

(define (adaptive-process-em lst rst smoothing v b run-length)
   (let ((lsmooth (smooth-n lst smoothing))
         (rsmooth (smooth-n rst smoothing)))
     (let ((lvals (dev-posns (get-signal-strength
                                 (new-mark (glued-data (diff lsmooth) run-length))
                                 (nth-tail (/ run-length 2) lsmooth))))
           (rvals (dev-posns (get-signal-strength
                                 (new-mark (glued-data (diff rsmooth) run-length))
                                 (nth-tail (/ run-length 2) rsmooth)))))
       (map (lambda (x)
                (compute-distance-and-angle (car x) (cadr x) (caddr x) v b))
            (measure-time-spread-and-signals lvals rvals)))))

(define ones (cons-stream 1 ones))

(define integers (cons-stream 1 (add-streams ones integers)))