;;; Miscellany

(define (pick-random list)
  (list-ref list (random (length list))))

(define (with-odds n1 n2)
  (< (random n2) n1))


;;; Object produced by STARTS-WITH-ONE-OF

(define split-sentence
  (lambda (prefix suffix match-result)
     (list 'split (cons prefix suffix) match-result)))

;;; A rule is a combination of a pattern and a result for substitution 
;;; to be used if a match is found for the pattern.

(define (make-rule pattern substitute) 
  (list pattern substitute))

(define pattern car)

(define substitute cadr)


;;;

(define (make-response text memories)
  (list text memories))

(define (response-text reply)
  (car reply))

(define (response-memories reply)
  (cadr reply))


;;;

(define (memorize-list key values memories)
  (if (null? values)
      memories
      (memorize-list key
		     (cdr values)
		     (make-memory key
				  (car values)
				  memories))))


;;;

(define the-empty-memory '())

(define (make-memory key value memories)
   the-empty-memory)

;;; The abstraction barrier --------------------------------------------------


;;; The top-level procedure is SEE-MANAGER.
;;;  A student, for example Bob, starts up the whole thing by typing
;;;   (SEE-MANAGER 'BOB).  The manager introduces himself at the 
;;;    beginning of the conversation and has the last word at the end.

(define (see-manager name)
  (print (list 'hi name))
  (print '(i am the food services manager))
  (print (pick-random introductions))
  (manager-driver-loop 
    (make-memory 'student-name name
		 (memorize-list 'recipes student-fodder
				the-empty-memory)))
  (print (list 'goodbye name))
  (print '(eat well!)))

(define introductions
  '((how can I help you?)
    (did you like todays special?)
    (you look a bit ill today shall I get the stomach pump?)))


;;; The driver loop processes the sequence of interactions from the
;;; student by responding to each one in turn, until the student
;;; terminates the conversation.  The driver loop takes one argument,
;;; a set of memories, that summarizes the information that the
;;; manager has acquired in the current conversation.  The memories
;;; are organized by keys so that, for example, the student's name is
;;; stored, keyed by the symbol STUDENT-NAME, and the recipes are
;;; stored keyed by the symbol RECIPES.

(define (manager-driver-loop memory)
  (print '**)                    ;Issue prompt
  (let ((user-input (read-from-keyboard)))
    (cond ((scan-for (lambda (words)
		       (starts-with-one-of words conversation-stoppers))
		     user-input)
	   'done)
	  (else
	    ;; Note that a REPLY combines a textual response and new memories.
	    (let ((reply (construct-reply user-input memory)))
	      (print (response-text reply))
	      (manager-driver-loop (response-memories reply)))))))

;;; Sentence fragments which may be given by user to end conversation.
(define conversation-stoppers
  (list (make-rule '(goodbye) '())
	(make-rule '(i have to go to class now) '())))


;;; Select a method for generating the reply.  Note that in a COND, 
;;; if there is a predicate expression that is not FALSE and there is 
;;; no consequent specified in that clause, then the value of the
;;; COND expression is the value of the predicate expression.  Also note 
;;; that the value of this procedure must be a RESPONSE, made by 
;;; MAKE-RESPONSE, that contains a text part and new memories.

(define (construct-reply input memories)
  (cond ((process-gripe input memories))   ; FALSE unless gripe
	((with-odds 1 3)                   ; not FALSE one in three times
	 (make-response
	  (cond ((reflect-old-gripe memories))
		(else
		 (append (pick-random reflect-beginnings)
			 (reflect-input input normal-reflections))))
	  memories))
	(else
	  (make-response (pick-random general-advice)
			 memories))))

(define reflect-beginnings
  '((you say)
    (why do you say)
    (i am glad to hear that)
    ()))


;;; Processing of gripes

;;; Look for a gripe word in the input.  If there is at least one, reply
;;; and commit the gripe to memory for future regurgitation.
;;; Do reflect-input, substituting for gripes as well as I <-> you, etc.
;;; We must remember gripes, so that they can be repeatedly referred to.

(define (process-gripe input memories)
  (let ((gripe (scan-for (lambda (words)
			   (starts-with-one-of words gripe-reflections))
			 input)))
    (if gripe
	(make-response (reflect-gripe input)
		       (make-memory 'gripes input memories))
	false)))


(define (reflect-old-gripe memories)
  (let ((old-gripe (pick-random (recall 'gripes memories))))
    (if old-gripe
	(reflect-gripe old-gripe)
	false)))


(define (reflect-gripe gripe)
  (append (pick-random gripe-reply-beginnings)
	  (reflect-input gripe
			 (append normal-reflections gripe-reflections))))

(define gripe-reply-beginnings
  '((i cannot understand why you think that)
    (you really do not believe that)
    (it is awfully sad to think that)
    (i am sorry to hear that)
    ()))

(define gripe-reflections
  (list (make-rule '(expensive) '(high quality))
	(make-rule '(lousy cooks) '(experienced nutritional engineers))
	(make-rule '(rotten) '(aged))
	(make-rule '(tough) '(firm))
	(make-rule '(unfriendly) '(efficient))
	(make-rule '(stinks) '(is not to your liking))))

;;; Reflect-input

(define (reflect-input input reflections)
  (define (loop remaining-input)
    (if (null? remaining-input)
	'()
	(let ((split (starts-with-one-of remaining-input reflections)))
	  (if split
	      (append (match-result split) (loop (suffix split)))
	      (cons (car remaining-input)
		    (loop (cdr remaining-input)))))))
  (loop input))

(define normal-reflections
  (list (make-rule '(i) '(you))
	(make-rule '(we) '(us))
	(make-rule '(you) '(we))
	(make-rule '(us) '(we))
	(make-rule '(your) '(our))
	(make-rule '(my) '(your))))

(define general-advice
  '((make sure to eat something from each of the four basic food groups every day)
    (make sure to use up all of your validine credits before the end of the term)
    (have you brought your date to networks)
    (remember that laverdes does not take validine)
    (have you seen one of our nutritional counselors recently)))



;;; Asking for a recipe

(define recipe-query-prefixes
  (list (make-rule '(how do you make) '())
	(make-rule '(what is the recipe for) '())))


(define (do-not-know-recipe remaining-input)
  (append (pick-random unknown-recipe-introductions)
	  remaining-input))

(define unknown-recipe-introductions
  '((i do not know how to make)
    (i am not familiar with)
    (we do not have the technology to make)
    (you can ask our dietitian how to make)
    (ask george how to make)
    (your mother can tell you how to make)))

(define student-fodder
  (list (make-rule '(spaghetti with meat sauce)
		   '(mix 30 strands spaghetti with 1 gallon water
			 and boil for 2 minutes adding 1 ounce sauce))
	(make-rule '(veal parmesan)
		   '(grill 1 veal pattie with 1 pad cheese))
	(make-rule '(bubble gum pizza)
		   '(find 1 wad gum from under a chair
			  then boil and stretch to cover 1 ordinary pizza))))