;; code for problem set 2, spring 1990

(define limit 10.)                              ;set up global variable for grid size

(define can-pos 0)                              ;set up initial can position variable

(define drop-can
  (lambda ()
    (set! can-pos (- (random (+ 1 (* 2 limit))) limit))))   ; some magic for changing position

(define found-it?
  (lambda (x)
    (<= (abs (- x can-pos)) 1)))


(define metal-detector
  (lambda (x)
    (if (> (- can-pos x) 0)
        1
        -1)))

(define random-search
  (lambda ()
    (define random-search-aux
      (lambda (x search)
       ; x is current position, search is number of steps taken so far
       (princ x)  ; tell user where we are
       (cond ((found-it? x)    ; have we found it?
              (print 'found-it!!)  ; if yes, announce, and return number of steps searched
              search)
             ((= x limit) (random-search-aux (-1+ x) (1+ search)))
              ;  if we hit the upper limit, turn around
             ((= x (- limit)) (random-search-aux (1+ x) (1+ search)))
              ; ditto for lower limit
             ((= (random 2) 0)  ;otherwise, flip a coin and move
              (random-search-aux (-1+ x) (1+ search)))
             (else (random-search-aux (1+ x) (1+ search))))))
     (newline)
     (random-search-aux 0 1)))

(define careful-search
  (lambda ()
    (define careful-search-aux 
      (lambda (x search)
        (princ x)
        (cond ((found-it? x)
               (print 'found-it!!)
               (- search))    ; negative sign says have found
              ((= x limit) search)   ;don't go out any further
              ((= x (- limit)) search)
              (else (let ((count (careful-search-aux (1+ x) (1+ search))))
                   (cond ((< count 0)   ; if true, have found, so simply
                                        ;return value
                          count)
                         (else 
                          (careful-search-aux (-1+ x) (1+ count)))))))))
    (newline)
    (careful-search-aux 0 1)))

(define tester
  (lambda (no-of-trials strategy final-op update-op)
    (define updater (make-updater update-op))
    (define run-it
      (lambda (n stat)
        (if (= n no-of-trials)
            ; need to insert code here
            (sequence (drop-can)
                      (updater ;need to insert code here
                        )))))
    (run-it 0 0)))