;;; This is the file ps5-net.scm containing the support for data structures
;;;  used in 6.001 ps5 in spring 1986.

(define (make-node)
  (attach-type 'node '()))



(define (make-net terminals connections)
  (attach-type 'network
	       (list terminals connections)))

(define (terminals network)
  (if (is-type? network '(network))
      (car (contents network))
      (error network " is not a network -- TERMINALS.")))

(define (connections network)
  (if (is-type? network '(network))
      (cadr (contents network))
      (error network " is not a network -- CONNECTIONS.")))



(define (connect part node1 node2)
  (attach-type 'connection
	       (list part node1 node2)))

(define (connection-part connection)
  (if (is-type? connection '(connection))
      (car (contents connection))
      (error connection " is not a connection -- CONNECTION-PART.")))

(define (connection-node-1 connection)
  (if (is-type? connection '(connection))
      (cadr (contents connection))
      (error connection " is not a connection -- CONNECTION-NODE-1.")))

(define (connection-node-2 connection)
  (if (is-type? connection '(connection))
      (caddr (contents connection))
      (error connection " is not a connection -- CONNECTION-NODE-2.")))

(define (connection-nodes connection)
  (if (is-type? connection '(connection))
      (cdr (contents connection))
      (error connection " is not a connection -- CONNECTION-NODES.")))

;;; For your convenience, we include definitions of the two bridge 
;;;  networks given in the problem set.

(define r1 (make-resistor 10))
(define r2 (make-resistor 20))
(define r3 (make-resistor 30))
(define r4 (make-resistor 40))
(define r5 (make-resistor 50))

(define a (make-node))
(define b (make-node))
(define c (make-node))
(define d (make-node))

(define network-1
  (make-net (list a b)
	    (list (connect r1 a c)
		  (connect r2 a d)
		  (connect r3 c b)
		  (connect r4 d b)
		  (connect r5 c d))))

(define network-2
  (make-net (list c d)
	    (list (connect r1 a c)
		  (connect r2 a d)
		  (connect r3 c b)
		  (connect r4 d b)
		  (connect r5 c d))))


;;; Here are the definitions of IN-SERIES and IN-PARALLEL 

(define (in-parallel? part1 part2 network)
  (equal-set? (nodes part1 network)
	      (nodes part2 network)))

(define (in-series? part1 part2 network)
  (not (empty-set?
	(difference-set
	 (intersection-set (nodes part1 network) (nodes part2 network))
	 (union-set (reduce-set union-set
		       (map-set (lambda (part) (nodes part network))
			  (difference-set (all-parts network)
					  (make-set part1 part2))))
		    (terminals network))))))


