;code from problem set

(define (visit-doctor name)
  (print (list 'hello, name))
  (print '(what seems to be the trouble?))
  (doctor-driver-loop name))

(define (doctor-driver-loop name)
  (newline)
  (princ '**)
  (let ((user-response (read)))
    (cond ((equal? user-response '(goodbye))
	   (print (list 'goodbye, name))
	   (print '(see you next week)))
	  (else (print (reply user-response))
		(doctor-driver-loop name)))))

(define (reply user-response)
  (cond ((fifty-fifty)
	 (append (qualifier)
		 (change-person user-response)))
	(else (hedge))))

(define (fifty-fifty)
  (= (random 2) 0))

(define (qualifier)
  (pick-random '((you seem to think)
		 (you feel that)
		 (why do you believe)
		 (why do you say))))

(define (hedge)
  (pick-random '((please go on)
		 (many people have the same sorts of feelings)
		 (many of my patients have told me the same thing)
		 (please continue))))

(define (replace pattern replacement lst)
  (cond ((null? lst) '())
	((equal? (car lst) pattern)
	 (cons replacement
	       (replace pattern replacement (cdr lst))))
	(else (cons (car lst)
		 (replace pattern replacement (cdr lst))))))

(define (many-replace replacement-pairs lst)
  (cond ((null? replacement-pairs) lst)
        (else (let ((pat-rep (car replacement-pairs)))
		(replace (car pat-rep)
			 (cadr pat-rep)
			 (many-replace (cdr replacement-pairs)
				       lst))))))

(define (change-person phrase)
  (many-replace '((i you) (me you) (am are) (my your))
		phrase))

(define (pick-random lst)
  (nth (random (length lst)) lst))

(define (prob n1 n2)
  (< (random n2) n1))

(define (ask-patient-name)
  (print '(next!))
  (print '(who are you?))
  (car (read)))

