(if (lexical-unreferenceable? user-initial-environment 'stop-bank)
    (define stop-bank false))

(define (start-bank)

  ;; Most depositors are honest ... They work like this:

  (define (make-honest-depositor name authorization laziness accounts) 
    (let ((num-accounts (length accounts)))
      (define (depositor)
	(do-forever
	 (lambda ()
	   (let ((from (random num-accounts))
		 (to (random num-accounts))
		 (amount (random authorization)))
	     (let ((pocket (((list-ref accounts from) 'withdraw) name amount)))
	       (((list-ref accounts to) 'deposit) name pocket)))
	   (sleep-current-thread (random laziness)))))
      depositor))


  ;; Some depositors like to kite funds ... They work like this:


  (define (make-kiting-depositor name authorization laziness kite-time accounts) 
    (let ((num-accounts (length accounts)))
      (define (depositor)
	(do-forever
	 (lambda ()
	   (let ((from (random num-accounts))
		 (to (random num-accounts))
		 (amount (random authorization)))
	     (let ((pocket (((list-ref accounts from) 'withdraw) name amount)))
	       (sleep-current-thread (random kite-time))
	       (((list-ref accounts to) 'deposit) name pocket)))
	   (sleep-current-thread (random laziness)))))
      depositor))


  ;; Some depositors skim the "cream" off of their accounts:

  (define (make-skimming-depositor name authorization cream laziness accounts) 
    (let ((num-accounts (length accounts)))
      (define (depositor)
	(do-forever
	 (lambda ()
	   (let ((from (random num-accounts))
		 (to (random num-accounts))
		 (amount (random authorization)))
	     (let ((pocket (((list-ref accounts from) 'withdraw) name amount)))
	       (((list-ref accounts to) 'deposit)
		name
		(if (< cream pocket)
		    (- pocket cream)
		    pocket))))
	   (sleep-current-thread (random laziness)))))
      depositor))

  (define (make-auditor accounts laziness)
    (define (auditor)
      (do-forever
       (lambda ()
	 (do-audit accounts)
	 (sleep-current-thread laziness))))
    auditor)

  (define (do-forever thunk)
    (thunk)
    (do-forever thunk))

  (if stop-bank (stop-bank))

  (let ((mb (make-account 'publish '(robert-maxwell neil-bush) 10000000))
	(m  (make-account 'swiss013 '(robert-maxwell ivan-boesky jimmy-hoffa) 110000000))
	(b  (make-account 'for-dad '(neil-bush) 1000000))
	(r1  (make-account 'rnc1 '(neil-bush ivan-boesky) 1000000))
	(mh (make-account 'junk-bonds '(michael-milken leona-helmsley ivan-boesky r-altman) 20000000))
	(mt (make-account 'big-money '(michael-milken donald-trump ivan-boesky) 200000000))
	(mm (make-account 'bcci '(michael-milken robert-maxwell) 1000000))
	(ht  (make-account 'hotels '(donald-trump leona-helmsley) 20000000))
	(d1  (make-account 'dnc1 '(clark-clifford r-altman leona-helmsley) 20000000))
	(d2 (make-account 'dnc2 '(clark-clifford r-altman jimmy-hoffa) 1000000)))
    
    (let ((nb
	   (make-honest-depositor 'neil-bush 200 1000 (list mb b)))
	  (rmx
	   (make-honest-depositor 'robert-maxwell 1000 2000 (list mb m mm)))
	  (rml
	   (make-skimming-depositor 'michael-milken 1000 500 2000 (list mh mt mm)))
	  (dt
	   (make-honest-depositor 'donald-trump 10000 1000 (list mt ht)))
	  (lh
	   (make-kiting-depositor 'leona-helmsley 1000 1000 2000 (list mh ht d1)))
	  (cc
	   (make-honest-depositor 'clark-clifford 1000 1000 (list d1 d2)))
	  (ra
	   (make-honest-depositor 'r-altman 1000 1000 (list d1 d2 mh)))
	  (ib
	   (make-skimming-depositor 'ivan-boesky 1000 200 1000 (list mt m r1 mh)))
	  (jh
	   (make-skimming-depositor 'jimmy-hoffa 1000 200 1000 (list m d2)))


	  (cl (make-auditor (list mb m b r1 mh mt mm ht d1 d2) 20000)))

      (set! stop-bank (parallel-execute nb rmx rml dt lh cc ra ib jh cl))
      'running)))
