;;; MAPS.SCM
;;; code for 6.001 problem set 2, Fall 1993

(define (xy->curve fx fy)
  ;; receiver = (lambda (x y) ...)
  (lambda (receiver)
    (lambda (t)
      (receiver (fx t) (fy t)))))

(define horizontal-line
  (xy->curve identity (lambda (x) 0)))

(define unit-circle (xy->curve cos sin))

(define (generate n proc lo hi)
  ;; proc = (lambda (t) ...)
  (let ((dt (/ (- hi lo) n)))
    (define (iter count)
      (proc (+ lo (* count dt)))
      (if (>= count n)
          'done
          (iter (+ count 1))))
    (iter 0)))

(define (point-drawer window)
  (lambda (x y)
    (graphics-draw-point window
                         (exact->inexact x)
                         (exact->inexact y))))


(define (scaler-and-shifter xlo xhi ylo yhi)
  (let ((xsize (- xhi xlo)) (ysize (- yhi ylo)))
    (lambda (receiver)
      ;; receiver = (lambda (u v) ...)
      (lambda (x y)
        (receiver (/ (- x xlo) xsize)
                  (/ (- y ylo) ysize))))))


(define (plotc window curve tlo thi xlo xhi ylo yhi n)
  (graphics-clear window)
  (generate n
            (curve
             ((scaler-and-shifter xlo xhi ylo yhi)
              (point-drawer window)))
            tlo
            thi))

(define (flip-y curve)
  (lambda (receiver)
    (curve
     (lambda (x y)
       (receiver x (- y))))))


(define (scale curve s)
  (lambda (receiver)
    (curve
     (lambda (x y)
       (receiver (* s x) (* s y))))))

(define (translate curve x0 y0)
  (lambda (receiver)
    (curve (lambda (x y)
             (receiver (+ x x0)
                       (+ y y0))))))

(define (rotate curve theta)
  (let ((cth (cos theta)) (sth (sin theta)))
    (lambda (receiver)
      (curve
       (lambda (x y)
         (receiver
          (- (* cth x) (* sth y))
          (+ (* sth x) (* cth y))))))))

(define (superpose curve1 curve2)
  (lambda (receiver)
    (let ((plot1 (curve1 receiver))
          (plot2 (curve2 receiver)))
      (lambda (t)
        (plot1 t)
        (plot2 t)))))
          

(define (gosperize curve)
  (let ((p (scale curve (/ (sqrt 2) 2))))
    (superpose (translate (rotate p (/ pi 4)) -.25 .25)
               (translate (rotate p (/ -pi 4)) .25 .25))))


(define (make-transform s theta x1 y1 x2 y2)
  (let ((sx1 (* s x1))        ; x1,y1 after scaling
        (sy1 (* s y1)))
    (let ((rsx1 (- (* sx1 (cos theta))
                   (* sy1 (sin theta))))  ; after rotating
          (rsy1 (+ (* sx1 (sin theta))
                   (* sy1 (cos theta)))))
      (let ((dx (- x2 rsx1))    ;amount we need to shift
            (dy (- y2 rsy1)))
        (lambda (curve)
          (translate (rotate (scale curve s) theta)
                     dx dy))))))

;;; before running this, you need to
;; define the procedure param-gosperize

(define (param-gosper n angle-at)
  (if (= n 0)
      horizontal-line
      (param-gosperize (param-gosper (- n 1) angle-at)
                       (angle-at n))))

