
(define (user-print object)
  (cond ((compound-procedure? object)
         (write-line (list 'compound-procedure
			   (parameters object)
			   (procedure-body object)
			   '<procedure-env>)))
        ((compiled-procedure? object)
         (write-line '<compiled-procedure>))
        (else (write-line object))))

(define the-global-environment)
(define the-empty-environment '())

(define (init)
  (set! the-global-environment
	(extend-environment '() '() the-empty-environment))
  (set! scheme-variable-cache '())
  (go))

(define (go)
  (start rep))

(define (compile-input-to-val)
  (let ((input (prompt-for-command-expression "REP==>")))
    (remote-assign
     rep
     'val
     (build-instruction-list
      rep
      (statements (compile input 'val 'return))))))

(define rep
  (build-model
   '(env val continue proc argl)
   '(
       (perform (newline))
       (perform (display "========== Initializing REP Loop =========="))
     read-eval-print-loop
       (perform (initialize-stack))
       (perform (initialize-ops-counter))
       (perform (newline))
       (perform (display "----------------------------------------"))
       (perform (newline))
       (perform (compile-input-to-val))
     run-compiled-result
       (assign env the-global-environment)
       (assign continue print-result)
       (goto (fetch val))

     print-result
       (perform (user-print (fetch val)))
       (goto read-eval-print-loop)
     )))
