;;; -*- Scheme -*- PS9-OPEN.SCM

;;		     MASSACHUSETTS INSTITUTE OF TECHNOLOGY
;;	   Department of Electrical Engineering and Computer Science
;;	   6.001---Structure and Interpretation of Computer Programs
;;			     Fall Semester, 1992
;;
;;				 Problem Set 9

;;;; Compiler modifications for open-coded primitives with one and two operands

;;; This flag permits you to turn open coding on and off
(define *open-code-primitives?* false)

(define ( open-code!) (set! *open-code-primitives?*  true)  'open-coding)
(define (close-code!) (set! *open-code-primitives?* false) 'close-coding)

(define (compile-unknown-application app c-t-env target cont)
  (preserving
   'env
   (compile-expression (operator app) c-t-env 'fun 'next)
   (preserving 'fun
               (compile-operands (operands app) c-t-env)
               (compile-call target cont))))

(define (compile-application app c-t-env target cont)
  (define (unknown)
    (compile-unknown-application app c-t-env target cont))

  (let ((op (operator app)))
    (if (not *open-code-primitives?*)
	(unknown)
	(let ((open-coder-pair (assq op primitive-open-codings)))
	  (if (not open-coder-pair)
	      (unknown)
	      (open-code-primitive (cdr open-coder-pair)
				   app
				   c-t-env
				   target
				   cont))))))

(define (open-code-primitive open-coder app c-t-env target cont)
  (if (not (= (length (cdr app)) (open-coder-arity open-coder)))
      (error "open-code-primitive: Incorrect number of arguments"
	     app)
      (let ((regs (list-tail argument-registers
			     (- (length argument-registers)
				(open-coder-arity open-coder)))))
	(append-instruction-sequences
	 (compile-primitive-operands
	  (operands app)
	  regs
	  c-t-env)
	 (apply (open-coder-handler open-coder)
		(cons target regs))
	 (compile-continuation cont)))))

(define (compile-primitive-operands exps regs c-t-env)
  (cond ((null? regs)
	 (error "compiled-primitive-operands: Not enough registers"))
	((last-operand? exps)
	 (compile-expression (first-operand exps)
			     c-t-env
			     (car regs)
			     'next))
	(else
	 (preserving
	  'env
	  (compile-expression (first-operand exps)
			      c-t-env
			      (car regs)
			      'next)
	  (without-clobbering
	   (car regs)
	   (compile-primitive-operands (rest-operands exps)
				       (cdr regs)
				       c-t-env))))))

(define (without-clobbering reg seq)
  (if (modifies-register seq reg)
      (wrap-save-restore seq reg)
      seq))

(define argument-registers
  '(arg0 arg1 arg2 arg3))

(define (make-open-coder op-name arity handler)
  (cond ((zero? arity)
	 (error "make-open-coder: Cannot handle primitives with no arguments"
		op-name))
	((> arity (length argument-registers))
	 (error "make-open-coder: Primitive takes too many arguments"
		op-name))
	(else
	 (cons arity handler))))

(define (open-coder-arity oc)
  (car oc))

(define (open-coder-handler oc)
  (cdr oc))

(define (binary-open-coding op-name)
  (cons op-name
	(make-open-coder
	 op-name
	 2
	 (lambda (target op1 op2)
	   (open-code-binary op-name target op1 op2)))))

(define (unary-open-coding op-name)
  (cons op-name
	(make-open-coder
	 op-name
	 1
	 (lambda (target op1)
	   (open-code-unary op-name target op1)))))

(define (open-code-binary op-name target op1 op2)
  (make-register-assignment
   target
   (make-operation op-name
		   (make-fetch op1)
		   (make-fetch op2))))

(define (open-code-unary op-name target op1)
  (make-register-assignment
   target
   (make-operation op-name (make-fetch op1))))

(define primitive-open-codings
  (list (binary-open-coding '+)
	(binary-open-coding '-)
	(binary-open-coding '*)
	(binary-open-coding '/)
	(binary-open-coding '=)
	(binary-open-coding '<)
	(binary-open-coding '>)
	(binary-open-coding '>=)
	(binary-open-coding '<=)
	(binary-open-coding 'eq?)
	(binary-open-coding 'cons)
	(binary-open-coding 'expt)
	(unary-open-coding 'null?)
	(unary-open-coding 'atom?)
	(unary-open-coding 'zero?)
	(unary-open-coding 'car)
	(unary-open-coding 'cdr)
	(unary-open-coding  '1+)
	(unary-open-coding '-1+)
	))
