;;; -*- Mode:Scheme; Base:10 -*- PS9-HARM.SCM

;;		     MASSACHUSETTS INSTITUTE OF TECHNOLOGY
;;	   Department of Electrical Engineering and Computer Science
;;	   6.001---Structure and Interpretation of Computer Programs
;;			     Fall Semester, 1992
;;
;;				 Problem Set 9

;;;
;;; A particularly interesting family of harmonic series...
;;;

(define (H n k)
  ;;
  ;; H(0) = 0
  ;;
  ;; H(1) = 1
  ;;
  ;;        H(n-1) + H(n-2)
  ;; H(n) = ---------------
  ;;               k
  (if (< n 2)
      n
      (/ (+ (H (- n 1) k)
	    (H (- n 2) k))
	 k)))

(define (fib n)
  (H n 1))

(define (demonic n)		; i.e. 0.666666... (a.k.a. 2/3)
  (H n 2))


;; H(n) = Ar^n
;;
;; Ar^n = 1/k( Ar^n-1 + Ar^n-2)  [by subst into defn]
;;
;; 1 = 1/kr + 1/kr^2             [div by Ar^n]
;; 
;; kr^2 - r -1 = 0               [mult by kr^2]
;; 
;;          1 +/- sqrt(1 +4k)
;; z_1,2 =  -----------------    [binomial equ]
;;               2k
;;
;; H(n) = A_1((z_1)^2) + A_2((z_2)^2)
;;
;;        A_1     + A_2      = 0   [since H(0) = 0]
;;        A_1(z1) + A_2(z_2) = 1   [since H(1) = 1]
;;
;;========================================================================
;; Substituting  (- A_2) for A_1 and expanding z_1 and z_2:
;;
;;            k         / / 1 + sqrt(4k+1) \ n    / 1 - sqrt(4k+1) \ n \
;; H(n) = ---------- x | |  --------------  |  - |  --------------  |   |
;;        sqrt(4k+1)    \ \       2k       /      \       2k       /   /
;;========================================================================
;;
;;                 1
;;      = -----------------------  x  [ { 1 + sqrt(4k+1) }^n - { 1 - sqrt(4k+1) }^n ]
;;        2 (2k)^(n-1) sqrt(4k+1)

(define (closed-H k)
  (let ((frac (sqrt (+ (* 4 k) 1))))
    (let (( left-root (/ (+ 1 frac) (* 2 k))) ; z_1
	  (right-root (/ (- 1 frac) (* 2 k))) ; z_2
	  (    k/frac (/ k frac)))
      (list k
	    left-root
	    right-root
	    (list "k/frac = " k/frac)
	    (list "H(10)  = " (+ 0.0 (H 10 k)))
	    (list "H(14)  = " (+ 0.0 (H 14 k)))
	    (list "H(18)  = " (+ 0.0 (H 18 k)))
	    (list "H(20)  = " (+ 0.0 (H 20 k)))))))
	  
(define (stream-filter pred s)
  (cond ((empty-stream? s)
	 the-empty-stream)
	((pred (stream-first s))
	 (cons-stream (stream-first s)
		      (stream-filter pred (stream-rest s))))
	(else
	 (stream-filter pred (stream-rest s)))))

(define ones (cons-stream 1 ones))

(define (add-streams s1 s2)
  (cons-stream (+ (stream-first s1) (stream-first s2))
	       (add-streams (stream-rest s1) (stream-rest s2))))

(define ints (cons-stream 1 (add-streams ints ones)))

(define H-stream (stream-map ints closed-H))

(define H-rats   (stream-filter (lambda (triple)
				  (or (= (abs (numerator (second triple))) 1)
				      (= (abs (numerator (third  triple))) 1)))
				H-stream))


(define (stream-for-each proc s)
  (proc (head s))
  (stream-for-each proc (stream-rest s)))

(define (show x)
  (newline)
  (display x))


(define (show-H)
  (stream-for-each pp H-stream))

(define (show-rats)
  (stream-for-each pp H-rats))
