;;;;this is the file ps4gram.scm
;;;;It contains the driver loop and the rudimentary grammar. This is
;;;;the only file you need to modify in working on this problem set.

(define (driver-loop)
  (translate-and-run-input)
  (driver-loop))

(define (translate-and-run-input)
  (newline)
  (display "input-->")
  (let ((translation (sentence (read))))
    (if (eq? translation 'failed)
	(write-line "unrecognized command")
	(evaluate-in-global-env translation))))


(define (sentence exp)
  (try-rules
   exp
   '(
     (   (shade the blocks where (?? b block-restriction))  ;pattern
	 (shade-selected-blocks (lambda (block) (: b)))   ) ;skeleton
     )))


(define (block-restriction exp)
  (try-rules
   exp
   '(
     (   ((? vc value-comparison))
	 (: vc)   )
     )))

(define (value-comparison exp)
  (try-rules
   exp
   '(
     (  ((?? bv1 block-value) is (? r relation) than (?? bv2 block-value))
	((: r) (: bv1) (: bv2))   )
     )))

(define (relation exp)
  (cond ((eq? exp 'greater) '>)
        ((eq? exp 'less) '<)
        (else 'failed)))

(define (block-value exp)
  (try-rules
   exp
   '(
     (  ((? n num))
	(: n)  )
     (  (the (?? p pop-designation) (?? a age-restriction))
	(count-population block (: p) (: a))  )
     )))

(define (num exp)
  (if (number? exp)
      exp
      'failed))


(define (pop-designation exp)
  (try-rules
   exp
   '(
     (  (total population)
	(lambda (race-sex) true)  )
     (  ((? r race-group) (? s sex-group) population)
	(lambda (race-sex) (equal? race-sex '((: r) (: s))))  )
     )))

(define (sex-group exp)
  (if (memq exp '(male female))
      exp
      'failed))

(define (race-group exp)
  (if (memq exp '(white black asian amerind other))
      exp
      'failed))


(define (age-restriction exp)
  (try-rules
   exp
   '(
     ;;;fill in the approprate rule(s) here

     )))	  





