;;; table implementation for data-directed style

(define (make-table)
  (let ((local-table (cons '*table* nil)))
    (define (lookup key-1 key-2)
      (let ((subtable (assq key-1 (cdr local-table))))
	(if (null? subtable)
	    nil
	    (let ((pair (assq key-2 (cdr subtable))))
	      (if (null? pair)
		  nil
		  (cdr pair))))))
    (define (insert! key-1 key-2 value)
      (let ((subtable (assq key-1 (cdr local-table))))
	(if (null? subtable)
	    (set-cdr! local-table
		      (cons (cons key-1
				  (cons (cons key-2 value) nil))
			    (cdr local-table)))
	    (let ((pair (assq key-2 (cdr subtable))))
	      (if (null? pair)
		  (set-cdr! subtable
			    (cons (cons key-2 value)
				  (cdr subtable)))
		  (set-cdr! pair value))))))
    
    (define (dispatch m)
      (cond ((eq? m 'lookup-proc) lookup)
	    ((eq? m 'insert-proc!) insert!)
	    (else (error "Unknown operation - TABLE" m))))
    dispatch))

(define operation-table (make-table))
(define get (operation-table 'lookup-proc))
(define put (operation-table 'insert-proc!))
