;; the following code is used for problem set 3

;; initially we use our own constructors and selectors

(define make-star-coords
   (lambda (x y)
     (list x y)))

(define make-spot-coords
   (lambda (u v)
     (list u v)))

(define make-star list)

(define make-spot list)

;;  procedures for printing results

(define print-matches
   (lambda (matches)
     (if (null? matches)
         'done
         (sequence
           (newline)
           (print-match (car matches))
           (print-matches (cdr matches))))))

(define print-match
   (lambda (match)
     (if (null? match)
         (newline)
         (let ((star (car (car match)))
               (spot (cdr (car match))))
           (newline)
           (princ "(star ")
           (princ (star-name star))
           (princ " = spot ")
           (princ (spot-name spot))
           (princ ")")
           (print-match (cdr match))))))

;; some simple examples of stars and spots

(define trial-stars-1
  (list (make-star 'alpha (make-star-coords 0.0 1.0))
        (make-star 'beta (make-star-coords 0.0 0.0))
        (make-star 'gamma (make-star-coords 1.5 1.0))))

(define trial-spots-1
  (list (make-spot 1 (make-spot-coords 0.03 1.50))
        (make-spot 2 (make-spot-coords 1.00 1.52))
        (make-spot 3 (make-spot-coords 0.51 0.02))))


(define rest cdr)                ; to balance the use of first

(define find-all-matches                        ;top level function,
   (lambda (level-matcher stars spots)
      ;args are matcher for next star, list of stars and list of spots
     (match () stars spots level-matcher))) 

(define match
  (lambda (current-interp stars spots level-matcher)
     (cond ((null? stars)                ; if no more stars
            (print-match current-interp)
            (list current-interp))     ; make list of one interpretation
           (else 
            (level-matcher current-interp (first stars) (rest stars) () spots match)
              ; find all ways to extend current interpretation to match
              ; next star
              ))))

(define match-one-level
  (lambda (current star rest-stars used-spots unused-spots global-matcher)
    (if (null? unused-spots)   ; if no more spots
        ()              ; then empty interpretation
                ; else combine list of interpretations in which first
                ; star is matched to first spot, relative to current interpretation
                ; with list of interpretations in which first star is matched
                ; with all other possible spots
        (append (global-matcher (cons (list star (first unused-spots)) current)
                                rest-stars
                                (append used-spots (rest unused-spots))
                                match-one-level)
                (match-one-level current
                                 star
                                 rest-stars
                                 (cons (first unused-spots) used-spots)
                                 (rest unused-spots)
                                 global-matcher)))))



(define compute-transformation
  (lambda (xa ya xb yb ua va ub vb)
    (let ((dx (- xb xa))
          (dy (- yb ya))
          (du (- ub ua))
          (dv (- vb va))
          (xm (/ (+ xb xa) 2))
          (ym (/ (+ yb ya) 2))
          (um (/ (+ ub ua) 2))
          (vm (/ (+ vb va) 2)))
      (let ((pr (dot-and-cross dx dy du dv)))
        (let ((c (car pr))
              (s (cdr pr)))
           (let ((x0 (- xm (- (* c um) (* s vm))))
                 (y0 (- ym (+ (* s um) (* c vm)))))
              (list c s x0 y0)))))))

(define dot-and-cross
   (lambda (dx dy du dv)
      (let ((kc (+ (* dx du) (* dy dv)))
            (ks (- (* dy du) (* dx dv))))
        (normalize-c-s kc ks))))

(define normalize-c-s
  (lambda (kc ks)
     (if (and (zero? kc) (zero? ks))
         (error "KC = 0 and KS = 0")
         (let ((k (sqrt (+ (* kc kc) (* ks ks)))))
            (cons (/ kc k) (/ ks k))))))

(define map-uv-to-xy
   (lambda (u v trans)
      (let ((c (first trans))
            (s (second trans))
            (x0 (third trans))
            (y0 (fourth trans)))
         (cons (+ (- (* c u) (* s v)) x0)
               (+ (+ (* s u) (* c v)) y0)))))


(define magnitude-tolerance 1.0)

(define distance-tolerance 0.5)