;;;This is the first code file for the series-parallel circuit problem set

;;; Primitive electrical elements.

(define (make-resistor resistance)
  (attach-type 'resistor resistance))

(define (resistance-resistor resistor)
  (contents resistor))

(define (conductance-resistor resistor)
  (/ 1 (resistance-resistor resistor)))


;;; Compound electrical elements

(define (make-series ckt1 ckt2)
  (attach-type 'series-combination (list ckt1 ckt2)))

(define (make-parallel ckt1 ckt2)
  (attach-type 'parallel-combination (list ckt1 ckt2)))

(define (left-branch ckt)
  (if (is-type? ckt '(series-combination parallel-combination))
      (car (contents ckt))
      (error "Circuit " ckt " has no LEFT-BRANCH.")))

(define (right-branch ckt)
  (if (is-type? ckt '(series-combination parallel-combination))
      (cadr (contents ckt))
      (error "Circuit " ckt " has no RIGHT-BRANCH.")))


(define (conductance-parallel ckt)
  (+ (conductance (left-branch ckt))
     (conductance (right-branch ckt))))

(define (conductance-series ckt)
  (/ 1 (resistance ckt)))

(define (resistance-series ckt)
  (+ (resistance (left-branch ckt))
     (resistance (right-branch ckt))))

(define (resistance-parallel ckt)
  (/ 1 (conductance ckt)))


;;; Generic operations
;;; This method for handling generic operations is similar to the one
;;;used on page 134 of the text.  It differs in that the type of an
;;;object is not stripped off by the generic dispatch procedure.

(define (conductance ckt)
  (cond ((is-type? ckt '(resistor))
	 (conductance-resistor ckt))
	((is-type? ckt '(parallel-combination))
	 (conductance-parallel ckt))
	((is-type? ckt '(series-combination))
	 (conductance-series ckt))
	(else
	 (error "Unknown circuit type -- CONDUCTANCE" ckt))))

(define (resistance ckt)
  (cond ((is-type? ckt '(resistor))
	 (resistance-resistor ckt))
	((is-type? ckt '(parallel-combination))
	 (resistance-parallel ckt))
	((is-type? ckt '(series-combination))
	 (resistance-series ckt))
	(else
	 (error "Unknown circuit type -- RESISTANCE" ckt))))


;;; Type system for analysis tools

(define (attach-type type contents)
  (cons type contents))

(define (type datum)
  (if (not (atom? datum))
      (car datum)
      (error "Bad typed datum -- TYPE" datum)))

(define (contents datum)
  (if (not (atom? datum))
      (cdr datum)
      (error "Bad typed datum -- CONTENTS" datum)))

;;is-type? relies on the fact that the primitive MEMQ will return the
;;empty list if the TYPE of the DATUM is not in the LIST-OF-TYPES.
;;This is the kind of "convenience" that is responsible for the fact
;;that the empty list is considered to be "false" in almost all Lisp dialects.

(define (is-type? datum list-of-types)
  (memq (type datum) list-of-types))

