;;;This is the code file for the Prime-numbers problem set

;;;searching for divisors

(define (smallest-divisor n)
  (find-divisor n 2))

(define (find-divisor n test-divisor)
  (cond
   ((> (square test-divisor) n) n)
   ((divides? test-divisor n) test-divisor)
   (else (find-divisor n (+ test-divisor 1)))))

(define (square x) (* x x))

(define (divides? a b)
  (= (remainder b a) 0))

(define (prime? n)
  (= n (smallest-divisor n)))

;;;the Fermat test

;;;changed to use big-random instead of random
(define (fermat-test n)
  (define a (+ 2 (big-random (- n 2))))
  (= (expmod a n n) a))

(define (fast-prime? n times)
  (cond ((= times 0) t)
	((fermat-test n)
         (fast-prime? n (- times 1)))
        (else nil)))

(define (expmod b e m)
  (cond ((= e 0) 1)
        ((even? e)
         (remainder (square (expmod b (/ e 2) m))
                    m))
        (else
         (remainder (* b (expmod b (- e 1) m))
                    m))))        

(define (big-random n)
  (random (min n (expt 10 10))))

;;;from exercise 1.17 in book
;;;but some prints changed to princ
(define (timed-prime-test n)
  (define start-time (runtime))
  (define found-prime? (prime? n))
  (define elapsed-time (- (runtime) start-time))
  (print n)
  (cond (found-prime?
	 (princ " *** ")
	 (princ elapsed-time))))
