;;; Graphical routines for 9836:  To plot function FOO from -2 to 2 
;;;  every .1 on a graph with a box extending from -3 to 3 in
;;;  the x direction and from 0 to 14 in the y direction, and using
;;;  a line connecting adjacent graph points, say:
;;;      (plot ((box 'line) -3 3 0 14) (graph foo -2 2 .1))

;;; For quick-and-dirty line plotting of the function FOO with 
;;;  auto-ranging for the vertical scale, say:
;;;      (line-plot foo -2 2 .1)


;;; Screen size

(define maxx 255)
(define maxy 194)

(define first-point)

;;; Axis functions

(define ((box plot-type) xlow xhigh ylow yhigh)
  (let ((-maxx (- maxx)) (-maxy (- maxy))
	(xscale (/ (* 2 maxx) (- xhigh xlow)))
	(xoffset (* (/ (+ xhigh xlow) (- xhigh xlow)) maxx))
	(yscale (/ (* 2 maxy) (- yhigh ylow)))
	(yoffset (* (/ (+ yhigh ylow) (- yhigh ylow)) maxy)))
    (define base)
    (position-pen -maxx maxy)
    (draw-line-to -maxx -maxy)
    (draw-line-to maxx -maxy)
    (draw-line-to maxx maxy)
    (draw-line-to -maxx maxy)
    (if (eq? plot-type 'bar)
	(if (< -maxy (- yoffset) maxy)
	    (sequence
	     (set! base (- yoffset))
	     (position-pen -maxx base)
	     (draw-line-to maxx base))
	    (set! base -maxy)))
    (lambda (x y)
      (let ((px (- (* xscale x) xoffset))
	    (py (- (* yscale y) yoffset)))
	(if (and (<= -maxx px maxx) (<= -maxy py maxy))
	    (cond ((eq? plot-type 'point)
		   (draw-point px py))
		  ((eq? plot-type 'bold-point)
		   (draw-bold-point px py))
		  ((eq? plot-type 'bar)
		   (position-pen px base)
		   (draw-line-to px py))
		  ((eq? plot-type 'line)
		   (if first-point
		       (sequence
			(position-pen px py)
			(set! first-point false))
		       (draw-line-to px py)))
		  (else
		   (error "box: unknown plot-type " plot-type))))))))

(define (draw-bold-point px py)
  (draw-point px py)
  (draw-point (1+ px) py)
  (draw-point (-1+ px) py)
  (draw-point px (1+ py))
  (draw-point px (-1+ py)))

;;; Plotting function

(define (plot point-function . curves)
  (set! first-point true)
  (mapc (lambda (curve)
	  (mapc (lambda (point)
		  (apply point-function point))
		curve))
    curves))


;;; Graph generator

(define (graph function low high increment)
  (define real-high (+ high (/ increment 2)))
  (define (iter x ans)
    (if (> x real-high)
	ans
	(iter (+ x increment)
	      (cons (list x (function x))
		    ans)))) 
  (iter low '()))


(define (extent graph)
  (let ((xmin (caar graph)) (xmax (caar graph)) 
	(ymin (cadar graph)) (ymax (cadar graph)))
    (mapc (lambda (point)
	    (if (> xmin (car point)) (set! xmin (car point)))
	    (if (< xmax (car point)) (set! xmax (car point)))
	    (if (> ymin (cadr point)) (set! ymin (cadr point)))
	    (if (< ymax (cadr point)) (set! ymax (cadr point))))
	  (cdr graph))
    (list xmin xmax ymin ymax)))


(define ((tplot type) graph)
  (let ((ext (extent graph)))
    (print ext)
    (plot (apply (box type) ext) graph)))


(define (line-plot function low high increment)
  ((tplot 'line) (graph function low high increment)))

