
(define getopt:scan #f)
(define getopt:char #\-)
(define getopt:opt #f)
(define *optind* 1)
(define *optarg* 0)

(define (getopt argc argv optstring)
  (let ((opts (string->list optstring))
	(place #f)
	(arg #f)
	(argref (lambda () ((if (vector? argv) vector-ref list-ref)
			    argv *optind*))))
    (and
     (cond ((and getopt:scan (not (string=? "" getopt:scan))) #t)
	   ((>= *optind* argc) #f)
	   (else
	    (set! arg (argref))
	    (cond ((or (<= (string-length arg) 1)
		       (not (char=? (string-ref arg 0) getopt:char)))
		   #f)
		  ((and (= (string-length arg) 2)
			(char=? (string-ref arg 1) getopt:char))
		   (set! *optind* (+ *optind* 1))
		   #f)
		  (else
		   (set! getopt:scan
			 (substring arg 1 (string-length arg)))
		   #t))))
     (begin
       (set! getopt:opt (string-ref getopt:scan 0))
       (set! getopt:scan
	     (substring getopt:scan 1 (string-length getopt:scan)))
       (if (string=? "" getopt:scan) (set! *optind* (+ *optind* 1)))
       (set! place (member getopt:opt opts))
       (cond ((not place) #\?)
	     ((or (null? (cdr place)) (not (char=? #\: (cadr place))))
	      getopt:opt)
	     ((not (string=? "" getopt:scan))
	      (set! *optarg* getopt:scan)
	      (set! *optind* (+ *optind* 1))
	      (set! getopt:scan #f)
	      getopt:opt)
	     ((< *optind* argc)
	      (set! *optarg* (argref))
	      (set! *optind* (+ *optind* 1))
	      getopt:opt)
	     ((and (not (null? opts)) (char=? #\: (car opts))) #\:)
	     (else #\?))))))
